package com.dr.controller;


import com.dr.dto.TokenDTO;
import com.dr.filter.token.JwtHelper;
import com.nimbusds.jose.Payload;
import net.minidev.json.JSONObject;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletRequest;

public class BaseController {


	/**
	 * 解释token 获取token对象
	 * 
	 * @param request
	 * @param jwtHelper
	 * @return
	 */
	protected TokenDTO parseTokenData(HttpServletRequest request, JwtHelper jwtHelper) {
		String token = request.getHeader("token");
		if(token==null || "".equals(token)){
			token=request.getHeader("access_token");
		}
		Payload p = jwtHelper.parseTokenData(token);
		JSONObject jsonObject = p.toJSONObject();
		Assert.notNull(jsonObject, "token 不能为空");
		Assert.notNull(jsonObject.getAsString("uid"), "openid 不能为空");
		TokenDTO dto = new TokenDTO();
		dto.setUid(jsonObject.getAsString("uid"));
		dto.setId(Long.valueOf(jsonObject.getAsString("id")));
		return dto;
	}

}
