package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 数据统计-门店设备类型地域分布数据表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Data
@TableName("dr_shop_device_type_distribute_by_day")
public class DrShopDeviceTypeDistributeByDayEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 当天日期
	 */
	private String dailyTime;
	/**
	 * 设备类型code
	 */
	private String deviceTypeCode;
	/**
	 * 设备类型名称
	 */
	private String deviceTypeName;
	/**
	 * 设备数量
	 */
	private Integer deviceNum;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 门店所属国家名称
	 */
	private String shopCountryName;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegion;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;

}
