package com.dr.filter.token;


import com.dr.dto.BranchMoistenDTO;
import com.dr.util.WxAppletsConstant;
import com.nimbusds.jose.*;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 
 * @author jytao
 *
 */
@Component
public class JwtHelper {
	private final Logger log = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private RedisTemplate<String, String> redisTemplate;

	@Autowired
	private WxAppletsConstant appConstant;

	@Autowired
	private BranchMoistenDTO branchMoistenDTO;

	/**
	 * redis 缓存 数据
	 */
	public void putRedisTemplateToken(String key, String token, int expirationdate) {
		try {
			redisTemplate.opsForValue().set(key, token, expirationdate, TimeUnit.SECONDS);
		} catch (Exception e) {
			log.error("数据写入redis 失败");
			e.printStackTrace();
		}
	}

	public String getRedisTemplateToken(String key) {
		return redisTemplate.opsForValue().get(key);
	}

	/**
	 * redis 获取token 过期时间
	 */
	public Long getTokenExpirationDate(String key) {
		return redisTemplate.getExpire(key);
	}

	/**
	 * 秘钥
	 */
	private static final byte[] SECRET = "345R0d227691751vd04467df11ff67JU".getBytes();

	/**
	 * 初始化head部分的数据为 { "alg":"HS256", "type":"JWT" }
	 */
	private static final JWSHeader header = new JWSHeader(JWSAlgorithm.HS256, JOSEObjectType.JWT, null, null, null,
			null, null, null, null, null, null, null, null);

	/**
	 * 生成token，该方法只在用户登录成功后调用
	 * @param payload 可以存储用户id，token生成时间，token过期时间等自定义字段
	 * @return token 字符串,若失败则返回null
	 */
	public String createToken(Map<String, Object> payload) {
		String tokenString = null;
		// 创建一个 JWS object
		JWSObject jwsObject = new JWSObject(header, new Payload(new JSONObject(payload)));
		try {
			// 将jwsObject 进行HMAC签名
			jwsObject.sign(new MACSigner(SECRET));
			tokenString = jwsObject.serialize();
		} catch (JOSEException e) {
			log.error("签名失败 : {}", e.getMessage());
			e.printStackTrace();
		}
		return tokenString;
	}

	/***
	 * 重新设置过期时间
	 */
	public void setUpExpirationDate(String token,String type,Integer typedate) {
		try {
			JWSObject jwsObject = JWSObject.parse(token);
			Payload payload = jwsObject.getPayload();
			JSONObject jsonOBj = payload.toJSONObject();
			putRedisTemplateToken(type+ jsonOBj.get("uid").toString(), token, typedate);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 校验token是否合法，返回Map集合,集合中主要包含 state状态码 data鉴权成功后从token中提取的数据
	 * 该方法在过滤器中调用，每次请求API时都校验
	 * @param token
	 * @param access_token
	 * @return Map<String, Object>
	 */
	public Map<String, Object> validToken(String token,String access_token) {
		Map<String, Object> resultMap = new HashMap<String, Object>();
		String admintoken=null;

		if(token!=null){
			admintoken=token;
		}
		if(access_token!=null){
			admintoken=access_token;
		}
		try {
			JWSObject jwsObject = JWSObject.parse(admintoken);
			Payload payload = jwsObject.getPayload();
			JWSVerifier verifier = new MACVerifier(SECRET);
			JSONObject jsonOBj = payload.toJSONObject();
			// token校验成功（此时没有校验是否过期）
			resultMap.put("state", TokenState.VALID.toString());
			// 缓存中能否找到token
			String newtoken=null;
			Long expirationdate =null;
			String type=null;
			Integer typedate=0;
			if(token!=null){
				 newtoken = getRedisTemplateToken(appConstant.getBEOVERDUE_TOEKN()+ jsonOBj.get("uid").toString());
				expirationdate = getTokenExpirationDate(appConstant.getBEOVERDUE_TOEKN() + jsonOBj.get("uid").toString());
				type=appConstant.getBEOVERDUE_TOEKN();
				//TOKEN_DFT_EXPIRE_TIME
				typedate=appConstant.getTOKEN_DFT_EXPIRE_TIME();
			}
			if(access_token!=null){
				 newtoken = getRedisTemplateToken(branchMoistenDTO.getTOKEN()+ jsonOBj.get("uid").toString());
				expirationdate = getTokenExpirationDate(branchMoistenDTO.getTOKEN()+ jsonOBj.get("uid").toString());
				type=branchMoistenDTO.getTOKEN();
				typedate=branchMoistenDTO.getTOKENBEOVERDUE();
			}

			if (jwsObject.verify(verifier)) {
				// token是null或者token不一样
				if (newtoken == null || (!newtoken.equals(admintoken))) {
					resultMap.put("state", TokenState.EXPIRED.toString());
					// token过期
				} else if (expirationdate == -2) {
					resultMap.put("state", TokenState.EXPIRED.toString());
				} else {
					// 设置过期时间的token
					setUpExpirationDate(admintoken,type,typedate);
				}
				resultMap.put("data", jsonOBj);
			} else {
				// 校验失败
				log.info("传入token=\t" + admintoken);
				log.info("缓存token=\t" + newtoken);
				resultMap.put("state", TokenState.INVALID.toString());
			}
		} catch (Exception e) {
			resultMap.clear();
			resultMap.put("state", TokenState.INVALID.toString());
		}
		return resultMap;
	}

	public Object getToken(String key) {
		return redisTemplate.opsForValue().get(key);
	}

	/**
	 * 解析token，获取token中信息
	 * @param token
	 * @return Map<String, Object>
	 */
	public Payload parseTokenData(String token) {
		Payload payload = null;
		try {
			JWSObject jwsObject = JWSObject.parse(token);
			payload = jwsObject.getPayload();
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return payload;
	}
}
