package com.dr.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.dr.entity.DrLastYearSkinProblemByMonthEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description 数据统计-去年皮肤问题明细月表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Mapper
public interface DrLastYearSkinProblemByMonthMapper extends BaseMapper<DrLastYearSkinProblemByMonthEntity> {

    /**
     * 查询皮肤问题
     *
     * @param regionId 区域ID
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return DrLastYearSkinProblemByMonthEntity
     */
    List<DrLastYearSkinProblemByMonthEntity> selectSkinProblemRecommend(@Param("regionId") Long regionId, @Param("startTime") String startTime, @Param("endTime") String endTime);
}
