package com.dr.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dr.config.RabbitMqConfig;
import com.dr.constant.NewDataReportConstant;
import com.dr.filter.token.JwtHelper;
import com.dr.mapper.*;
import com.dr.service.*;
import com.dr.util.*;
import com.dr.vo.*;
import com.dr.dto.*;
import com.dr.entity.*;
import com.nimbusds.jose.Payload;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * @description 喵星球小程序数据报告
 * @author luocong
 * @date 2024/8/16 11:08
 * @version 1.0
 */
@Service
public class MeowShopDataReportServiceImpl implements IMeowShopDataReportService {

    //@Value("${METIS_BASE_URL}")
    //private String metisBaseUrl;
    @Autowired
    private AppConstantDTO appConstantDTO;

    @Autowired
    private WxAppletuserMapper wxAppletuserMapper;
    @Autowired
    private EmployeeManageMapper employeeManageMapper;
    @Autowired
    private IDrOrgAndShopDataCountService drOrgAndShopDataCountService;
    //@Autowired
    //private GestationRecordMapper gestationRecordMapper;
    //@Autowired
    //private ShopMapper shopMapper;
    //@Autowired
    //private DeviceTypeMapper deviceTypeMapper;
    //@Autowired
    //private ConsumManagerMapper consumManagerMapper;
    @Autowired
    private IDrEmployeeUseDeviceCountByDayService drEmployeeUseDeviceCountByDayService;
    @Autowired
    private IDrConsumableUseInfoByDayService drConsumableUseInfoByDayService;
    @Autowired
    private IDrShopDeviceTypeDistributeByDayService drShopDeviceTypeDistributeByDayService;
    @Autowired
    private IDrLastYearSkinProblemByMonthService drLastYearSkinProblemByMonthService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private IDrConsumableUseInfoByMonthService drConsumableUseInfoByMonthService;
    @Autowired
    private IConfigService configService;
    @Autowired
    private IDrDeviceTypeStartByMonthService drDeviceTypeStartByMonthService;
    //@Autowired
    //private DrDownloadCenterMapper drDownloadCenterMapper;
    public static final String BASE_REDIS_KEY = NewDataReportConstant.BASE_DR_REDIS_KEY + NewDataReportConstant.SKIN_PROB_REC_KEY;

    @Override
    public Result<NewDeviceAndConsumableVO> selectDeviceAndConsumable(HttpServletRequest request, JwtHelper jwtHelper) {
        Result<NewDeviceAndConsumableVO> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        LambdaQueryWrapper<DrOrgAndShopDataCountEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(DrOrgAndShopDataCountEntity::getDeleted, 0);
        if (parseTokenDTO.getPowerType().equals("1")) {
            //机构权限
            queryWrapper.eq(DrOrgAndShopDataCountEntity::getOrgAccount, parseTokenDTO.getOrgAccount());
        } else if (parseTokenDTO.getPowerType().equals("2")) {
            //门店
            queryWrapper.eq(DrOrgAndShopDataCountEntity::getShopAccount, parseTokenDTO.getShopAccount());
        }
        queryWrapper.eq(DrOrgAndShopDataCountEntity::getDeleted, 0);
        List<DrOrgAndShopDataCountEntity> list = this.drOrgAndShopDataCountService.list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        //设备总数
        Long deviceNum = list.stream().mapToLong(DrOrgAndShopDataCountEntity::getDeviceNum).sum();
        //耗材消耗总数
        Long consumableNum = list.stream().mapToLong(DrOrgAndShopDataCountEntity::getConsumableUseNum).sum();
        NewDeviceAndConsumableVO newDeviceAndConsumableVO = new NewDeviceAndConsumableVO();
        newDeviceAndConsumableVO.setDeviceNumber(deviceNum);
        newDeviceAndConsumableVO.setConsumableNumber(consumableNum);
        return result.ok(newDeviceAndConsumableVO);
    }

    @Override
    public Result<List<NewDeviceRealTimeVO>> selectDeviceRealTime(HttpServletRequest request, JwtHelper jwtHelper) {
        return null;
    }


    /*
    @Override
    public Result<List<NewDeviceRealTimeVO>> selectDeviceRealTime(HttpServletRequest request, JwtHelper jwtHelper) {
        Result<List<NewDeviceRealTimeVO>> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        Shop shop = this.shopMapper.selectByAccounts(parseTokenDTO.getShopAccount());
        LambdaQueryWrapper<GestationRecord> qw = new LambdaQueryWrapper<>();
        if (parseTokenDTO.getPowerType().equals("1")) {
            //机构权限
            qw.eq(GestationRecord::getOrgid, shop.getOrgid());
        } else if (parseTokenDTO.getPowerType().equals("2")) {
            //门店
            qw.eq(GestationRecord::getOrgid, shop.getId());
        }
        List<GestationRecord> gestationRecords = this.gestationRecordMapper.selectList(new LambdaQueryWrapper<GestationRecord>().eq(GestationRecord::getShopid, shop.getId())
                .orderByDesc(GestationRecord::getCid)
                .last("limit 5"));
        if (CollectionUtils.isEmpty(gestationRecords)) {
            return result;
        }
        Set<Integer> shopIds = gestationRecords.stream().map(GestationRecord::getShopid).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(shopIds)) {
            return result;
        }
        List<Shop> shops = this.shopMapper.selectBatchIds(shopIds);
        Map<Integer, String> shopMap = shops.stream().collect(Collectors.toMap(Shop::getId, Shop::getShopname));
        Set<String> deviceCodes = gestationRecords.stream().map(GestationRecord::getDevicecode).collect(Collectors.toSet());
        List<DeviceType> deviceTypes = this.deviceTypeMapper.selectBatchIds(deviceCodes);
        Map<String, String> deviceTypeMap = deviceTypes.stream().collect(Collectors.toMap(DeviceType::getCode, DeviceType::getName));
        Set<String> consumableNumbers = gestationRecords.stream().map(GestationRecord::getConsumablenumber).collect(Collectors.toSet());
        Map<String, String> conMap = new HashMap<>(5);
        if (!CollectionUtils.isEmpty(consumableNumbers)) {
            List<ConsumManager> consumManagers = this.consumManagerMapper.selectList(new LambdaQueryWrapper<ConsumManager>()
                    .in(ConsumManager::getConnum, consumableNumbers));
            conMap = consumManagers.stream().collect(Collectors.toMap(ConsumManager::getConnum, ConsumManager::getConname));
        }
        List<NewDeviceRealTimeVO> list = new ArrayList<>();
        for (GestationRecord gestationRecord : gestationRecords) {
            NewDeviceRealTimeVO newDeviceRealTimeVO = new NewDeviceRealTimeVO();
            LocalDateTime localDateTime = DateUtil.longToTimeStamp(gestationRecord.getData());
            newDeviceRealTimeVO.setStartTime(localDateTime);
            newDeviceRealTimeVO.setShopName(shopMap.get(gestationRecord.getShopid()));
            newDeviceRealTimeVO.setDeviceTypeName(deviceTypeMap.get(gestationRecord.getDevicecode()));
            newDeviceRealTimeVO.setClientName(gestationRecord.getClientname());
            newDeviceRealTimeVO.setEmployeeName(gestationRecord.getOptionname());
            newDeviceRealTimeVO.setConsumableTypeName(conMap.get(gestationRecord.getConsumablenumber()));
            list.add(newDeviceRealTimeVO);
        }
        return result.ok(list);
    }
     */

    @Override
    public Result<List<NewEmployeeRankVO>> selectEmpOperateRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, String[] shopAccount) {
        Result<List<NewEmployeeRankVO>> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        LambdaQueryWrapper<DrEmployeeUseDeviceCountByDayEntity> qw = new LambdaQueryWrapper<>();
        //日期 1-昨天 2-近七天 3-近三十天
        switch (flag) {
            case 2:
                String sevenDayTime = DateUtil.getBeforeTime(7, DateUtil.patternA, 1);
                qw.ge(DrEmployeeUseDeviceCountByDayEntity::getDailyTime, sevenDayTime);
                break;
            case 3:
                String thirtyDayTime = DateUtil.getBeforeTime(30, DateUtil.patternA, 1);
                qw.ge(DrEmployeeUseDeviceCountByDayEntity::getDailyTime, thirtyDayTime);
                break;
            default:
                String yesterday = DateUtil.getBeforeTime(1, DateUtil.patternA, 1);
                qw.ge(DrEmployeeUseDeviceCountByDayEntity::getDailyTime, yesterday);
                break;
        }
        if (parseTokenDTO.getPowerType().equals("1")) {
            //机构权限
            qw.eq(DrEmployeeUseDeviceCountByDayEntity::getOrgAccount, parseTokenDTO.getOrgAccount());
            List<String> shopAccounts = Arrays.asList(shopAccount);
            qw.in(!CollectionUtils.isEmpty(shopAccounts), DrEmployeeUseDeviceCountByDayEntity::getShopAccount, shopAccounts);
        } else if (parseTokenDTO.getPowerType().equals("2")) {
            //门店
            qw.eq(DrEmployeeUseDeviceCountByDayEntity::getShopAccount, parseTokenDTO.getShopAccount());
        }
        qw.eq(DrEmployeeUseDeviceCountByDayEntity::getDeleted, 0);
        List<DrEmployeeUseDeviceCountByDayEntity> drEmployeeUseDeviceCountList = this.drEmployeeUseDeviceCountByDayService.list(qw);
        List<NewEmployeeRankVO> list = new ArrayList<>();
        Map<String, Long> drEmployeeUseDeviceMap = drEmployeeUseDeviceCountList.stream()
                .collect(Collectors.groupingBy(DrEmployeeUseDeviceCountByDayEntity::getEmployeeName,
                        Collectors.summingLong(DrEmployeeUseDeviceCountByDayEntity::getOperateNum)))
                .entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder()))
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        Map.Entry::getValue,
                        (oldValue, newValue) -> oldValue,  // 处理键冲突，这里保留旧值
                        LinkedHashMap::new  // 保持顺序的 Map
                ));
        drEmployeeUseDeviceMap.forEach((k, v) -> {
            NewEmployeeRankVO newEmployeeRankVO = new NewEmployeeRankVO();
            newEmployeeRankVO.setEmployeeName(k);
            newEmployeeRankVO.setOperationNum(v);
            drEmployeeUseDeviceCountList.stream().filter(t -> t.getEmployeeName().equals(k)).findAny().ifPresent(t -> {
                newEmployeeRankVO.setShopName(t.getShopName());
            });
            list.add(newEmployeeRankVO);
        });
        return result.ok(list);
    }

    @Override
    public Result<PageUtils> selectShopConsumerRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, Integer pageNum, Integer pageSize) {
        //机构专属
        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0") || parseTokenDTO.getPowerType().equals("2")) {
            return result.error(-1, "无权限!");
        }
        LambdaQueryWrapper<DrConsumableUseInfoByDayEntity> qw = new LambdaQueryWrapper<>();
        //日期 1-昨天 2-近七天 3-近三十天
        switch (flag) {
            case 2:
                String sevenDayTime = DateUtil.getBeforeTime(7, DateUtil.patternA, 1);
                qw.ge(DrConsumableUseInfoByDayEntity::getDailyTime, sevenDayTime);
                //机构数据
                break;
            case 3:
                String thirtyDayTime = DateUtil.getBeforeTime(30, DateUtil.patternA, 1);
                qw.ge(DrConsumableUseInfoByDayEntity::getDailyTime, thirtyDayTime);
                break;
            default:
                String yesterday = DateUtil.getBeforeTime(1, DateUtil.patternA, 1);
                qw.ge(DrConsumableUseInfoByDayEntity::getDailyTime, yesterday);
                break;
        }
        qw.eq(DrConsumableUseInfoByDayEntity::getOrgAccount, parseTokenDTO.getOrgAccount());
        qw.eq(DrConsumableUseInfoByDayEntity::getDeleted, 0);
        List<DrConsumableUseInfoByDayEntity> drConsumableUseInfoByDayList = this.drConsumableUseInfoByDayService.list(qw);
        //耗材消耗总数
        long conNum = drConsumableUseInfoByDayList.stream().mapToLong(DrConsumableUseInfoByDayEntity::getDailyConsumableUseNum).sum();
        if (conNum == 0) {
            return result;
        }
        Map<String, Long> consumableMap = drConsumableUseInfoByDayList.stream()
                .collect(Collectors.groupingBy(DrConsumableUseInfoByDayEntity::getShopName,
                        Collectors.summingLong(DrConsumableUseInfoByDayEntity::getDailyConsumableUseNum)))
                .entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder()))
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        Map.Entry::getValue,
                        (oldValue, newValue) -> oldValue,
                        LinkedHashMap::new
                ));
        List<Map.Entry<String, Long>> pageList = consumableMap.entrySet().stream().skip((long) (pageNum - 1) * pageSize)
                .limit(pageSize)
                .collect(Collectors.toList());
        List<NewShopConsumableRankVO> list = new ArrayList<>();
        pageList.forEach(
                entry -> {
                    NewShopConsumableRankVO newShopConsumableRankVO = new NewShopConsumableRankVO();
                    newShopConsumableRankVO.setShopName(entry.getKey());
                    newShopConsumableRankVO.setOperationNum(entry.getValue());
                    BigDecimal ratio = new BigDecimal(entry.getValue().toString()).divide(new BigDecimal(Long.toString(conNum)), 2, RoundingMode.HALF_DOWN);
                    newShopConsumableRankVO.setRatio(ratio.toString());
                    list.add(newShopConsumableRankVO);
                }
        );
        return result.ok(new PageUtils(list, consumableMap.size(), pageSize, pageNum));
    }

    @Override
    public Result<PageUtils> selectRegionalDistribution(HttpServletRequest request, JwtHelper jwtHelper, String[] deviceCode, Integer pageNum, Integer pageSize) {
        //机构专属
        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0") || parseTokenDTO.getPowerType().equals("2")) {
            return result.error(-1, "无权限!");
        }
        LambdaQueryWrapper<DrShopDeviceTypeDistributeByDayEntity> qw = new LambdaQueryWrapper<>();
        List<String> deviceCodeList = Arrays.asList(deviceCode);
        qw.in(!CollectionUtils.isEmpty(deviceCodeList), DrShopDeviceTypeDistributeByDayEntity::getDeviceTypeCode, deviceCodeList);
        qw.eq(DrShopDeviceTypeDistributeByDayEntity::getOrgAccount, parseTokenDTO.getOrgAccount());
        qw.eq(DrShopDeviceTypeDistributeByDayEntity::getDeleted, 0);
        List<DrShopDeviceTypeDistributeByDayEntity> drShopDeviceTypeDistributeByDayList = this.drShopDeviceTypeDistributeByDayService.list(qw);
        if (CollectionUtils.isEmpty(drShopDeviceTypeDistributeByDayList)) {
            return result;
        }
        Map<String, Long> deviceDistMap = drShopDeviceTypeDistributeByDayList.stream()
                .collect(Collectors.groupingBy(DrShopDeviceTypeDistributeByDayEntity::getShopAddress,
                        Collectors.summingLong(DrShopDeviceTypeDistributeByDayEntity::getDeviceNum)))
                .entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder()))
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        Map.Entry::getValue,
                        (oldValue, newValue) -> oldValue,
                        LinkedHashMap::new
                ));
        List<Map.Entry<String, Long>> pageList = deviceDistMap.entrySet().stream().skip((long) (pageNum - 1) * pageSize)
                .limit(pageSize)
                .collect(Collectors.toList());
        List<NewDeviceDistributionVO> list = new ArrayList<>();
        pageList.forEach(
                entry -> {
                    NewDeviceDistributionVO newDeviceDistributionVO = new NewDeviceDistributionVO();
                    newDeviceDistributionVO.setProvinceName(entry.getKey());
                    newDeviceDistributionVO.setDeviceNum(entry.getValue());
                    list.add(newDeviceDistributionVO);
                }
        );
        return result.ok(new PageUtils(list, deviceDistMap.size(), pageSize, pageNum));
    }

    @Override
    public Result<NewClientAndCaseGroupVO> selectClientAndCase(HttpServletRequest request, JwtHelper jwtHelper) {
        Result<NewClientAndCaseGroupVO> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("oAccount", parseTokenDTO.getOrgAccount());
        if (parseTokenDTO.getPowerType().equals("2")) {
            paramMap.put("mAccount", parseTokenDTO.getShopAccount());
        }
        String body = HttpUtil.post(appConstantDTO.metisBaseUrl + "/new/dataReport/clientAndCase", paramMap);
        ApiTemplate apiTemplate = JSON.parseObject(body, ApiTemplate.class);
        if (!apiTemplate.getSign().equals(1)) {
            return result;
        }
        NewClientAndCaseGroupVO newClientAndCaseGroupVO = JSON.parseObject(apiTemplate.getData().toString(), NewClientAndCaseGroupVO.class);
        return result.ok(newClientAndCaseGroupVO);
    }

    @Override
    public Result<PageUtils> selectCheckCaseRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, Integer pageNum, Integer pageSize) {

        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0") || parseTokenDTO.getPowerType().equals("2")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("oAccount", parseTokenDTO.getOrgAccount());
        paramMap.put("pageNum", pageNum);
        paramMap.put("pageSize", pageSize);
        //日期 1-昨天 2-近七天 3-近三十天
        switch (flag) {
            case 2:
                String sevenDayTime = DateUtil.getBeforeTime(7, DateUtil.patternA, 1);
                paramMap.put("time", sevenDayTime);
                //机构数据
                break;
            case 3:
                String thirtyDayTime = DateUtil.getBeforeTime(30, DateUtil.patternA, 1);
                paramMap.put("time", thirtyDayTime);
                break;
            default:
                String yesterday = DateUtil.getBeforeTime(1, DateUtil.patternA, 1);
                paramMap.put("time", yesterday);
                break;
        }
        String body = HttpUtil.post(appConstantDTO.metisBaseUrl + "/new/dataReport/checkCaseRank", paramMap);
        ApiTemplate apiTemplate = JSON.parseObject(body, ApiTemplate.class);
        if (!apiTemplate.getSign().equals(1)) {
            return result;
        }
        List<NewCheckCaseRankVO> list = JSON.parseArray(apiTemplate.getData().toString(), NewCheckCaseRankVO.class);
        return result.ok(new PageUtils(list, apiTemplate.getTotal(), pageSize, pageNum));
    }

    @Override
    public Result<PageUtils> selectProductRecommend(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize) {

        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("pageNum", pageNum);
        paramMap.put("pageSize", pageSize);
        paramMap.put("oAccount", parseTokenDTO.getOrgAccount());
        if (parseTokenDTO.getPowerType().equals("2")) {
            paramMap.put("mAccount", parseTokenDTO.getShopAccount());
        }
        String body = HttpUtil.post(appConstantDTO.metisBaseUrl + "/new/dataReport/productRecommend", paramMap);
        ApiTemplate apiTemplate = JSON.parseObject(body, ApiTemplate.class);
        if (!apiTemplate.getSign().equals(1)) {
            return result;
        }
        List<NewProductRecommendVO> list = JSON.parseArray(apiTemplate.getData().toString(), NewProductRecommendVO.class);
        return result.ok(new PageUtils(list, apiTemplate.getTotal(), pageSize, pageNum));
    }

    @Override
    public Result<PageUtils> selectArriveShopRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, Integer pageNum, Integer pageSize) {
        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0") || parseTokenDTO.getPowerType().equals("2")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("oAccount", parseTokenDTO.getOrgAccount());
        paramMap.put("pageNum", pageNum);
        paramMap.put("pageSize", pageSize);
        //日期 1-昨天 2-近七天 3-近三十天
        switch (flag) {
            case 2:
                String sevenDayTime = DateUtil.getBeforeTime(7, DateUtil.patternA, 1);
                paramMap.put("time", sevenDayTime);
                //机构数据
                break;
            case 3:
                String thirtyDayTime = DateUtil.getBeforeTime(30, DateUtil.patternA, 1);
                paramMap.put("time", thirtyDayTime);
                break;
            default:
                String yesterday = DateUtil.getBeforeTime(1, DateUtil.patternA, 1);
                paramMap.put("time", yesterday);
                break;
        }
        String body = HttpUtil.post(appConstantDTO.metisBaseUrl + "/new/dataReport/arriveShopRank", paramMap);
        ApiTemplate apiTemplate = JSON.parseObject(body, ApiTemplate.class);
        if (!apiTemplate.getSign().equals(1)) {
            return result;
        }
        List<NewArriveShopRankVO> list = JSON.parseArray(apiTemplate.getData().toString(), NewArriveShopRankVO.class);
        return result.ok(new PageUtils(list, apiTemplate.getTotal(), pageSize, pageNum));
    }

    @Override
    public Result<List<NewAgeDistributionVO>> selectAgeDistribution(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts) {

        Result<List<NewAgeDistributionVO>> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("oAccount", parseTokenDTO.getOrgAccount());
        List<String> mAccounts = new ArrayList<>();
        if (null != shopAccounts && shopAccounts.length > 0) {
            mAccounts = Arrays.stream(shopAccounts).collect(Collectors.toList());
        }
        if (parseTokenDTO.getPowerType().equals("2")) {
            mAccounts.add(parseTokenDTO.getShopAccount());
        }
        paramMap.put("mAccount", mAccounts);
        String body = HttpUtil.post(appConstantDTO.metisBaseUrl + "/new/dataReport/ageDistribution", paramMap);
        ApiTemplate apiTemplate = JSON.parseObject(body, ApiTemplate.class);
        if (!apiTemplate.getSign().equals(1)) {
            return result;
        }
        List<NewAgeDistributionVO> list = JSON.parseArray(apiTemplate.getData().toString(), NewAgeDistributionVO.class);
        return result.ok(list);
    }

    @Override
    public Result<PageUtils> selectClientDistribution(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize) {
        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0") || parseTokenDTO.getPowerType().equals("2")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("oAccount", parseTokenDTO.getOrgAccount());
        paramMap.put("pageNum", pageNum);
        paramMap.put("pageSize", pageSize);
        String body = HttpUtil.post(appConstantDTO.metisBaseUrl + "/new/dataReport/clientDistribution", paramMap);
        ApiTemplate apiTemplate = JSON.parseObject(body, ApiTemplate.class);
        if (!apiTemplate.getSign().equals(1)) {
            return result;
        }
        List<NewClientDistributionVO> list = JSON.parseArray(apiTemplate.getData().toString(), NewClientDistributionVO.class);
        return result.ok(new PageUtils(list, apiTemplate.getTotal(), pageSize, pageNum));
    }

    @Override
    public Result<List<SkinProblemRecommendVO>> selectSkinProblemRecommend(Long regionId) {
        Result<List<SkinProblemRecommendVO>> result = new Result<>();
        String[] currentSeasonTimeRange = DateUtil.getCurrentSeasonTimeRange();
        List<DrLastYearSkinProblemByMonthEntity> drLastYearSkinProblemByMonthList = this.drLastYearSkinProblemByMonthService
                .selectSkinProblemRecommend(regionId, currentSeasonTimeRange[0], currentSeasonTimeRange[1]);
        if (CollectionUtils.isEmpty(drLastYearSkinProblemByMonthList)) {
            return result;
        }
        //黑头数量
        BigDecimal one = new BigDecimal("0");
        BigDecimal oneTotal = new BigDecimal("0");
        //粉刺数量
        BigDecimal two = new BigDecimal("0");
        BigDecimal twoTotal = new BigDecimal("0");
        //毛孔数量
        BigDecimal three = new BigDecimal("0");
        BigDecimal threeTotal = new BigDecimal("0");
        //皱纹数量
        BigDecimal four = new BigDecimal("0");
        BigDecimal fourTotal = new BigDecimal("0");
        //色斑数量
        BigDecimal five = new BigDecimal("0");
        BigDecimal fiveTotal = new BigDecimal("0");

        for (DrLastYearSkinProblemByMonthEntity lastYearSkinProblemByMonthEntity : drLastYearSkinProblemByMonthList) {
            //黑头
            Integer blackhead = lastYearSkinProblemByMonthEntity.getBlackhead();
            Integer seriousBlackhead = lastYearSkinProblemByMonthEntity.getSeriousBlackhead();
            oneTotal = oneTotal.add(new BigDecimal(blackhead == null ? 0 : blackhead));
            one = one.add(new BigDecimal(seriousBlackhead == null ? 0 : seriousBlackhead));
            //粉刺
            Integer acne = lastYearSkinProblemByMonthEntity.getAcne();
            Integer seriousAcne = lastYearSkinProblemByMonthEntity.getSeriousAcne();
            twoTotal = twoTotal.add(new BigDecimal(acne == null ? 0 : acne));
            two = two.add(new BigDecimal(seriousAcne == null ? 0 : seriousAcne));
            //毛孔
            Integer pore = lastYearSkinProblemByMonthEntity.getPore();
            Integer seriousPore = lastYearSkinProblemByMonthEntity.getSeriousPore();
            threeTotal = threeTotal.add(new BigDecimal(pore == null ? 0 : pore));
            three = three.add(new BigDecimal(seriousPore == null ? 0 : seriousPore));
            //皱纹
            Integer wrinkle = lastYearSkinProblemByMonthEntity.getWrinkle();
            Integer seriousWrinkle = lastYearSkinProblemByMonthEntity.getSeriousWrinkle();
            fourTotal = fourTotal.add(new BigDecimal(wrinkle == null ? 0 : wrinkle));
            four = four.add(new BigDecimal(seriousWrinkle == null ? 0 : seriousWrinkle));
            //色斑
            Integer stain = lastYearSkinProblemByMonthEntity.getStain();
            Integer seriousStain = lastYearSkinProblemByMonthEntity.getSeriousStain();
            fiveTotal = fiveTotal.add(new BigDecimal(stain == null ? 0 : stain));
            five = five.add(new BigDecimal(seriousStain == null ? 0 : seriousStain));
        }
        String skinSolveRedisKey = BASE_REDIS_KEY;
        List<SkinProblemRecommendVO> list = new ArrayList<>();
        for (int i = 12; i <= 16; i++) {
            SkinProblemRecommendVO skinProblemRecommendVO = new SkinProblemRecommendVO();
            skinProblemRecommendVO.setSkinFlag(i);
            Object skinData = this.stringRedisTemplate.opsForHash().get(skinSolveRedisKey, String.valueOf(i));
            List<SkinProblemContentVO> skinProblemContentVOS = new ArrayList<>();
            if (null != skinData && StringUtils.isNotBlank(skinData.toString())) {
                skinProblemContentVOS = JSON.parseArray(skinData.toString(), SkinProblemContentVO.class);
                skinProblemContentVOS = skinProblemContentVOS.stream().filter(s -> Arrays.asList(s.getAreaConfigId().split(",")).contains(regionId.toString()))
                        .collect(Collectors.toList());
            }
            skinProblemRecommendVO.setSkinProblemContentList(skinProblemContentVOS);
            switch (i) {
                case 12:
                    if ("0".equals(oneTotal.toString())) {
                        skinProblemRecommendVO.setRatio("0");
                    }
                    skinProblemRecommendVO.setRatio(one.divide(oneTotal, RoundingMode.HALF_DOWN).toString());
                    list.add(skinProblemRecommendVO);
                    break;
                case 13: {
                    if ("0".equals(twoTotal.toString())) {
                        skinProblemRecommendVO.setRatio("0");
                    }
                    skinProblemRecommendVO.setRatio(two.divide(twoTotal, RoundingMode.HALF_DOWN).toString());
                    list.add(skinProblemRecommendVO);
                    break;
                }
                case 14: {
                    if ("0".equals(threeTotal.toString())) {
                        skinProblemRecommendVO.setRatio("0");
                    }
                    skinProblemRecommendVO.setRatio(three.divide(threeTotal, RoundingMode.HALF_DOWN).toString());

                    list.add(skinProblemRecommendVO);
                    break;
                }
                case 15: {
                    if ("0".equals(fourTotal.toString())) {
                        skinProblemRecommendVO.setRatio("0");
                    }
                    skinProblemRecommendVO.setRatio(four.divide(fourTotal, RoundingMode.HALF_DOWN).toString());

                    list.add(skinProblemRecommendVO);
                    break;
                }
                case 16: {
                    if ("0".equals(fiveTotal.toString())) {
                        skinProblemRecommendVO.setRatio("0");
                    }
                    skinProblemRecommendVO.setRatio(five.divide(fiveTotal, RoundingMode.HALF_DOWN).toString());
                    list.add(skinProblemRecommendVO);
                    break;
                }
                default:
                    skinProblemRecommendVO.setRatio("0");
                    list.add(skinProblemRecommendVO);
            }
        }
        return result.ok(list);
    }

    @Override
    public Result<List<NewConsumableRankVO>> selectConsumableRank(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts, Integer selectType) {
        Result<List<NewConsumableRankVO>> result = new Result<>();
        //获取上个月时间
        long[] lastMonthMinMaxTimestamp = DateUtil.getLastMonthMinMaxTimestamp();
        //获取指定设备类型
        String[] consumableDevicetypeCodes = this.configService.findConfigByKeystr("consumable_devicetype_code").getKeyvalue().split(",");
        LambdaQueryWrapper<DrConsumableUseInfoByMonthEntity> qw = new LambdaQueryWrapper<>();
        qw.eq(DrConsumableUseInfoByMonthEntity::getMonthTime, DateUtil.timeStampToString(lastMonthMinMaxTimestamp[0], DateUtil.patternYM));
        qw.in(DrConsumableUseInfoByMonthEntity::getDeviceTypeCode, Arrays.asList(consumableDevicetypeCodes));
        List<DrConsumableUseInfoByMonthEntity> list;
        if (selectType.equals(0)) {
            //我的
            ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
            if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
                return result.error(-1, "无权限!");
            }
            qw.eq(DrConsumableUseInfoByMonthEntity::getOrgAccount, parseTokenDTO.getOrgAccount());
            List<String> shopAccountList = new ArrayList<>();
            if (null != shopAccounts && shopAccounts.length > 0) {
                shopAccountList = Arrays.stream(shopAccounts).collect(Collectors.toList());
            }
            if (parseTokenDTO.getPowerType().equals("1") && !CollectionUtils.isEmpty(shopAccountList)) {
                shopAccountList.add(parseTokenDTO.getShopAccount());
                qw.eq(DrConsumableUseInfoByMonthEntity::getShopAccount, parseTokenDTO.getShopAccount());
            } else if (parseTokenDTO.getPowerType().equals("2")) {
                qw.eq(DrConsumableUseInfoByMonthEntity::getShopAccount, parseTokenDTO.getShopAccount());
            }
        }
        list = this.drConsumableUseInfoByMonthService.list(qw);
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        Map<String, List<DrConsumableUseInfoByMonthEntity>> deviceTypeGroupMap = list.stream().collect(Collectors.groupingBy(DrConsumableUseInfoByMonthEntity::getDeviceTypeCode));
        Map<String, String> deviceTypeMap = list.stream().collect(Collectors.toMap(DrConsumableUseInfoByMonthEntity::getDeviceTypeCode, DrConsumableUseInfoByMonthEntity::getDeviceTypeName, (k1, k2) -> k1));
        Map<String, String> consumableTypeMap = list.stream().collect(Collectors.toMap(DrConsumableUseInfoByMonthEntity::getConsumableTypeCode,
                DrConsumableUseInfoByMonthEntity::getConsumableTypeName, (k1, k2) -> k1));
        List<NewConsumableRankVO> newConsumableRankList = new ArrayList<>();
        deviceTypeGroupMap.forEach((deviceTypeCode, item) -> {
            Map<String, Integer> conMap = item.stream().collect(Collectors.groupingBy(DrConsumableUseInfoByMonthEntity::getConsumableTypeCode,
                    Collectors.summingInt(DrConsumableUseInfoByMonthEntity::getDailyConsumableUseNum)));
            List<Map.Entry<String, Integer>> topList = conMap.entrySet().stream()
                    .sorted(Map.Entry.<String, Integer>comparingByValue().reversed())
                    .limit(3).collect(Collectors.toList());
            NewConsumableRankVO newConsumableRankVO = new NewConsumableRankVO();
            newConsumableRankVO.setDeviceTypeName(deviceTypeMap.get(deviceTypeCode));
            List<NewConsumableListVO> newConsumableList = new ArrayList<>();
            AtomicInteger atomicInteger = new AtomicInteger(1);
            for (Map.Entry<String, Integer> conTypeNumMap : topList) {
                NewConsumableListVO newConsumableListVO = new NewConsumableListVO();
                if (selectType.equals(1)) {
                    newConsumableListVO.setNum(atomicInteger.getAndIncrement());
                } else {
                    newConsumableListVO.setNum(conTypeNumMap.getValue());
                }
                newConsumableListVO.setConsumableTypeName(consumableTypeMap.get(conTypeNumMap.getKey()));
                newConsumableList.add(newConsumableListVO);
            }
            newConsumableRankVO.setConsumableList(newConsumableList);
            newConsumableRankList.add(newConsumableRankVO);
        });
        return result.ok(newConsumableRankList);
    }

    @Override
    public Result<Void> newConsumableDownload(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts, Integer selectType) {
        return null;
    }

    /*
    @Override
    public Result<Void> newConsumableDownload(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts, Integer selectType) {
        Result<Void> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        String uuid = IdUtil.getSnowflakeNextIdStr();

        DrDownloadCenterEntity drDownloadCenterEntity = new DrDownloadCenterEntity();
        drDownloadCenterEntity.setName("");
        drDownloadCenterEntity.setUuid(uuid);
        drDownloadCenterEntity.setUrl("");
        drDownloadCenterEntity.setOpenId(parseTokenDTO.getOpenId());
        drDownloadCenterEntity.setDeleted(0);
        LocalDateTime now = LocalDateTime.now();
        drDownloadCenterEntity.setCreateTime(now);
        drDownloadCenterEntity.setUpdateTime(now);
        Shop shop = this.shopMapper.selectByAccounts(parseTokenDTO.getShopAccount());
        drDownloadCenterEntity.setShopId(shop.getId().longValue());
        drDownloadCenterEntity.setStatus(1);
        this.drDownloadCenterMapper.insert(drDownloadCenterEntity);

        NewDownloadCenterVO newDownloadCenterVO = new NewDownloadCenterVO();
        newDownloadCenterVO.setUuid(uuid);
        newDownloadCenterVO.setParseTokenDTO(parseTokenDTO);
        newDownloadCenterVO.setConsumerFlag(2);
        newDownloadCenterVO.setShopAccounts(shopAccounts);
        newDownloadCenterVO.setSelectType(selectType);
        Map<String, Object> map = new HashMap<>(1);
        map.put("dr_down_key", JSON.toJSONString(newDownloadCenterVO));
        RabbitmqSendMessageUtil.sendDelayMessage(RabbitMqConfig.SYNC_DR_DOWNLOAD_CENTER_EXCHANGE, RabbitMqConfig.SYNC_DR_DOWNLOAD_CENTER_KEY,
                map, 1000L);
        return result;
    }
     */

    @Override
    public Result<List<NewPerformanceRankVO>> performanceRank(HttpServletRequest request, JwtHelper jwtHelper, Long lineCityId) {
        Result<List<NewPerformanceRankVO>> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        //获取上个季度开始结束时间
        LocalDateTime[] lastQuarterDates = DateUtil.getLastQuarterDates();
        LocalDateTime quarterStart = lastQuarterDates[0];
        LocalDateTime quarterEnd = lastQuarterDates[1];
        //获取指定设备类型
        Config config = this.configService.findConfigByKeystr("perf_rank");
        //得到设备类型对应的业绩价值
        Map<String, String> deviceValueMap = Arrays.stream(config.getKeyvalue().split(","))
                .map(String::trim)
                .map(pair -> pair.split(":"))
                .collect(Collectors.toMap(
                        keyValue -> keyValue[0].trim(),
                        keyValue -> keyValue[1].trim()
                ));
        Set<String> deviceTypeSet = deviceValueMap.keySet();
        //得到分组后本门店下所有设备的次数
        List<DeviceTypeStartByMonthDTO> deviceTypeGroupList = this.drDeviceTypeStartByMonthService.selectDevStartList(DateUtil.localDateTimeToString(quarterStart, DateUtil.patternYM),
                DateUtil.localDateTimeToString(quarterEnd, DateUtil.patternYM), deviceTypeSet, parseTokenDTO.getOrgAccount(),
                "2".equals(parseTokenDTO.getPowerType()) ? parseTokenDTO.getShopAccount() : null, lineCityId);
        if (CollectionUtils.isEmpty(deviceTypeGroupList)) {
            return result;
        }
        List<NewPerformanceRankVO> list = new ArrayList<>();
        String rankBaseKey = NewDataReportConstant.BASE_DR_REDIS_KEY +
                NewDataReportConstant.LINE_CITY_REC_KEY + lineCityId;
        Map<String, List<DeviceTypeStartByMonthDTO>> deviceTypeMap = deviceTypeGroupList.stream().collect(Collectors.groupingBy(DeviceTypeStartByMonthDTO::getDeviceTypeCode));
        Map<String, String> deviceTypeCodeMap = deviceTypeGroupList.stream().collect(Collectors.toMap(DeviceTypeStartByMonthDTO::getDeviceTypeCode,
                DeviceTypeStartByMonthDTO::getDeviceTypeName, (t1, t2) -> t1));
        deviceTypeMap.forEach((k, v) -> {
            NewPerformanceRankVO newPerformanceRankVO = new NewPerformanceRankVO();
            Optional<Integer> maxStartNum = v.stream().map(t -> Integer.parseInt(t.getStartUpNum())).max(Integer::compareTo);
            DeviceTypeStartByMonthDTO deviceTypeStartByMonthDTO1 = new DeviceTypeStartByMonthDTO();
            if (maxStartNum.isPresent()) {
                //得到启动次数最多的设备
                List<DeviceTypeStartByMonthDTO> deviceTypeStartByMonthDTOList = v.stream().filter(t -> maxStartNum.get().equals(Integer.parseInt(t.getStartUpNum())))
                        .collect(Collectors.toList());
                //计算排名 查询全部设备类型下的设备
                String deviceTypeCode = v.get(0).getDeviceTypeCode();
                //查询城市线下设备类型下的所有设备
                List<DeviceTypeStartByMonthDTO> cityLineAllDeviceList = this.drDeviceTypeStartByMonthService.selectDevStartList(DateUtil.localDateTimeToString(quarterStart, DateUtil.patternYM),
                        DateUtil.localDateTimeToString(quarterEnd, DateUtil.patternYM), deviceTypeSet, null, null, lineCityId);
                double topOneFlag = 0;
                deviceTypeStartByMonthDTO1.setDeviceTypeCode(deviceTypeCode);
                deviceTypeStartByMonthDTO1.setDeviceTypeName(deviceTypeCodeMap.get(deviceTypeCode));
                for (DeviceTypeStartByMonthDTO deviceTypeStartByMonthDTO : cityLineAllDeviceList) {
                    //存入redis -->>> 城市线id、设备类型code做key
                    double startUpNum = Double.parseDouble(deviceTypeStartByMonthDTO.getStartUpNum());
                    //常规数据
                    this.stringRedisTemplate.opsForZSet().add(rankBaseKey + ":normal:" + deviceTypeCode, deviceTypeStartByMonthDTO.getDeviceid(), startUpNum);
                    if (topOneFlag < startUpNum) {
                        topOneFlag = startUpNum;
                        deviceTypeStartByMonthDTO1.setDeviceid(deviceTypeStartByMonthDTO.getDeviceid());
                        deviceTypeStartByMonthDTO1.setStartUpNum(deviceTypeStartByMonthDTO.getStartUpNum());
                    }
                }
                //获取标杆设备存入
                this.stringRedisTemplate.opsForValue().set(rankBaseKey + ":top_one:" + deviceTypeCode + ":", JSON.toJSONString(deviceTypeStartByMonthDTO1));
                //产品说取第一个即可
                DeviceTypeStartByMonthDTO deviceTypeStartByMonthDTO = deviceTypeStartByMonthDTOList.get(0);
                //获取排名
                Long rankNum = this.stringRedisTemplate.opsForZSet().reverseRank(rankBaseKey + ":normal:" + deviceTypeCode, deviceTypeStartByMonthDTO.getDeviceid());
                if (null != rankNum) {
                    ++rankNum;
                }
                newPerformanceRankVO.setRank(rankNum);
            }
            newPerformanceRankVO.setDeviceTypeCode(k);
            newPerformanceRankVO.setDeviceTypeName(deviceTypeCodeMap.get(k));
            newPerformanceRankVO.setTopOnePerValue("0");
            //计算价值
            String startUpNum = deviceTypeStartByMonthDTO1.getStartUpNum();
            String myDataValue = deviceValueMap.get(deviceTypeStartByMonthDTO1.getDeviceTypeCode());
            BigDecimal myPerValue = new BigDecimal(myDataValue).multiply(new BigDecimal(startUpNum));
            newPerformanceRankVO.setPerformanceValue(myPerValue.toString());
            //得到标杆设备
            Set<String> firstElement = this.stringRedisTemplate.opsForZSet().reverseRange(rankBaseKey + ":" + k, 0, 0);
            if (!CollectionUtils.isEmpty(firstElement)) {
                String firstData = firstElement.iterator().next();
                String firstDataValue = deviceValueMap.get(firstData);
                //计算价值
                BigDecimal perValue = new BigDecimal(firstData).multiply(new BigDecimal(firstDataValue));
                newPerformanceRankVO.setTopOnePerValue(perValue.toString());
            }
            list.add(newPerformanceRankVO);
        });
        return result.ok(list);
    }

    @Override
    public Result<Void> performanceDownload(HttpServletRequest request, JwtHelper jwtHelper, Long lineCityId) {
        Result<Void> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        Map<String, Object> map = new HashMap<>(1);
        NewDownloadCenterVO newDownloadCenterVO = new NewDownloadCenterVO();
        newDownloadCenterVO.setUuid(IdUtil.getSnowflakeNextIdStr());
        newDownloadCenterVO.setLineCityId(lineCityId);
        newDownloadCenterVO.setParseTokenDTO(parseTokenDTO);
        newDownloadCenterVO.setConsumerFlag(1);
        map.put("dr_down_key", JSON.toJSONString(newDownloadCenterVO));
        RabbitmqSendMessageUtil.sendDelayMessage(RabbitMqConfig.SYNC_DR_DOWNLOAD_CENTER_EXCHANGE, RabbitMqConfig.SYNC_DR_DOWNLOAD_CENTER_KEY,
                map, 1000L);
        return result;
    }

    @Override
    public Result<PageUtils> selectDownloadList(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize) {
        return null;
    }

    /*
    @Override
    public Result<PageUtils> selectDownloadList(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize) {
        Result<PageUtils> result = new Result<>();
        ParseTokenDTO parseTokenDTO = this.parseToken(request, jwtHelper);
        if (null == parseTokenDTO || parseTokenDTO.getPowerType().equals("0")) {
            return result.error(-1, "无权限!");
        }
        Shop shop = this.shopMapper.selectByAccounts(parseTokenDTO.getShopAccount());
        Page<DrDownloadCenterEntity> page = Page.of(pageNum, pageSize);
        Page<DrDownloadCenterEntity> drDownloadCenterEntityPage = this.drDownloadCenterMapper.selectPage(page, new LambdaQueryWrapper<DrDownloadCenterEntity>()
                .eq(DrDownloadCenterEntity::getDeleted, 0)
                .eq(DrDownloadCenterEntity::getShopId, shop.getId())
                .eq(DrDownloadCenterEntity::getOpenId, parseTokenDTO.getOpenId())
                .orderByDesc(DrDownloadCenterEntity::getId));
        List<NewDrDownloadCenterVO> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(drDownloadCenterEntityPage.getRecords())) {
            return result.ok(new PageUtils(list, 0, pageSize, pageNum));
        }
        drDownloadCenterEntityPage.getRecords().forEach(t -> {
            NewDrDownloadCenterVO newDrDownloadCenterVO = new NewDrDownloadCenterVO();
            newDrDownloadCenterVO.setFilename(t.getName());
            newDrDownloadCenterVO.setDownUrl(t.getUrl());
            list.add(newDrDownloadCenterVO);
        });
        return result.ok(new PageUtils(list, drDownloadCenterEntityPage.getTotal(), pageSize, pageNum));
    }
     */

    private ParseTokenDTO parseToken(HttpServletRequest request, JwtHelper jwtHelper) {
        ParseTokenDTO parseTokenDTO = new ParseTokenDTO();
        String token = request.getHeader("token");
        Payload payload = jwtHelper.parseTokenData(token);
        JSONObject jsonObject = payload.toJSONObject();
        parseTokenDTO.setOpenId(jsonObject.getAsString("uid"));
        parseTokenDTO.setUserId(Long.valueOf(jsonObject.getAsString("id")));
        WxAppletuserEntity user = this.wxAppletuserMapper.selectById(parseTokenDTO.getUserId());
        if (StringUtils.isNotBlank(parseTokenDTO.getOpenId()) && StringUtils.isNotBlank(user.getShopAccountNumber())) {
            EmpPermissionDTO empPermission = this.employeeManageMapper.findEmpPermission(parseTokenDTO.getOpenId(), user.getShopAccountNumber());
            if (null != empPermission) {
                parseTokenDTO.setPowerType(empPermission.getPowerType());
                parseTokenDTO.setShopAccount(empPermission.getShopAccount());
                parseTokenDTO.setOrgAccount(empPermission.getOAccount());
                return parseTokenDTO;
            }
        }
        return null;
    }

}
