package com.dr.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description 机构门店数据同步物联网对象
 * @author luocong
 * @date 2024/8/29 10:56
 * @version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class NewOrgAndShopConsumeVO implements Serializable {

    private static final long serialVersionUID = -8778117513527681936L;

    /**
     * 机构账号
     */
    private String orgAccount;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 门店账号
     */
    private String shopAccount;

    /**
     * 门店名称
     */
    private String shopName;

    /**
     * 门店省名称
     */
    private String shopProvinceName;

    /**
     * 门店市名称
     */
    private String shopCityName;

    /**
     * 门店区名称
     */
    private String shopRegionName;

    /**
     * 详细地址
     */
    private String shopAddress;

}
