package com.dr.exception;

import com.dr.constant.CodeMsg;
import com.dr.util.Results;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author luocong
 * @since 2023-01-29 14:24:53
 */
@RestControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

    @ExceptionHandler(value = Exception.class)
    public Object exceptionHandler(Exception e) {
        log.error("异常信息{}", e.getMessage(), e);
        return Results.error(CodeMsg.SERVER_ERROR);
    }
}


