package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 数据统计-设备启动次数月表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Data
@TableName("dr_device_type_start_by_month")
public class DrDeviceTypeStartByMonthEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 当月日期
	 */
	private String monthTime;
	/**
	 * 设备id
	 */
	private String deviceid;
	/**
	 * 设备类型code
	 */
	private String deviceTypeCode;
	/**
	 * 设备类型名称
	 */
	private String deviceTypeName;
	/**
	 * 启动次数
	 */
	private Integer startUpNum;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegion;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;

}
