package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 数据统计-去年皮肤问题明细月表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Data
@TableName("dr_last_year_skin_problem_by_month")
public class DrLastYearSkinProblemByMonthEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 当月日期
	 */
	private String monthTime;
	/**
	 * 黑头数量
	 */
	private Integer blackhead;
	/**
	 * 严重黑头数量
	 */
	private Integer seriousBlackhead;
	/**
	 * 粉刺数量
	 */
	private Integer acne;
	/**
	 * 严重粉刺数量
	 */
	private Integer seriousAcne;
	/**
	 * 毛孔数量
	 */
	private Integer pore;
	/**
	 * 严重毛孔数量
	 */
	private Integer seriousPore;
	/**
	 * 皱纹数量
	 */
	private Integer wrinkle;
	/**
	 * 严重皱纹数量
	 */
	private Integer seriousWrinkle;
	/**
	 * 色斑数量
	 */
	private Integer stain;
	/**
	 * 严重色斑数量
	 */
	private Integer seriousStain;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegionName;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;

}
