package com.dr.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.dr.dto.DeviceTypeStartByMonthDTO;
import com.dr.entity.DrDeviceTypeStartByMonthEntity;

import java.util.List;
import java.util.Set;

/**
 * @description 数据统计-设备启动次数月表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
public interface IDrDeviceTypeStartByMonthService extends IService<DrDeviceTypeStartByMonthEntity> {

    /**
     * 设备类型分组查询单个设备类型启动次数
     *
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param deviceTypeSet 设备类型集
     * @param orgAccount 机构账号
     * @param shopAccount 门店账号
     * @param lineCityId 城市线id
     * @return List<DeviceTypeStartByMonthDTO>
     */
    List<DeviceTypeStartByMonthDTO> selectDevStartList(String startTime, String endTime, Set<String> deviceTypeSet, String orgAccount, String shopAccount, Long lineCityId);
}

