package com.dr.service;

import com.dr.filter.token.JwtHelper;
import com.dr.util.PageUtils;
import com.dr.util.Result;
import com.dr.vo.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @description
 * @author luocong
 * @date 2024/8/16 11:08
 * @version 1.0
 */
public interface IMeowShopDataReportService {
    /**
     * 查询设备与耗材数据
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @return Result<NewDeviceAndConsumableVO>
     */
    Result<NewDeviceAndConsumableVO> selectDeviceAndConsumable(HttpServletRequest request, JwtHelper jwtHelper);


    /**
     * 设备实时数据查询
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @return Result<List < NewDeviceRealTimeVO>>
     */
    Result<List<NewDeviceRealTimeVO>> selectDeviceRealTime(HttpServletRequest request, JwtHelper jwtHelper);


    /**
     * 员工排行数据
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param flag flag
     * @param shopAccount shopAccount
     * @return Result<List < NewEmployeeRankVO>>
     */
    Result<List<NewEmployeeRankVO>> selectEmpOperateRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, String[] shopAccount);

    /**
     * 门店消耗排行数据
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param flag 日期 1-昨天 2-近七天 3-近三十天
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return Result<PageUtils>
     */
    Result<PageUtils> selectShopConsumerRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, Integer pageNum, Integer pageSize);

    /**
     * 设备地域分布
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param deviceCode deviceCode
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return Result<PageUtils>
     */
    Result<PageUtils> selectRegionalDistribution(HttpServletRequest request, JwtHelper jwtHelper, String[] deviceCode, Integer pageNum, Integer pageSize);

    /**
     * 客户与案例
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @return Result<NewClientAndCaseGroup>
     */
    Result<NewClientAndCaseGroupVO> selectClientAndCase(HttpServletRequest request, JwtHelper jwtHelper);

    /**
     * 检测排行
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param flag 日期 1-昨天 2-近七天 3-近三十天
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return Result<List < NewCheckCaseRankVO>>
     */
    Result<PageUtils> selectCheckCaseRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, Integer pageNum, Integer pageSize);

    /**
     * 产品推荐曝光
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return
     */
    Result<PageUtils> selectProductRecommend(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize);

    /**
     * 客户到店排行
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param flag flag
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return Result<List<NewArriveShopRankVO>>
     */
    Result<PageUtils> selectArriveShopRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, Integer pageNum, Integer pageSize);

    /**
     * 年龄分布
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param shopAccounts 门店账号
     * @return Result<List<NewAgeDistributionVO>>
     */
    Result<List<NewAgeDistributionVO>> selectAgeDistribution(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts);

    /**
     * 客户地域分布 - 机构专属
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param pageNum pageNum
     * @param pageSize pageSize
     * @return Result<List<NewClientDistributionVO>>
     */
    Result<PageUtils> selectClientDistribution(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize);

    /**
     * 皮肤问题方案推荐
     *
     * @param regionId 区域id
     * @return Result<List<SkinProblemRecommendVO>>
     */
    Result<List<SkinProblemRecommendVO>> selectSkinProblemRecommend(Long regionId);

    /**
     * 耗材消耗排行
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param shopAccounts 门店账号
     * @param selectType 选择类型（0-我的，1-全国）
     * @return Result<List<NewConsumableRankVO>>
     */
    Result<List<NewConsumableRankVO>> selectConsumableRank(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts, Integer selectType);

    /**
     * 耗材消耗排行
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param shopAccounts 门店账号
     * @param selectType 选择类型（0-我的，1-全国）
     */
    Result<Void> newConsumableDownload(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccounts, Integer selectType);

    /**
     * 业绩排行
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param lineCityId 城市线id
     * @return Result<List<NewPerformanceRankVO>>
     */
    Result<List<NewPerformanceRankVO>> performanceRank(HttpServletRequest request, JwtHelper jwtHelper, Long lineCityId);

    /**
     * 业绩报表下载
     *
     * @param request request
     * @param jwtHelper jwtHelper
     * @param lineCityId lineCityId
     */
    Result<Void> performanceDownload(HttpServletRequest request, JwtHelper jwtHelper, Long lineCityId);

    /**
     *
     * @param request
     * @param jwtHelper
     * @param pageNum
     * @param pageSize
     * @return
     */
    Result<PageUtils> selectDownloadList(HttpServletRequest request, JwtHelper jwtHelper, Integer pageNum, Integer pageSize);
}
