//
//  SMESEditView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/7.
//

#import "SMESEditView.h"


@interface SMESEditView()

@property(nonatomic, weak)UITextField *telTF ;
@property(nonatomic, weak)UIButton *nextBtn;
@end


@implementation SMESEditView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {

    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(255, 255, 255, 1);
    contView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    contView.layer.shadowOffset = CGSizeMake(0,4);
    contView.layer.shadowOpacity = 1;
    contView.layer.shadowRadius = 30;
    [self addSubview:contView];
    [contView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(64.5) );
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [contView addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(17);
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];
    
    UILabel *XinTipsLabel = [[UILabel alloc] init];
    XinTipsLabel.attributedText = createAttString(@"设置新手机号", 25, rgba(76, 74, 66, 1));
    [contView addSubview:XinTipsLabel];
    [XinTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.mas_equalTo(53);
    }];
    
    UILabel *xinInputTipsLabel = [[UILabel alloc] init];
    xinInputTipsLabel.attributedText = createAttString(@"请输入您当前门店要绑定的手机号", 14, rgba(153, 153, 153, 1));
    [contView addSubview:xinInputTipsLabel];
    [xinInputTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.mas_equalTo(94.5);
    }];
    
    
    UITextField *telHeaderTF = [[UITextField alloc] init];
    telHeaderTF.userInteractionEnabled = NO;
    
    telHeaderTF.attributedText = createAttString(@"+86", 14, rgba(185, 185, 185, 1));
    [contView addSubview:telHeaderTF];
    [telHeaderTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.mas_equalTo(164.5);
    }];
    
    UIView *telSlineView = [[UIView alloc] init];
    telSlineView.backgroundColor = rgba(255, 124, 78, 1);
    telSlineView.layer.cornerRadius = 0.5;
    [contView addSubview:telSlineView];
    [telSlineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(87);
        make.centerY.equalTo(telHeaderTF);
        make.height.mas_equalTo(26);
        make.width.mas_equalTo(1);
    }];
    UITextField *telTF = [[UITextField alloc] init];
    [telTF addTarget:self action:@selector(txtChnage:) forControlEvents:UIControlEventEditingChanged];
    _telTF = telTF;
    
    telTF.attributedPlaceholder = createAttString(@"请输入手机号", 18, rgba(185, 185, 185, 1));

    [contView addSubview:telTF];
    [telTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(89);
        make.centerY.equalTo(telHeaderTF);
        make.right.mas_equalTo(-45);
        make.height.mas_equalTo(26);
    }];
    
    UIView *telLineView = [[UIView alloc] init];
    telLineView.backgroundColor = rgba(229, 229, 229, 1);
    telLineView.layer.cornerRadius = 0.5;
    [contView addSubview:telLineView];
    [telLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.right.mas_equalTo(-45);
        make.height.mas_equalTo(1);
        make.top.equalTo(telHeaderTF.mas_bottom).offset(14);
    }];
    
    
    UIButton *nextBtn = [[UIButton alloc] init];
    _nextBtn = nextBtn;
    [nextBtn addTarget:self action:@selector(nextBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    nextBtn.userInteractionEnabled = NO;
    nextBtn.selected = YES;
   
    [nextBtn setAttributedTitle: createAttString(@"下一步", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    
    
    [nextBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [nextBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [contView addSubview:nextBtn];
    [nextBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(telLineView.mas_bottom).offset(30);
        make.centerX.mas_equalTo(0);
    }];
    
}

- (void)txtChnage:(UITextField *)tf {
    if (tf.text.length != 11) {
        self.nextBtn.selected = YES;
        self.nextBtn.userInteractionEnabled = NO;
    }else {
        self.nextBtn.selected = NO;
        self.nextBtn.userInteractionEnabled = YES;
    }
}
- (void)nextBtnClick:(UIButton *)btn {
    if (self.Nextblock) {
        self.Nextblock(self.telTF.text);
    }
}

@end
