//
//  SMLoginView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMLoginView.h"
//#import "SMRInputPhoneView.h"
//#import "SMRVerificationCodeView.h"
#import "SMRegistView.h"
#import "SMYZMView.h"



@interface SMLoginView()
@property(nonatomic, weak)UITextField *accountTF;
@property(nonatomic, weak)UITextField *pwdTF;
@property(nonatomic, weak)SMRegistView *rView;
@property(nonatomic, weak)UIButton  *registBtn;
@property(nonatomic, weak)UIButton  *loginBtn;
@property(nonatomic, weak)UIButton  *rememberBtn;
@end


@implementation SMLoginView

- (instancetype)init {
    if (self = [super init]) {
        [self setupUI];

    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = rgba(254, 254, 254, 1);
    UILabel *tipsLabel = [[UILabel alloc] init];
    
    NSDictionary *sdict = [[NSUserDefaults standardUserDefaults] objectForKey:@"saveAccountKey"];

    tipsLabel.attributedText = createAttString(@"商家登录", 25,rgba(76, 74, 66, 1));;
    [self addSubview:tipsLabel];
    [tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(46.5);
        make.top.mas_equalTo(safaTop(91) );
    }];
    
    UITextField *accountTF = [[UITextField alloc] init];
    [accountTF addTarget:self action:@selector(tfTextChange:) forControlEvents:UIControlEventEditingChanged];
    accountTF.attributedPlaceholder = createAttString(@"账号/手机号", 15,rgba(185, 185, 185, 1));;
    _accountTF = accountTF;
    [self addSubview:accountTF];
    [accountTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(tipsLabel);
        make.top.equalTo(tipsLabel.mas_bottom).offset(37);
        make.right.mas_equalTo(-45.5);
    }];
    if (sdict) {
        accountTF.text = sdict[@"account"];
    }
    
    UIView *accountTFLine = [[UIView alloc] init];
    accountTFLine.backgroundColor = rgba(229, 229, 229, 1);
    [self addSubview:accountTFLine];
    [accountTFLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(accountTF).offset(-10);
        make.top.equalTo(accountTF.mas_bottom).offset(8.5);
        make.right.equalTo(accountTF).offset(8.5);
        make.height.mas_equalTo(0.5);
    }];
    
    UITextField *pwdTF = [[UITextField alloc] init];
    pwdTF.secureTextEntry = YES;
    [pwdTF addTarget:self action:@selector(tfTextChange:) forControlEvents:UIControlEventEditingChanged];
    pwdTF.attributedPlaceholder = createAttString(@"密码", 15,rgba(185, 185, 185, 1));;
    [self addSubview:pwdTF];
    _pwdTF = pwdTF;
    [pwdTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(tipsLabel);
        make.top.equalTo(accountTFLine.mas_bottom).offset(45);
        make.right.mas_equalTo(-45.5);
    }];

    
    
    if (sdict) {
        NSString *key = sdict[@"pwd"];
        pwdTF.text = decryptAES128(key, @"jinhaoyang201905");
    }
    
    UIView *pwdTFLine = [[UIView alloc] init];
    pwdTFLine.backgroundColor = rgba(229, 229, 229, 1);
    [self addSubview:pwdTFLine];
    [pwdTFLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(pwdTF).offset(-10);
        make.top.equalTo(pwdTF.mas_bottom).offset(8.5);
        make.right.equalTo(pwdTF).offset(8.5);
        make.height.mas_equalTo(0.5);
    }];
    
    UIButton *showPWdBtn = [[UIButton alloc] init];
    [showPWdBtn setBackgroundImage:[UIImage imageNamed:@"login_icon_yc"] forState:UIControlStateNormal];
    [showPWdBtn setBackgroundImage:[UIImage imageNamed:@"login_icon_xs"] forState:UIControlStateSelected];
    [showPWdBtn addTarget:self action:@selector(showPWdBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:showPWdBtn];
    [showPWdBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(pwdTF);
        make.right.equalTo(pwdTFLine);
    }];
    
    UIButton *rememberBtn = [[UIButton alloc] init];
    _rememberBtn = rememberBtn;
    [rememberBtn addTarget:self action:@selector(rememberBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [rememberBtn setAttributedTitle:createAttString(@"记住密码", 12,rgba(153, 153, 153, 1)) forState:UIControlStateNormal];
    [rememberBtn setImageEdgeInsets:UIEdgeInsetsMake(0, -4.5, 0, 4.5)];
    [rememberBtn wb_setImageName:@"login_jz"];
    rememberBtn.selected = [sdict allKeys];

    [self addSubview:rememberBtn];
    [rememberBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(pwdTFLine.mas_bottom).offset(13.5);
        make.right.equalTo(pwdTFLine);
    }];
    
    UIButton *loginBtn = [[UIButton alloc] init];
    if (!sdict) {
        loginBtn.userInteractionEnabled = NO;
        loginBtn.selected = YES;
    }

    [loginBtn addTarget:self action:@selector(loginClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [loginBtn setAttributedTitle: createAttString(@"登录", 15,rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    
    
    [loginBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [loginBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [self addSubview:loginBtn];
    _loginBtn = loginBtn;
    [loginBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(pwdTFLine.mas_bottom).offset(55);
        make.centerX.mas_equalTo(0);
    }];
    
//    SMYZMView *fr = [[SMYZMView alloc] init];
//    fr.backgroundColor = [UIColor redColor];
//    [self addSubview:fr];
//    [fr mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.top.equalTo(loginBtn.mas_bottom).offset(10);
//        make.centerX.mas_equalTo(0);
//        make.size.mas_equalTo(CGSizeMake(100, 40));
//    }];
    
    UIView *bgView =  [[UIView alloc] init];
    bgView.backgroundColor = rgba(255, 255, 255, 1);
    
    
    bgView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    bgView.layer.shadowOffset = CGSizeMake(0,15);
    bgView.layer.shadowOpacity = 1;
    bgView.layer.shadowRadius = 84;
    bgView.layer.cornerRadius = 6.7;
    [self addSubview:bgView];
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(-(safaBottom(-118.5)));
        
    }];
    
    UIView *gView = [[UIView alloc] init];
    
    gView.layer.cornerRadius = 1;
    gView.backgroundColor = rgba(239, 239, 239, 1);
    [bgView addSubview:gView];
    [gView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(2);
        make.width.mas_equalTo(39);
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(16.5);
    }];
    
    UILabel *xinTipsLabel = [[UILabel alloc] init];
    xinTipsLabel.attributedText = createAttString(@"新用户？", 14,rgba(255, 124, 78, 1));
    [bgView addSubview:xinTipsLabel];
    [xinTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(38.5);
        make.left.mas_equalTo(45);
    }];
    
    UILabel *registTisLabel = [[UILabel alloc] init];

    registTisLabel.attributedText = createAttString(@"注册", 25, rgba(76, 74, 66, 1));;
    [bgView addSubview:registTisLabel];
    [registTisLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(65.5);
        make.left.mas_equalTo(45);
    }];
    
    UILongPressGestureRecognizer *longTap = [[UILongPressGestureRecognizer alloc] initWithTarget:self action: @selector(longTapClick:)];
    longTap.minimumPressDuration = 0;
    [bgView addGestureRecognizer:longTap];
    
    UIButton *registBtn = [[UIButton alloc] init];
    [registBtn setBackgroundImage:[UIImage imageNamed:@"login_icon_xyb"] forState:UIControlStateNormal];
    [registBtn addTarget:self action:@selector(registBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:registBtn];
    _registBtn = registBtn;
    [registBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-45);
        make.centerY.equalTo(bgView);
    }];
    
    SMRegistView *rView = [[SMRegistView alloc] init];
    @weakify(self);
    rView.registBlock = ^(NSString * _Nonnull account, NSString * _Nonnull dname) {
        @strongify(self);
        if (self.loginBlock) {
            self.loginBlock(account,dname);
        }
        CGSize sSize = [UIScreen mainScreen].bounds.size;
        self.rView.frame = CGRectMake(0,sSize.height,sSize.width, sSize.height);
    };
    _rView = rView;
    CGSize sSize = [UIScreen mainScreen].bounds.size;
    rView.frame = CGRectMake(0,sSize.height,sSize.width, sSize.height);
    [self addSubview:rView];
    
}

- (void)tfTextChange:(UITextField *)tf {
    if (self.pwdTF.text.length && self.accountTF.text.length) {
        self.loginBtn.userInteractionEnabled =YES;
        self.loginBtn.selected = NO;
    }else {
        self.loginBtn.userInteractionEnabled = NO;
        self.loginBtn.selected = YES;
    }
}

- (void)rememberBtnClick:(UIButton *)btn {
    btn.selected = !btn.selected;
}

- (void)loginClick:(UIButton *)btn {
    [self.accountTF endEditing:YES];
    [self.pwdTF endEditing:YES];
    
    NSString *account = self.accountTF.text;
    NSString *pwd = self.pwdTF.text;
    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
    pDict[@"loginSign"] = md5String([NSString stringWithFormat:@"%@%@",account,pwd]);
    pDict[@"account"] = account;
    pDict[@"pwd"] = encryptAES128(pwd, @"jinhaoyang201905");
    pDict[@"flagPwd"] =md5String([NSString stringWithFormat:@"%@jinhaoyang",md5String(pwd)]);
    pDict[@"ipadVersion"] = @"1.0";
    pDict[@"softVersion"] = @"1.0";
    @weakify(self);
    [self postFormDataWithUrl:@"/magnifier/public/login" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        NSLog(@"%@",JsonData );
        @strongify(self);
        if ([JsonData.code isEqualToString:@"200"]) {
            NSDictionary *dataDict = ((NSArray *)JsonData.data).firstObject;
            
            [SMGlobalModel share].mid =  [NSString stringWithFormat:@"%@", dataDict[@"id"]];
            NSMutableDictionary *sDict = [[NSMutableDictionary alloc] init];
            sDict[@"account"] = account;
            sDict[@"pwd"] = encryptAES128(pwd, @"jinhaoyang201905");
            if (self.rememberBtn.selected) {
                [[NSUserDefaults standardUserDefaults] setObject:sDict forKey:@"saveAccountKey"];
            }else {
                self.pwdTF.text = @"";
                self.accountTF.text = @"";
                [[NSUserDefaults standardUserDefaults] removeObjectForKey:@"saveAccountKey"];
            }
            
            if (self.loginBlock) {
                self.loginBlock(dataDict[@"account"],dataDict[@"dmname"]);
            }
        }else if([JsonData.code isEqualToString:@"-46"]) {
            [SVProgressHUD showErrorWithStatus:@"账号或密码错误"];
        }

    }];
}


- (void)longTapClick:(UILongPressGestureRecognizer *)tap {
   UIWindow *window =   [[[UIApplication sharedApplication] delegate] window];
    CGPoint p = [tap locationInView:window];

    
    CGRect sFrame = self.superview.frame;
    switch (tap.state) {
        case UIGestureRecognizerStateBegan:
            break;
        case UIGestureRecognizerStateEnded:
        {

            
            [UIView animateWithDuration:0.25 animations:^{
                CGFloat y = 0;
                if (p.y > ([UIScreen mainScreen].bounds.size.height - 300)) {
                    y = window.bounds.size.height;
                }
                self.rView.frame = CGRectMake(sFrame.origin.x, y, sFrame.size.width, sFrame.size.height);
            }];
       
            break;
        }
        default:

            self.rView.frame = CGRectMake(0, p.y, sFrame.size.width, sFrame.size.height);
            break;
    }
}

- (void)showPWdBtnClick:(UIButton *)btn {
    btn.selected = !btn.selected;
    self.pwdTF.secureTextEntry = !btn.selected;
}

- (void)registBtnClick:(UIButton *)btn {

    [UIView animateWithDuration:0.25 animations:^{
        self.rView.frame = CGRectMake(0,0, self.bounds.size.width, self.bounds.size.height);
    }];
}

@end
