//
//  SMRCompleteView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/5.
//

#import "SMRCompleteView.h"
#import "SMCountDownButton.h"

@interface SMRCompleteView ()

@property(nonatomic, weak)SMCountDownButton *cdBtn;

@end
@implementation SMRCompleteView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = [UIColor whiteColor];
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [self addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(safaTop(17));
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];
    
    UIImageView *tipsImageView = [UIImageView new];
    tipsImageView.image = [UIImage imageNamed:@"login_icon_wc"];
    [self addSubview:tipsImageView];
    [tipsImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(safaTop(220));
    }];
    
    UILabel *tipsLabel  = [[UILabel alloc] init];
    tipsLabel.attributedText = createAttString(@"注册成功", 20, rgba(76, 74, 66, 1));
    [self addSubview:tipsLabel];
    [tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(tipsImageView.mas_bottom).offset(18.5);
    }];
    SMCountDownButton *cdbtn = [[SMCountDownButton alloc] init];
    _cdBtn = cdbtn;
    @weakify(self);
    __block int maxCount = 6;
    cdbtn.timeBlock = ^{
        @strongify(self);
        maxCount--;
        if (maxCount == 0) {
            [self.cdBtn stopTime];
            if (self.compBlock) {
                self.compBlock();
            }
        }
         
       NSAttributedString *btnAtt=  [[NSAttributedString alloc] wb_initWithString:[NSString stringWithFormat:@"%ds进入首页",maxCount] FontSize:12 TextColor:rgba(153, 153, 153, 1)];
        [self.cdBtn setAttributedTitle:btnAtt forState:UIControlStateNormal];
    };
    [self addSubview:cdbtn];
    [cdbtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(-108);
    }];
    ;
    UIButton *homeBtn = [[UIButton alloc] init];
    [homeBtn addTarget:self action:@selector(homeClick:) forControlEvents:UIControlEventTouchUpInside];
    
    [homeBtn setAttributedTitle:createAttString(@"前往首页", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    [homeBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [homeBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [self addSubview:homeBtn];
    [homeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(-50);
        make.centerX.mas_equalTo(0);
    }];
    [self.cdBtn startTime];
}
- (void)homeClick:(UIButton *)btn {
    if (self.compBlock) {
        self.compBlock();
    }

}
@end
