//
//  SMRInputPhoneView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMRInputPhoneView.h"
#import "SMAgreementView.h"


@interface SMRInputPhoneView()

@property(nonatomic, weak)UIButton *nextBtn;
@property(nonatomic, weak)UIButton *agreenBtn;
@property(nonatomic, weak)UITextField *telTF;
@end

@implementation SMRInputPhoneView

- (instancetype)init {
    if (self = [super init]) {
        
        [self setupUI];
    }
    return self;
}

- (void)setupUI {

    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(255, 255, 255, 1);
    contView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    contView.layer.shadowOffset = CGSizeMake(0,4);
    contView.layer.shadowOpacity = 1;
    contView.layer.shadowRadius = 30;
    [self addSubview:contView];
    [contView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(64.5) );
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [contView addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(17);
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];
    
    UILabel *sjTipsLabel = [[UILabel alloc] init];
    sjTipsLabel.attributedText = createAttString(@"商家注册", 25, rgba(76, 74, 66, 1));;
    [contView addSubview:sjTipsLabel];
    [sjTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(52.5);
        make.left.mas_equalTo(45);
    }];
    
    UILabel *telTipsLabel =  [[UILabel alloc] init];
    telTipsLabel.attributedText = createAttString(@"请输入您当前门店绑定的手机号", 14, rgba(153, 153, 153, 1));
    [contView addSubview:telTipsLabel];
    [telTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(94.5);
        make.left.mas_equalTo(45);
    }];
    
    UITextField *telHeaderTF = [[UITextField alloc] init];
    telHeaderTF.userInteractionEnabled = NO;
    
    telHeaderTF.attributedText = createAttString(@"+86", 14, rgba(185, 185, 185, 1));
    [contView addSubview:telHeaderTF];
    [telHeaderTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.mas_equalTo(164.5);
    }];
    
//    UIView *telSlineView = [[UIView alloc] init];
//    telSlineView.backgroundColor = rgba(255, 124, 78, 1);
//    telSlineView.layer.cornerRadius = 0.5;
//    [contView addSubview:telSlineView];
//    [telSlineView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(87);
//        make.centerY.equalTo(telHeaderTF);
//        make.height.mas_equalTo(26);
//        make.width.mas_equalTo(1);
//    }];
    UITextField *telTF = [[UITextField alloc] init];
    telTF.tintColor = rgba(255, 124, 78, 1);
    telTF.keyboardType = UIKeyboardTypePhonePad;
    [telTF addTarget:self action:@selector(textChange:) forControlEvents:UIControlEventEditingChanged];
    telTF.attributedPlaceholder = createAttString(@"请输入手机号", 18, rgba(185, 185, 185, 1));

    [contView addSubview:telTF];
    _telTF = telTF;
    [telTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(89);
        make.centerY.equalTo(telHeaderTF);
        make.right.mas_equalTo(-45);
        make.height.mas_equalTo(26);
    }];
    
    UIView *telLineView = [[UIView alloc] init];
    telLineView.backgroundColor = rgba(229, 229, 229, 1);
    telLineView.layer.cornerRadius = 0.5;
    [contView addSubview:telLineView];
    [telLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.right.mas_equalTo(-45);
        make.height.mas_equalTo(1);
        make.top.equalTo(telHeaderTF.mas_bottom).offset(14);
    }];
    
    UIButton *agreenBtn = [[UIButton alloc] init];
    [agreenBtn addTarget:self action:@selector(agreenClick:) forControlEvents:UIControlEventTouchUpInside];
//    NSMutableAttributedString *aAttString = [[NSMutableAttributedString alloc] init];
//    [aAttString appendAttributedString:
//     ];
//    [aAttString appendAttributedString:
//     createAttString(@"《用户服务协议》", 12,rgba(255, 124, 78, 1))];
    [agreenBtn setAttributedTitle:createAttString(@"我已阅读并同意", 12,rgba(185, 185, 185, 1)) forState:UIControlStateNormal];
    [agreenBtn wb_setImageName:@"login_jz"];
    [agreenBtn setImageEdgeInsets:UIEdgeInsetsMake(0, -4.5, 0, 4.5)];
    [contView addSubview:agreenBtn];
    _agreenBtn = agreenBtn;
    [agreenBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.equalTo(telLineView.mas_bottom).offset(13.5);
    }];
    
    
    UIButton *xieyiBtn = [[UIButton alloc] init];
    [xieyiBtn addTarget:self action:@selector(xieyiClick:) forControlEvents:UIControlEventTouchUpInside];
    [xieyiBtn setAttributedTitle: createAttString(@"《用户服务协议》", 12,rgba(255, 124, 78, 1)) forState:UIControlStateNormal];
    [xieyiBtn setImageEdgeInsets:UIEdgeInsetsMake(0, -4.5, 0, 4.5)];
    [contView addSubview:xieyiBtn];
    [xieyiBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(agreenBtn.mas_right).offset(1);
        make.centerY.equalTo(agreenBtn);
    }];
    
    
    UIButton *nextBtn = [[UIButton alloc] init];
    [nextBtn addTarget:self action:@selector(nextBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    nextBtn.userInteractionEnabled = NO;
    nextBtn.selected = YES;

    [nextBtn setAttributedTitle:createAttString(@"下一步", 15,rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    
    
    [nextBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [nextBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [self addSubview:nextBtn];
    _nextBtn = nextBtn;
    [nextBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(agreenBtn.mas_bottom).offset(30);
        make.centerX.mas_equalTo(0);
    }];
}
- (void)textChange:(UITextField *)tf {
    [self userAgreen];
}

- (void)xieyiClick:(UIButton *)btn {
    SMAgreementView *view = [[SMAgreementView alloc ] init];
    [view wb_showRTLFromSuperView:self.superview];
}
- (void)agreenClick:(UIButton *)btn{
    btn.selected = !btn.selected;
    [self userAgreen];
}

- (void)nextBtnClick:(UIButton *)btn {
    if (self.nextBlock) {
        self.nextBlock(self.telTF.text);
    }
    self.telTF.text = @"";
}
- (void)userAgreen {
    if (self.agreenBtn.selected && self.telTF.text.length == 11) {
        self.nextBtn.selected = NO;
        self.nextBtn.userInteractionEnabled = YES;
    }else {
        self.nextBtn.selected = YES;
        self.nextBtn.userInteractionEnabled = NO;
    }
}
@end
