//
//  SMRSetPwdView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMRSetPwdView.h"
@interface SMRSetPwdView ()
@property(nonatomic, weak)UITextField *onePwdTF;
@property(nonatomic, weak)UITextField *twoPwdTF;
@property(nonatomic, weak)UILabel *smallTipsLabel;
@property(nonatomic, strong)NSString *accountString;
@end

@implementation SMRSetPwdView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self  setupUI];
    }
    return self;
}

- (void)setupUI {
    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(255, 255, 255, 1);
    contView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    contView.layer.shadowOffset = CGSizeMake(0,4);
    contView.layer.shadowOpacity = 1;
    contView.layer.shadowRadius = 30;
    [self addSubview:contView];
    [contView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(64.5));
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [contView addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(17);
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];
    
    UILabel *setTipsLabel = [[UILabel alloc] init];
    setTipsLabel.attributedText = createAttString(@"设置密码", 25,rgba(76, 74, 66, 1));
    [contView addSubview:setTipsLabel];
    [setTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(44);
        make.top.mas_equalTo(53);
    }];

    
    UILabel *smallTipsLabel =  [[UILabel alloc] init];
    _smallTipsLabel = smallTipsLabel;
    smallTipsLabel.attributedText = createAttString(@" ",14,rgba(153, 153, 153, 1));
    [contView addSubview:smallTipsLabel];
    [smallTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(44);
        make.top.mas_equalTo(94.5);
    }];
    
    UITextField *onePwdTF = [[UITextField alloc] init];
    _onePwdTF = onePwdTF;
    onePwdTF.secureTextEntry = YES;
    onePwdTF.attributedPlaceholder = createAttString(@"请输入不少于6位数的密码", 14,rgba(185, 185, 185, 1));
    [contView addSubview:onePwdTF];
    [onePwdTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(167.5);
        make.left.mas_equalTo(45);
        make.right.mas_equalTo(-45);
    }];
    
    UIView *oneLineView = [[UIView alloc] init];
    oneLineView.layer.cornerRadius = 0.5;
    oneLineView.backgroundColor = rgba(229, 229, 229, 1);
    [contView addSubview:oneLineView];
    [oneLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(onePwdTF.mas_bottom).offset(10);
        make.left.right.equalTo(onePwdTF);
        make.height.mas_equalTo(1);
    }];
    
    UITextField *twoPwdTF = [[UITextField alloc] init];
    _twoPwdTF = twoPwdTF;
    twoPwdTF.secureTextEntry = YES;
    twoPwdTF.attributedPlaceholder =  createAttString(@"重复密码", 14,rgba(185, 185, 185, 1));
    [contView addSubview:twoPwdTF];
    [twoPwdTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(221.5);
        make.left.mas_equalTo(45);
        make.right.mas_equalTo(-45);
    }];
    
    UIView *twoLineView = [[UIView alloc] init];
    twoLineView.layer.cornerRadius = 0.5;
    twoLineView.backgroundColor = rgba(229, 229, 229, 1);
    [contView addSubview:twoLineView];
    [twoLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(twoPwdTF.mas_bottom).offset(10);
        make.left.right.equalTo(twoPwdTF);
        make.height.mas_equalTo(1);
    }];
    
    UIButton *registBtn = [[UIButton alloc] init];
    registBtn.selected = YES;
    registBtn.userInteractionEnabled = NO;
 
    [registBtn setAttributedTitle:createAttString(@"注册", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    
    [registBtn addTarget:self action:@selector(registBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [registBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [registBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [self addSubview:registBtn];
    _registBtn =registBtn;
    [registBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(twoLineView.mas_bottom).offset(30);
        make.centerX.mas_equalTo(0);
    }];

    [self.onePwdTF addTarget:self action:@selector(textFiledChange:) forControlEvents:UIControlEventEditingChanged];
    [self.twoPwdTF addTarget:self action:@selector(textFiledChange:) forControlEvents:UIControlEventEditingChanged];

}
- (void)registBtnClick:(UIButton *)btn {
    if (self.registBlock) {
        self.registBlock(self.onePwdTF.text);
    }
    self.onePwdTF.text = @"";
    self.twoPwdTF.text = @"";
}
- (void)saveAccount:(NSString *)account {
    self.accountString = account;
    
    NSMutableAttributedString *sAttString = [[NSMutableAttributedString alloc] init];
   
    [sAttString appendAttributedString:createAttString(@"账号", 14,rgba(153, 153, 153, 1))];
    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
    pDict[NSFontAttributeName] = [UIFont systemFontOfSize:14];
    pDict[NSForegroundColorAttributeName] = rgba(100, 98, 92, 1);
    pDict[NSUnderlineStyleAttributeName] = @(1);
    
    [sAttString appendAttributedString:
     [[NSAttributedString alloc] initWithString:account attributes:pDict]];
    
    [sAttString appendAttributedString:createAttString(@"由系统自动分配，请谨记", 14,rgba(153, 153, 153, 1))];
    self.smallTipsLabel.attributedText = sAttString;
    [self.onePwdTF becomeFirstResponder];
}

- (void)textFiledChange:(UITextField *)tf {
    if ([tf isEqual:self.onePwdTF] ||
        [tf isEqual:self.twoPwdTF] ) {
        NSString *onePWd =self.onePwdTF.text;
        NSString *twoPWd =self.twoPwdTF.text;
        if ([onePWd isEqualToString:twoPWd] && onePWd.length >= 6) {
            self.registBtn.selected = NO;
            self.registBtn.userInteractionEnabled = YES;
        }else {
            self.registBtn.selected = YES;
            self.registBtn.userInteractionEnabled = NO;
        }
    }

}


@end
