//
//  SMRegistView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMRegistView.h"
#import "SMDownView.h"
#import "SMRInputPhoneView.h"
#import "SMRVerificationCodeView.h"
#import "SMRSetPwdView.h"
#import "SMRCompleteView.h"

@interface SMRegistView()

@property(nonatomic, strong)SMRInputPhoneView *inputPhoneView;
@property(nonatomic, strong)SMRVerificationCodeView *vcodeView;
@property(nonatomic, strong)SMRSetPwdView *spView;

@property(nonatomic, strong)NSString *phone;
@property(nonatomic, strong)NSString *code;
@property(nonatomic, strong)NSString *account;
@end

@implementation SMRegistView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = rgba(0, 0, 0, 0.34);
    CGSize sSize = [UIScreen mainScreen].bounds.size;

    self.inputPhoneView = [[SMRInputPhoneView alloc] init];
    self.inputPhoneView.frame = CGRectMake(0,0,sSize.width,sSize.height);
    [self addSubview:self.inputPhoneView];

    self.vcodeView = [[SMRVerificationCodeView alloc] init];
    self.vcodeView.hidden = YES;
    self.vcodeView.frame = CGRectMake(0,0,sSize.width,sSize.height);
    [self addSubview:self.vcodeView];
    
    self.spView = [[SMRSetPwdView alloc] init];
//    [self.spView.registBtn addTarget:self action:@selector(spRegistClick:) forControlEvents:UIControlEventTouchUpInside];
    self.spView.hidden = YES;
    self.spView.frame = CGRectMake(0,0,sSize.width,sSize.height);
    [self addSubview:self.spView];
    
    SMDownView *downView = [[SMDownView alloc] init];
    downView.frame = CGRectMake(0, 0,sSize.width, 104.5);
    [self addSubview:downView];
    
    @weakify(self);
    
    self.inputPhoneView.nextBlock = ^(NSString * _Nonnull phone) {
        @strongify(self);
        self.phone = phone;
        self.vcodeView.hidden = NO;
        [self.inputPhoneView endEditing:YES];
        [self.vcodeView checkCodeWithPhone:phone];
    };
    self.vcodeView.endInputCodeBlock = ^(NSString * _Nonnull code) {
        @strongify(self);
        self.code = code;
        NSMutableDictionary *pDict = [[NSMutableDictionary alloc ] init];
        pDict[@"code"] = code;
        [self postFormDataWithUrl:@"/magnifier/public/generateAccount" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
            @strongify(self);
            if ([JsonData.code isEqualToString:@"200"]) {
                NSString *account = (NSString *)JsonData.data;
                self.account = account;
                self.spView.hidden = NO;
                [self.vcodeView endEditing:YES];
                [self.spView saveAccount:account];

            }else {
                [SVProgressHUD showErrorWithStatus:@"验证失败"];
            }
        }];
    
    };

    self.spView.registBlock = ^(NSString * _Nonnull pwd) {
        @strongify(self);
        NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
        pDict[@"account"] = self.account;
        pDict[@"phone"] = self.phone;
        pDict[@"pwd"] = encryptAES128(pwd, @"jinhaoyang201905");
        pDict[@"verifycode"] = self.code;
        
        [self postFormDataWithUrl:@"/magnifier/public/registeredMember" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
            @strongify(self);
            self.inputPhoneView.hidden = NO;
            self.vcodeView.hidden = YES;
            self.spView.hidden = YES;
            if ([JsonData.code isEqualToString:@"200"]) {
                NSDictionary *rDict = ( NSDictionary *)JsonData.data;
                NSMutableDictionary *sDict = [[NSMutableDictionary alloc] init];
                [SMGlobalModel share].mid = [NSString stringWithFormat:@"%@", rDict[@"id"]];
                [SMGlobalModel share].account = rDict[@"account"];
                [SMGlobalModel share].dmname = rDict[@"dmname"];
                sDict[@"account"] =  self.account;
                sDict[@"pwd"] = encryptAES128(pwd, @"jinhaoyang201905");
                [[NSUserDefaults standardUserDefaults] setObject:sDict forKey:@"saveAccountKey"];
                SMRCompleteView *cView = [[SMRCompleteView alloc] init];
                cView.frame = CGRectMake(0,safaTop(64.5) ,self.bounds.size.width,self.bounds.size.height-safaTop(64.5));
                [self addSubview:cView];
        @weakify(cView);
                cView.compBlock = ^{
                    @strongify(self);
                    @strongify(cView);
                    if (self.registBlock) {
                        self.registBlock([SMGlobalModel share].account, [SMGlobalModel share].dmname);
                    }
                    [cView removeFromSuperview];
                };
            }else if([JsonData.code isEqualToString:@"-53"]){
                [SVProgressHUD showErrorWithStatus:@"手机号码已存在"];
            }else {
                [SVProgressHUD showErrorWithStatus:@"注册失败"];
            }
        }];
    };
}

- (void)spRegistClick:(UIButton *)btn {

}
@end
