//
//  SMCheckOilBGView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/8.
//

#import "SMCheckOilBGView.h"
#import "RippleView.h"

@interface SMCheckOilBGView()
@property(nonatomic, strong)RippleView *rView;
@property(nonatomic, weak)UIImageView *tipsImageView;
@property(nonatomic, strong)UIView *faildView;
@property(nonatomic, strong)UIView *okView;
@end

@implementation SMCheckOilBGView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = rgba(0, 0, 0, 0.34);
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.attributedText = createAttString(@"水份检测", 17, rgba(255, 255, 255, 1));
    [self addSubview:titleLabel];
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(safaTop(35.5));
    }];
    self.okView = [[UIView alloc] init];

    self.okView.backgroundColor = [UIColor clearColor];
    [self addSubview:self.okView];
    [self.okView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    
    //请轻压放大镜保持3秒以上
    UILabel *tipsLabel = [[UILabel alloc]init];
    tipsLabel.attributedText = createAttString(@"请轻压放大镜保持3秒以上", 18, rgba(255, 255, 255, 1));
    [self.okView addSubview:tipsLabel];
    [tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(titleLabel.mas_bottom).offset(78);
    }];
    
    
    UIImageView *tipsImageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"dh_check_Oil_bg_1"]];
    tipsImageView.animationImages = @[
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_1"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_2"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"],
        [UIImage imageNamed:@"dh_check_Oil_bg_3"]];
    [self.okView addSubview:tipsImageView];
    _tipsImageView = tipsImageView;
    [tipsImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.mas_equalTo(0);
//        make.top.mas_equalTo(355);
    }];

    
    self.rView = [[RippleView alloc] init];
    self.rView.rippleColor = rgba(60, 60, 60, 1);
    [self.okView addSubview:self.rView];
    [self.rView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(tipsImageView);
        make.size.mas_equalTo(CGSizeMake(200,200 ));
    }];
    
    [self startAnimation];

    self.faildView = [[UIView alloc] init];
    self.faildView.hidden = YES;
    self.faildView.backgroundColor = [UIColor clearColor];
    [self addSubview:self.faildView];
    [self.faildView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    UIImageView *faildImageView = [[UIImageView alloc] init];
    faildImageView.image = [UIImage imageNamed:@"sf_icon_failure"];
    [self.faildView addSubview:faildImageView];
    [faildImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(safaTop(186));
    }];
    
    UILabel *faildBigTips = [[UILabel alloc] init];
    faildBigTips.attributedText = createAttString(@"检测失败", 20, [UIColor whiteColor]);
    [self.faildView addSubview:faildBigTips];
    [faildBigTips mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(faildImageView.mas_bottom).offset(22);
    }];
    
    UILabel *faildlittleTips = [[UILabel alloc] init];
    faildlittleTips.attributedText = createAttString(@"请检查设备是否使用正确", 15, [UIColor whiteColor]);
    [self.faildView addSubview:faildlittleTips];
    [faildlittleTips mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(faildBigTips.mas_bottom).offset(14);
    }];
    
    UIButton *checkBtn = [[UIButton alloc] init];
    [checkBtn addTarget:self action:@selector(checkBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [checkBtn setAttributedTitle:createAttString(@"重新检测", 15, [UIColor whiteColor]) forState:UIControlStateNormal];
    [checkBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(255.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xf borderWidth:0 borderColor:[UIColor clearColor]] forState:UIControlStateNormal];
    [self.faildView addSubview:checkBtn];
    [checkBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(safaBottom(-108));
    }];
    
    UIButton *faildkBtn = [[UIButton alloc] init];
    [faildkBtn addTarget:self action:@selector(faildkBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [faildkBtn setAttributedTitle:createAttString(@"取消检测", 15, [UIColor whiteColor]) forState:UIControlStateNormal];
    [faildkBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(94, 69, 60, 1) size:CGSizeMake(255.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xf borderWidth:0 borderColor:[UIColor clearColor]] forState:UIControlStateNormal];
    [self.faildView addSubview:faildkBtn];
    [faildkBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(safaBottom(-48));
    }];
    
}
- (void)checkBtnClick:(UIButton *)btn {
    if (self.BtnSendBlock) {
        self.BtnSendBlock(YES);
    }
}

- (void)faildkBtnClick:(UIButton *)btn {
    if (self.BtnSendBlock) {
        self.BtnSendBlock(NO);
    }
}
- (void)startAnimation {
    [self.tipsImageView startAnimating];
    [self.rView startAnimation];
}
- (void)stopAnimation {
    [self.tipsImageView stopAnimating];
    [self.rView stopAnimation];
}

- (void)faildViewHidden:(BOOL)hidden {
    self.faildView.hidden = hidden;
    self.okView.hidden = !hidden;
}
@end
