//
//  SMClientCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/6.
//

#import "SMClientCell.h"

@implementation SMClientCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.iconImageView = [[UIImageView alloc] init];
    self.iconImageView.contentMode = UIViewContentModeScaleAspectFill;
    self.iconImageView.layer.cornerRadius = 22;
    self.iconImageView.layer.masksToBounds = YES;
    self.iconImageView.image = [UIImage imageNamed:@"customer_logo"];
    [self.contentView addSubview:self.iconImageView];
    [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.mas_equalTo(20);
        make.bottom.mas_equalTo(-20);
        make.size.mas_equalTo(CGSizeMake(44, 44));
    }];
    
    UIView *contLabelView = [[UIView alloc] init];
    [self.contentView addSubview:contLabelView];
    [contLabelView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.iconImageView.mas_right).offset(4.5);
        make.right.mas_equalTo(0);
        make.centerY.mas_equalTo(0);
    }];
    
    self.nameLabel = [[UILabel alloc] init];
    self.nameLabel.attributedText = createAttString(@"xxxx", 18, rgba(76, 74, 66, 1));
    [contLabelView addSubview:self.nameLabel];
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.mas_equalTo(0);
        make.right.mas_equalTo(-60);
    }];
    
    self.timeLabel = [[UILabel alloc] init];
    self.timeLabel.attributedText = createAttString(@"建档:2018", 12,rgba(153, 153, 153, 1));
    [contLabelView addSubview:self.timeLabel];
    [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.left.mas_equalTo(0);
        make.top.equalTo(self.nameLabel.mas_bottom).offset(10);
    }];
    
    self.cameraBtn = [[UIButton alloc] init];
    [self.cameraBtn addTarget:self action:@selector(cameraClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.cameraBtn wb_setImageName:@"list_icon_xj"];
    [self.contentView addSubview:self.cameraBtn];
    [self.cameraBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.iconImageView);
        make.right.mas_equalTo(-8.5);
        make.size.mas_equalTo(CGSizeMake(40, 40));
    }];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(229, 229, 229, 1);
    lineView.layer.cornerRadius = 0.25;
    [self.contentView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(23);
        make.right.mas_equalTo(-20);
        make.bottom.mas_equalTo(0);
        make.height.mas_equalTo(0.5);
    }];

}
- (void)cameraClick:(UIButton *)btn {
    if (self.cameraBlock) {
        self.cameraBlock();
    }
}

@end
