//
//  SMClientDetailViewController.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/4.
//

#import "SMClientDetailViewController.h"
#import "SMClientDetailCell.h"
#import "SMCreateClientViewController.h"
#import "SMTakeImageViewController.h"
#import "SMLocalReportModel.h"

#import "SMEditPositionNameView.h"
#import "SMReportViewController.h"
#import "SMLinkDeviceView.h"
#import "SDImageCache.h"
#import "SMClientDetailModel.h"

@interface SMClientDetailViewController ()<UITableViewDataSource,UITableViewDelegate>

@property(nonatomic, strong)UIImageView *iconImageView;
@property(nonatomic, strong)UIImageView *editImageView;
@property(nonatomic, strong)UIImageView *sexImageView;
@property(nonatomic, strong)UILabel *namaLabel;
@property(nonatomic, strong)UILabel *timeLabel;

/// 本地数据
@property(nonatomic, strong)NSMutableArray *dataArray;
/// 网络数据
@property(nonatomic, strong)NSMutableArray *netWorkdataArray;
@property(nonatomic, weak)UITableView *mainTableView;


@end

@implementation SMClientDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.dataArray = [[NSMutableArray alloc] init];
    self.netWorkdataArray = [[NSMutableArray alloc] init];
    self.view.backgroundColor = rgba(243, 243, 243, 1);
    UIImageView *bgImageView = [[UIImageView alloc] init];
    bgImageView.image = [UIImage imageNamed:@"report_header_bg"];
    [self.view addSubview:bgImageView];
    [bgImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.mas_equalTo(0);
    }];
    
    
    UIButton *iconbgBtn = [[UIButton alloc] init];
    [iconbgBtn addTarget:self action:@selector(iconbgBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    iconbgBtn.backgroundColor = [UIColor clearColor];
    iconbgBtn.layer.borderColor = [UIColor whiteColor].CGColor;
    iconbgBtn.layer.borderWidth = 2;
    iconbgBtn.layer.masksToBounds = YES;
    iconbgBtn.layer.cornerRadius = 68/2;
    [self.view addSubview:iconbgBtn];
    [iconbgBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(28.5);
        make.top.mas_equalTo(safaTop(62));
        make.size.mas_equalTo(CGSizeMake(68, 68));
    }];
    
    self.iconImageView = [[UIImageView alloc] init];
    self.iconImageView.contentMode = UIViewContentModeScaleAspectFill;
    self.iconImageView.layer.masksToBounds = YES;
    self.iconImageView.layer.cornerRadius = 24;
    [self.view addSubview:self.iconImageView];
    [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.mas_equalTo(iconbgBtn);
        make.size.mas_equalTo(CGSizeMake(48, 48));
    }];
    
    UIButton *editBtn = [[UIButton alloc] init];
    editBtn.userInteractionEnabled = NO;
    [editBtn setBackgroundImage:[UIImage imageNamed:@"customer_image_bg"] forState:UIControlStateNormal];
    [self.view addSubview:editBtn];
    [editBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.iconImageView);
        make.bottom.equalTo(self.iconImageView).offset(10);
        make.size.mas_equalTo(CGSizeMake(16, 16));
    }];
    
    self.namaLabel = [[UILabel alloc] init];
    
    [self.view addSubview: self.namaLabel];
    [self.namaLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(iconbgBtn.mas_right).offset(15);
        make.top.mas_equalTo(safaTop(72));
        make.right.mas_lessThanOrEqualTo(-100);
    }];
    
    
    self.sexImageView = [[UIImageView alloc] init];
    
    [self.view addSubview:self.sexImageView];
    [self.sexImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(self.namaLabel);
        make.left.equalTo(self.namaLabel.mas_right).offset(4);
    }];
    
    self.timeLabel = [[UILabel alloc] init];
    [self.view addSubview: self.timeLabel];
    [self.timeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(iconbgBtn.mas_right).offset(15);
        make.bottom.equalTo(iconbgBtn).offset(-10);
    }];
    
    
    UIButton *takebtn = [[UIButton alloc] init];
    [takebtn addTarget:self action:@selector(takeImageClick:) forControlEvents:UIControlEventTouchUpInside];
    [takebtn wb_setImageName:@"customer_xj"];
    [self.view addSubview:takebtn];
    [takebtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(39.5, 39.5));
        make.right.mas_equalTo(-15.5);
        make.centerY.equalTo(iconbgBtn);
    }];
    
    
    UITableView *mainTableView = [[UITableView alloc] init];
    _mainTableView = mainTableView;
    @weakify(self);
    self.mainTableView.mj_header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        @strongify(self);
        [self requestDataWithCurrerisHeader:YES];
    }];
    self.mainTableView.mj_footer = [MJRefreshBackFooter footerWithRefreshingBlock:^{
        @strongify(self);
        [self requestDataWithCurrerisHeader:NO];
    }];
    mainTableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    UIView *headerView = [[UIView alloc] init];
    headerView.backgroundColor = [UIColor whiteColor];
    headerView.frame = CGRectMake(0, 0, 50, 30);
    mainTableView.tableHeaderView = headerView;
    mainTableView.dataSource = self;
    mainTableView.delegate = self;
    mainTableView.layer.masksToBounds = YES;
    mainTableView.layer.cornerRadius = 10;
    //    mainTableView.backgroundColor = [UIColor wb_randColor];
    [mainTableView registerClass:[SMClientDetailCell class] forCellReuseIdentifier:NSStringFromClass([SMClientDetailCell class])];
    [self.view addSubview: mainTableView];
    [mainTableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.right.mas_equalTo(-15);
        make.bottom.mas_equalTo(0);
        make.top.mas_equalTo(safaTop(174));
    }];
    
    UIButton *checkBtn = [[UIButton alloc] init];
    checkBtn.userInteractionEnabled = NO;
    [checkBtn setAttributedTitle: createAttString(@"单点检测", 14, rgba(255, 126, 65, 1)) forState:UIControlStateNormal];
    UIImage *cImage =  [[UIImage wb_imageWithColor:rgba(255, 239, 228, 1) size:CGSizeMake(100, 32)] sd_roundedCornerImageWithRadius:16 corners:0xf borderWidth:2 borderColor:[UIColor whiteColor]];
    [checkBtn setBackgroundImage:cImage forState:UIControlStateNormal];
    [self.view addSubview:checkBtn];
    [checkBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(mainTableView.mas_top);
        make.left.mas_equalTo(mainTableView).offset(13);
    }];
    
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self requestDataWithCurrerisHeader:YES];
    [self.iconImageView sd_setImageWithURL:[NSURL URLWithString:self.clinetModel.clientimg] placeholderImage:[UIImage imageNamed:@"customer_logo"]];
    self.namaLabel.attributedText = createAttString(self.clinetModel.cname, 25, rgba(68, 57, 53, 1));
    if ([self.clinetModel.sex isEqualToString:@"0"]) {
        self.sexImageView.image = [UIImage imageNamed:@"sex_nv_icon"];
    }else {
        self.sexImageView.image = [UIImage imageNamed:@"sex_nan_icon"];
    }
    
    NSString *dateString = timestampString(self.clinetModel.createtime.longLongValue/1000,@"YYYY/MM/dd hh:mm:ss");
    self.timeLabel.attributedText = createAttString([NSString stringWithFormat:@"建档: %@",dateString], 12, rgba(68, 57, 53, 1));
    
}

- (void)takeImageClick:(UIButton *)btn {
    
    @weakify(self);
    if (islinkDeviceWifi()) {
        
        SMTakeImageViewController *vc = [[SMTakeImageViewController alloc] init];
        vc.clinetModel = self.clinetModel;
        [self.navigationController pushViewController:vc animated:YES];
    }else {
        SMLinkDeviceView *linkView = [[SMLinkDeviceView alloc] init];
        
        linkView.flishBlock = ^{
            @strongify(self);
            SMTakeImageViewController *vc = [[SMTakeImageViewController alloc] init];
            vc.clinetModel = self.clinetModel;
                    [self.navigationController pushViewController:vc animated:YES];
        };
        [linkView wb_showFromSuperView: self.view];
    }

}
- (void)requestDataWithCurrerisHeader:(BOOL)isHeader{
    int from = (int)self.dataArray.count ;
    if (isHeader) {
        from = 0;
    }


    NSMutableArray *dataArray = [[SMLocalReportBManager sharedManager] selectWithCid:self.clinetModel.ID from:from];
    for (SMLocalReportModel *model  in dataArray) {
        if (model.moisture.oMethod && model.AISymptomArray.count == 0) {
            SMLocalReportAIModel *shuifenModel = [[SMLocalReportAIModel alloc] init];
            shuifenModel.tagFlag = @"magn_water";
            shuifenModel.tagValue = model.moisture.ofen;
            shuifenModel.aiImageUrl = @"";
            shuifenModel.dermalogicatext = model.moisture.oMethod;
            shuifenModel.tagname = @"水份";
            
            [model.AISymptomArray addObject:shuifenModel];
        }
    }

    if (isHeader) {
        [self.dataArray removeAllObjects];
    }
    if (dataArray.count) {
        [self.dataArray addObjectsFromArray:dataArray];
        if (dataArray.count == KPageSize) {
            [self.mainTableView.mj_footer endRefreshing];
            [self.mainTableView.mj_header endRefreshing];
            [self.mainTableView reloadData];
            return;
        }
    }
        [self.mainTableView.mj_footer endRefreshing];
        [self.mainTableView.mj_header endRefreshing];
        [self.mainTableView reloadData];
    

    if (TARGET_IPHONE_SIMULATOR == 1 && TARGET_OS_IPHONE == 1) {

    }else {
        if (islinkDeviceWifi()) {
            return;
        }
    }



        NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
        pDict[@"pageSize"] = [NSString stringWithFormat:@"%d",KPageSize];
        pDict[@"clientid"] = self.clinetModel.ID;
        if (isHeader) {
            pDict[@"currentPage"] = @"1";
        }else {
            pDict[@"currentPage"] = [NSString stringWithFormat:@"%ld" ,(self.netWorkdataArray.count /KPageSize)+(self.netWorkdataArray.count % KPageSize ? 1:0)+1];
        }

        @weakify(self);
        [self.view postFormDataWithUrl:@"/magnifier/client/findClientMagnifierCgList" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
            @strongify(self);
            [self.mainTableView.mj_header endRefreshing];
            [self.mainTableView.mj_footer endRefreshing];
            if ([JsonData.code isEqualToString:@"200"]) {
                NSArray *netWorkdataArray = [SMClientDetailModel mj_objectArrayWithKeyValuesArray:((NSDictionary *)JsonData.data)[@"magnifierCaseGroups"]];
                if (netWorkdataArray.count) {
                    if (isHeader) {
                        [self.netWorkdataArray removeAllObjects];
                    }
                    [self.netWorkdataArray addObjectsFromArray:netWorkdataArray];
                }

                [self.mainTableView reloadData];
            }
        }];
    
}

- (void)iconbgBtnClick:(UIButton *)btn {
    SMCreateClientViewController *vc = [[SMCreateClientViewController alloc] init];
    vc.clientModel = self.clinetModel;
    [self.navigationController pushViewController:vc animated:YES];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if (section == 0) {
        return self.dataArray.count;
    }
    return self.netWorkdataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
  
    SMClientDetailCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMClientDetailCell class])];

    if (indexPath.section == 0) {
        SMLocalReportModel *localmodel = self.dataArray[indexPath.row];
        cell.timeLabel.attributedText = createAttString(timestampString(localmodel.createTime.longLongValue, @"YYYY-MM-dd HH:mm:ss"), 14, rgba(76, 74, 66, 1));
        cell.typeLabel.attributedText =  createAttString(localmodel.iposition, 14, rgba(76, 74, 66, 1));
    }else if (indexPath.section ==1) {
        SMClientDetailModel *netmodel = self.netWorkdataArray[indexPath.row];
        cell.timeLabel.attributedText = createAttString(timestampString(netmodel.createtime.longLongValue, @"YYYY-MM-dd HH:mm:ss"), 14, rgba(76, 74, 66, 1));
        cell.typeLabel.attributedText =  createAttString(netmodel.iposition, 14, rgba(76, 74, 66, 1));
        
    }

    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    @weakify(self);
    if (indexPath.section == 0) {
        SMReportViewController *vc = [[SMReportViewController alloc] init];
        vc.clinetModel = self.clinetModel;
        vc.lrModel = self.dataArray[indexPath.row];
        [self.navigationController pushViewController:vc animated:YES];
    }else {
        NSLog(@"网络跳转");
        SMClientDetailModel *dModel = self.netWorkdataArray[indexPath.row];
        
        [self.view postFormDataWithUrl:@"/magnifier/report/findAiAnalysisReportByCgid" params:@{@"id":dModel.ID} success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
            @strongify(self);
            if ([JsonData.code isEqualToString:@"200"]) {
                NSDictionary *resDict = (NSDictionary *)JsonData.data;
                
                SMLocalReportModel *lrModel =  [SMLocalReportModel new];
                lrModel.mid = [SMGlobalModel share].mid;
                lrModel.cid = self.clinetModel.ID;
                lrModel.cgid =dModel.ID;
                lrModel.iposition = resDict[@"iposition"];
                lrModel.moisture.ofen =  [NSString stringWithFormat:@"%@",resDict[@"magnifierCgroup"][@"moisture"]] ;
                lrModel.createTime = resDict[@"createtime"];
 
                NSArray *imageNameArray = [@"日光图,极化图,纹理图,UV图,日光图" componentsSeparatedByString:@","];
                for (NSDictionary *dict in resDict[@"images"]) {
                    SMLocalReportImageModel *imgModel = [SMLocalReportImageModel new];
                    imgModel.iType = dict[@"lighttype"];
                    imgModel.iURL = dict[@"imgUrl"];
                    imgModel.iname = imageNameArray[imgModel.iType.intValue];
                    [lrModel.imageArray addObject:imgModel];
                }
                for (NSDictionary *dict in resDict[@"analysisReportAitagnameLinkGoods"]) {
                    SMLocalReportProductModel *proModel = [SMLocalReportProductModel new];
                    proModel.pType = [NSString stringWithFormat:@"%@", dict[@"goodstype"]];
                    proModel.pName = dict[@"goodsname"];
                    proModel.pId = dict[@"id"];
                    [lrModel.productArray addObject:proModel];
                }
                
                NSArray *magnifierCustomReports = resDict[@"magnifierCustomReports"];
                for (NSDictionary *dict in magnifierCustomReports) {
                    SMLocalReportSymptomModel *symModel = [SMLocalReportSymptomModel new];
                    symModel.sID = dict[@"areportLinkAitagnameId"];
                    symModel.sName = dict[@"tagname"];
                    symModel.sMethod = dict[@"dermalogicatext"];
                    [lrModel.symptomArray addObject:symModel];
                }
                

                lrModel.AISymptomArray = [SMLocalReportAIModel mj_objectArrayWithKeyValuesArray: resDict[@"magnifierReports"]];
                
                NSMutableArray *reImgeArray = [[NSMutableArray alloc] init];
                
                [reImgeArray addObjectsFromArray:[lrModel.imageArray valueForKey:@"iURL"]];
                [reImgeArray addObjectsFromArray:[lrModel.AISymptomArray valueForKey:@"aiImageUrl"]];;

                for (int i = 0; i <reImgeArray.count; i++) {

                    NSString *xinImgUrl = reImgeArray[i];
                    if (xinImgUrl.length < 5 ||
                        [xinImgUrl containsString:@"djm-skin.oss-cn-shenzhen.aliyuncs.com"]) {
                        continue;
                    }
                    NSString *jiuImgUrl = [xinImgUrl stringByReplacingOccurrencesOfString:@"imoreme.oss-cn-shenzhen.aliyuncs.com" withString:@"djm-skin.oss-cn-shenzhen.aliyuncs.com"];
                    if (![self localImgCunZaiWithString:xinImgUrl] &&
                        [self localImgCunZaiWithString:jiuImgUrl] ) {
                        NSString *cacheKey = [[SDWebImageManager sharedManager] cacheKeyForURL:[NSURL URLWithString:jiuImgUrl]];
                        UIImage *img = [[SDImageCache sharedImageCache] imageFromDiskCacheForKey:cacheKey];
                        [[SDImageCache sharedImageCache] storeImage:img forKey: xinImgUrl completion:^{
                        }];
                    }
                }
                
                
                
                SMReportViewController *vc = [[SMReportViewController alloc] init];
                vc.clinetModel = self.clinetModel;
                vc.lrModel = lrModel;
                vc.netWorkData = YES;
                [self.navigationController pushViewController:vc animated:YES];
            }

        }];
    }
}
- (BOOL)localImgCunZaiWithString:(NSString *)imgString {
    NSString *xincacheKey = [[SDWebImageManager sharedManager] cacheKeyForURL:[NSURL URLWithString:imgString]];
    BOOL xinCZ = [[SDImageCache sharedImageCache] diskImageDataExistsWithKey:xincacheKey];
    return xinCZ;
}

- (UISwipeActionsConfiguration *)tableView:(UITableView *)tableView trailingSwipeActionsConfigurationForRowAtIndexPath:(NSIndexPath *)indexPath {

    @weakify(self);
    UIContextualAction *deleteRowAction = [UIContextualAction contextualActionWithStyle:UIContextualActionStyleDestructive title:@"delete" handler:^(UIContextualAction * _Nonnull action, __kindof UIView * _Nonnull sourceView, void (^ _Nonnull completionHandler)(BOOL)) {
        //左滑删除之后数据处理操作
        @strongify(self);
        
        UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"确定删除当前案例组吗？" message:@"" preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction *conform = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            if (indexPath.section == 0) {
                SMLocalReportModel *model = self.dataArray[indexPath.row];
                NSArray *localDataArray = [[SMLocalReportBManager sharedManager] selectWithCgid:model.cgid];
                if (localDataArray.count == 0) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再删除"];
                    return ;
                }
                SMLocalReportModel *localModel = localDataArray.firstObject;
                if ([localModel.uploadLock isEqualToString:@"1"]) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再删除"];
                    return ;
                }
                [[SMLocalReportBManager sharedManager] deleteWitCgid:model.cgid];
                [self.dataArray removeObjectAtIndex:indexPath.row];
                [self.mainTableView reloadData];
            }else {
                NSLog(@"网络删除");
                SMClientDetailModel *dModel = self.netWorkdataArray[indexPath.row];
                NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
                pDict[@"id"] = dModel.ID;
                [self.view postFormDataWithUrl:@"/magnifierCaseGroup/delCaseGroupBycgid" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                    @strongify(self);
                    if ([JsonData.code isEqualToString:@"200"]) {
                        [self.netWorkdataArray removeObjectAtIndex:indexPath.row];
                        [self.mainTableView reloadData];
                    }else {
                        [SVProgressHUD showErrorWithStatus:@"删除失败"];
                    }
                }];
            }

        }];
        
        UIAlertAction *cancleAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        }];
        [alert addAction:cancleAction];
        [alert addAction:conform];
        
        [self presentViewController:alert animated:YES completion:nil];
        
    }];
    deleteRowAction.image = [UIImage imageNamed:@"client_list_button_ch_delete"];//给删除赋值图片
    deleteRowAction.backgroundColor = rgba(233, 147, 117, 1);//删除背景颜色
    
    
    UIContextualAction *editRowAction = [UIContextualAction contextualActionWithStyle:UIContextualActionStyleDestructive title:@"delete" handler:^(UIContextualAction * _Nonnull action, __kindof UIView * _Nonnull sourceView, void (^ _Nonnull completionHandler)(BOOL)) {
        //左滑删除之后数据处理操作
        @strongify(self);
        SMEditPositionNameView *nameView = [[SMEditPositionNameView alloc] init];
        [nameView wb_showFromSuperView:self.view];
        if (indexPath.section == 0) {
            SMLocalReportModel *model = self.dataArray[indexPath.row];
            [nameView configInputValue:model.iposition];
        }else {
            SMClientDetailModel *dModel = self.netWorkdataArray[indexPath.row];
            [nameView configInputValue:dModel.iposition];
        }
        
        @weakify(nameView);
        nameView.saveBlock = ^(NSString * _Nonnull str) {
            @strongify(self);
            @strongify(nameView);
            [nameView wb_disMiss];
            if (indexPath.section == 0) {
                SMLocalReportModel *model = self.dataArray[indexPath.row];
                NSArray *localDataArray = [[SMLocalReportBManager sharedManager] selectWithCgid:model.cgid];
                if (localDataArray.count == 0) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                    return ;
                }
                SMLocalReportModel *localModel = localDataArray.firstObject;
                if ([localModel.uploadLock isEqualToString:@"1"]) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                    return ;
                }
                
                model.iposition = str;
                [[SMLocalReportBManager sharedManager] updateWithModel:model cgid:model.cgid];
                
                [self.mainTableView reloadData];
            }else {
                NSLog(@"网络编辑");
                SMClientDetailModel *dModel = self.netWorkdataArray[indexPath.row];

                NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
                pDict[@"id"] = dModel.ID;
                pDict[@"iposition"] =str;
                [self.view postJsonWithUrl:@"/magnifierCaseGroup/updateMagnifierCaseGroup" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                    @strongify(self);
                    if ([JsonData.code isEqualToString:@"200"]) {
                        dModel.iposition = str;
                        [self.mainTableView reloadData];
                    }else {
                        [SVProgressHUD showErrorWithStatus:@"编辑失败"];
                    }
                }];
            }
        };
    }];
    editRowAction.image = [UIImage imageNamed:@"customer_edit"];//给删除赋值图片
    editRowAction.backgroundColor =rgba(218, 120, 86, 1);//删除背景颜色
    
    
    UISwipeActionsConfiguration *Configuration = [UISwipeActionsConfiguration configurationWithActions:@[deleteRowAction,editRowAction]];
    return Configuration;
}

@end
