//
//  SMEditPositionNameView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/18.
//

#import "SMEditPositionNameView.h"
#import "SMDownView.h"

@interface SMEditPositionNameView()

@property(nonatomic,weak)UIButton *selectBtn;
@property(nonatomic,weak)UITextField *inputTF;
@property(nonatomic,strong)NSMutableArray *btnArray;
@property(nonatomic,weak)UIButton *saveBtn;
@end

@implementation SMEditPositionNameView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.btnArray = [[NSMutableArray alloc] init];
    self.backgroundColor = rgba(0, 0, 0, 0.34);
    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(255, 255, 255, 1);
    contView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    contView.layer.shadowOffset = CGSizeMake(0,4);
    contView.layer.shadowOpacity = 1;
    contView.layer.shadowRadius = 30;
    [self addSubview:contView];
    [contView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(64.5));
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [contView addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(17);
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];
    
    UILabel *editTipsLabel = [[UILabel alloc] init];
    editTipsLabel.attributedText = createAttString(@"编辑部位名称", 25, rgba(76, 74, 66, 1));
    [contView addSubview:editTipsLabel];
    [editTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(49);
        make.top.mas_equalTo(52);
    }];
    
    
    
    NSArray *nameArray = @[(@"额头"),(@"下巴"),
                           (@"左脸颊"),(@"右脸颊"),
                           (@"鼻头"),(@"鼻翼"),
                           (@"眼周"),(@"唇周")];
    

    UIImage *selectImage = [[UIImage wb_imageWithColor:rgba(255, 124, 78, 1)size:CGSizeMake(64, 30)]sd_roundedCornerImageWithRadius:30/2 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]];
    UIImage *normalImage = [[UIImage wb_imageWithColor:rgba(242, 238, 233, 1) size:CGSizeMake(64, 30)]sd_roundedCornerImageWithRadius:30/2 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]];
    for (int i = 0; i < nameArray.count; i++) {
        NSString *title = nameArray[i];
        UIButton *btn = [[UIButton alloc] init];
        
        [btn setAttributedTitle:createAttString(title, 14, rgba(255, 255, 255, 1)) forState: UIControlStateSelected];
        [btn setAttributedTitle:createAttString(title, 14, rgba(255, 124, 78, 1)) forState: UIControlStateNormal];
        btn.imageEdgeInsets = UIEdgeInsetsMake(0, -5, 0, 5);
        [btn setBackgroundImage:normalImage forState:UIControlStateNormal];
        [btn setBackgroundImage:selectImage forState:UIControlStateSelected];

        [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        [contView addSubview:btn];
        [self.btnArray addObject:btn];
        [btn mas_makeConstraints:^(MASConstraintMaker *make) {
            CGFloat l =  (i%4*74)+45;
            CGFloat t = (i/4*50)+107;
            make.left.mas_equalTo(l);
            make.top.mas_equalTo(t);
            make.size.mas_equalTo(CGSizeMake(64, 30));
        }];
        
    }
    UIView *lastView = contView.subviews.lastObject;
    
    UITextField *inputTF = [[UITextField alloc] init];
    inputTF.placeholder = @"请输入部位名称";
    inputTF.font = [UIFont systemFontOfSize:18];
    inputTF.textColor = rgba(76, 74, 66, 1);
    [inputTF addTarget:self action:@selector(nameTextFieldChange:) forControlEvents:UIControlEventEditingChanged];
    [contView addSubview:inputTF];
    _inputTF = inputTF;
    [inputTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(lastView.mas_bottom).offset(49-13);
        make.left.mas_equalTo(48.5);
        make.height.mas_equalTo(13+13+16);
        make.right.mas_equalTo(-48.5);
    }];
    
    UIView *inputLineView = [[UIView alloc] init];
    inputLineView.backgroundColor = rgba(229, 229, 229, 1);
    [contView addSubview:inputLineView];
    [inputLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45.5);
        make.right.mas_equalTo(-45.5);
        make.height.mas_equalTo(0.5);
        make.top.equalTo(inputTF.mas_bottom);
    }];

    UIButton *saveBtn = [[UIButton alloc] init];
    _saveBtn = saveBtn;
    saveBtn.userInteractionEnabled = NO;
    saveBtn.selected = YES;
    [saveBtn addTarget:self action:@selector(saveBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [saveBtn setAttributedTitle:createAttString(@"保存", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];

    [saveBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [saveBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [contView addSubview:saveBtn];
    [saveBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(inputLineView.mas_bottom).offset(30);
        make.centerX.mas_equalTo(0);
    }];
    
    CGSize sSize = [UIScreen mainScreen].bounds.size;
    SMDownView *downView = [[SMDownView alloc] init];
    downView.frame = CGRectMake(0, 0,sSize.width, 104.5);
    [self addSubview:downView];
    
}

- (void)saveBtnClick:(UIButton *)btn {
    if (self.inputTF.text.length == 0) {
        [SVProgressHUD showErrorWithStatus:@"部位名称不能为空"];
        return;
    }
    if ([self.inputTF.text containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"部位名称不能输入表情"];
        return;
    }
    if (self.inputTF.text.length > 6)  {
        [SVProgressHUD showErrorWithStatus:@"部位名称不能超过6个字"];
        return;
    }
    if (self.saveBlock) {
        self.saveBlock(self.inputTF.text);
    }
}

- (void)nameTextFieldChange:(UITextField *)tf {
    BOOL selectBool = NO;
    for (UIButton *btn in self.btnArray) {
        NSString *btnTitle = [btn attributedTitleForState:UIControlStateNormal].string;
        if ([btnTitle isEqualToString:tf.text]) {
            self.selectBtn.selected = NO;
            btn.selected = YES;
            btn.userInteractionEnabled = NO;
            self.selectBtn = btn;
            selectBool = YES;
            break;
        }
    }
    if (!selectBool) {
        self.selectBtn.selected = NO;
        self.selectBtn.userInteractionEnabled = YES;
        self.selectBtn = nil;
    }
    self.saveBtn.selected = !tf.text.length;
    self.saveBtn.userInteractionEnabled =  tf.text.length;
}

- (void)btnClick:(UIButton *)btn {
    btn.selected = YES;
    btn.userInteractionEnabled = NO;
    self.selectBtn.selected = NO;
    self.selectBtn.userInteractionEnabled = YES;
    self.selectBtn = btn;
    _inputTF.text = [btn attributedTitleForState:UIControlStateNormal].string;
    self.saveBtn.selected = !_inputTF.text.length;
    self.saveBtn.userInteractionEnabled =  _inputTF.text.length;
}

- (void)configInputValue:(NSString *)value {
    self.inputTF.text = value;
    [self nameTextFieldChange:self.inputTF];
}

@end
