//
//  SMLinkDeviceView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/12.
//

#import "SMLinkDeviceView.h"

@interface SMLinkDeviceView()

@property(nonatomic, strong)dispatch_source_t timer;

@end

@implementation SMLinkDeviceView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    
    self.backgroundColor = [UIColor whiteColor];
    
    
    UIButton *deleteBtn = [[UIButton alloc] init];
    [deleteBtn addTarget:self action:@selector(deleteClick:) forControlEvents:UIControlEventTouchUpInside];
    [deleteBtn wb_setImageName:@"pop_icon_Shut"];
    [self addSubview:deleteBtn];
    [deleteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(25));
        make.left.mas_equalTo(10);
        make.size.mas_equalTo(CGSizeMake(25, 25));
    }];
    
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.attributedText = createAttString(@"连接设备", 25, rgba(76, 74, 66, 1));
    [self addSubview:titleLabel];
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(81.5));
        make.centerX.mas_equalTo(0);
    }];
    
    UILabel *oneTipsLabel = [[UILabel alloc] init];
    /// 抗拉伸
    [oneTipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
    oneTipsLabel.attributedText = createAttString(@"1.将设备开机，等待蓝色指示灯闪烁", 15,rgba(153, 153, 153, 1));
    [self addSubview:oneTipsLabel];
    [oneTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(138));
        make.centerX.mas_equalTo(0);
    }];
    
    UILabel *twoTipsLabel = [[UILabel alloc] init];
    twoTipsLabel.numberOfLines = 0;
    NSMutableAttributedString *twoAttString = [[NSMutableAttributedString alloc] init];
    [twoAttString appendAttributedString:createAttString(@"2.将手机连接到以", 15,rgba(153, 153, 153, 1))];
    [twoAttString appendAttributedString:createAttString(@"“DAS01-1”", 15,rgba(76, 74, 66, 1))];
    [twoAttString appendAttributedString:createAttString(@"开头的WiFi网络，密码：", 15,rgba(153, 153, 153, 1))];
    [twoAttString appendAttributedString:createAttString(@"12345678", 15,rgba(76, 74, 66, 1))];
    twoTipsLabel.attributedText = twoAttString;
    [self addSubview:twoTipsLabel];
    [twoTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(138+40));
        make.left.right.equalTo(oneTipsLabel);
    }];
    
    UILabel *threeTipsLabel = [[UILabel alloc] init];
    /// 抗拉伸
    threeTipsLabel.attributedText = createAttString(@"3.返回app，此时设备将自动连上", 15,rgba(153, 153, 153, 1));
    [self addSubview:threeTipsLabel];
    [threeTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(138+40+50));
        make.left.equalTo(oneTipsLabel);
    }];
    
    UIImageView *imgView = [[UIImageView alloc] init];
    imgView.image = [UIImage imageNamed:@"link_tips_pop_bg"];
    [self addSubview:imgView];
    [imgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(threeTipsLabel.mas_bottom).offset(32);
    }];
    
    
    UIButton *setBtn = [[UIButton alloc] init];
    [setBtn addTarget:self action:@selector(setBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [setBtn setAttributedTitle:createAttString(@"前往设置", 15,rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    
    [setBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [self addSubview:setBtn];
    [setBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(imgView.mas_bottom).offset(40);
        make.centerX.mas_equalTo(0);
    }];
    @weakify(self);
    dispatch_source_t timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0, dispatch_get_main_queue());
    dispatch_source_set_timer(timer, DISPATCH_TIME_NOW, 5 * NSEC_PER_SEC, 0 * NSEC_PER_SEC);
    dispatch_source_set_event_handler(timer, ^{
        @strongify(self);
        [self setTask];
    });
    dispatch_resume(timer);
    _timer = timer;
    
}

- (void)setTask {
    
    if (islinkDeviceWifi()) {
        if (self.flishBlock) {
            self.flishBlock();
        }
    }
    
    if (islinkDeviceWifi()) {
        if (self.superview) {
            [self wb_disMiss];
        }
    }

}
- (void)setBtnClick:(UIButton *)btn {
    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:UIApplicationOpenSettingsURLString] options:@{} completionHandler:nil];
    
//    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(enterForegroud:) name:UIApplicationWillEnterForegroundNotification object:nil];
}

//- (void)enterForegroud:(NSNotification *)noti {
//    [[NSNotificationCenter defaultCenter] removeObserver:self];
//    if (islinkDeviceWifi()) {
//        if (self.flishBlock) {
//            self.flishBlock();
//        }
//    }
//}

- (void)deleteClick:(UIButton *)btn {
    btn.userInteractionEnabled = NO;
    [self wb_disMiss];
    btn.userInteractionEnabled = YES;
}


@end
