//
//  SMReportProjectCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/26.
//

#import "SMReportProjectCell.h"

@interface SMReportProjectCell()

@end


@implementation SMReportProjectCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    self.iconImageView = [[UIButton alloc] init];
    
    [self.iconImageView setImage:[UIImage imageNamed:@"report_icon_add_yq"]   forState:UIControlStateNormal];
    [self.iconImageView setImage:[UIImage imageNamed:@"report_icon_add_cp"]   forState:UIControlStateSelected];
    [self.iconImageView setAttributedTitle:createAttString(@"产品", 9, [UIColor whiteColor]) forState:UIControlStateSelected];
    [self.contentView addSubview:self.iconImageView];
    [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(52, 52));
        make.top.mas_equalTo(15);
        make.bottom.mas_equalTo(-15);
        make.left.mas_equalTo(20.5);
    }];
    
    self.projectTypeBtn = [[UIButton alloc] init];
    [self.projectTypeBtn setAttributedTitle:createAttString(@"仪器", 9, [UIColor whiteColor]) forState:UIControlStateNormal];
    [self.projectTypeBtn setAttributedTitle:createAttString(@"产品", 9, [UIColor whiteColor]) forState:UIControlStateSelected];
    UIImage *img = [[[UIImage wb_imageWithColor:rgba(169, 169, 169, 1) size:CGSizeMake(30, 14)] sd_roundedCornerImageWithRadius:5 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]] resizableImageWithCapInsets:UIEdgeInsetsMake(14, 6, 14, 6)];
    [self.projectTypeBtn setBackgroundImage:img forState:UIControlStateNormal];
    self.projectTypeBtn.contentEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 5);
    [self.contentView addSubview:self.projectTypeBtn];
    [self.projectTypeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo( self.iconImageView);
        make.centerX.equalTo(self.iconImageView.mas_right);
    }];
    
    self.projectNameLabel = [[UILabel alloc] init];
    self.projectNameLabel.attributedText = createAttString(@"洁肤清爽浸透爽肤水", 15, rgba(76, 74, 66, 1));
    [self.contentView addSubview:self.projectNameLabel];
    [self.projectNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.iconImageView.mas_right).offset(28.5);
        make.centerY.equalTo(self.iconImageView);
        make.right.mas_equalTo(-20);
    }];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(243, 243, 243, 1);
    [self.contentView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.bottom.mas_equalTo(0);
        make.height.mas_equalTo(1);
        make.right.mas_equalTo(-20);
    }];
    
}
@end
