//
//  SMReportSchemeCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/23.
//

#import "SMReportSchemeCell.h"
@interface SMReportSchemeCell()

@property(nonatomic, weak)UILabel *symptomTitleLabel;

@property(nonatomic, weak)UILabel *nursingTitleLabel;

@end


@implementation SMReportSchemeCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    UILabel *oilLabel = [[UILabel alloc] init];
    _nameValueLabel = oilLabel;
    oilLabel.attributedText = createAttString(@" ", 18, rgba(76, 74, 66, 1));
    [self.contentView addSubview:oilLabel];
    [oilLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(19);
        make.centerX.mas_equalTo(0);
    }];

    UIView *oliLineView = [[UIView alloc] init];
    oliLineView.backgroundColor = rgba(235, 230, 223, 1);
    [self.contentView insertSubview:oliLineView belowSubview:oilLabel];
    [oliLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(oilLabel.mas_bottom).offset(-1);
        make.centerX.equalTo(oilLabel);
        make.height.mas_equalTo(6);
        make.left.equalTo(oilLabel).offset(-10);
        make.right.equalTo(oilLabel).offset(10);
    }];
    
//    UIImageView *symptomImageView = [[UIImageView alloc] init];
//    symptomImageView.image = [UIImage imageNamed:@"report_icon_fa_bg"];
//    [self.contentView addSubview:symptomImageView];
//    [symptomImageView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(22.5);
//        make.top.equalTo(oilLabel.mas_bottom).offset(20);
//    }];
//
////    UILabel *symptomTitleLabel = [[UILabel alloc] init];
////    _symptomTitleLabel = symptomTitleLabel;
////    symptomTitleLabel.attributedText = createAttString(@"症状描述", 17, rgba(68, 57, 53, 1));
////    [self.contentView addSubview:symptomTitleLabel];
////    [symptomTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
////        make.centerY.equalTo(symptomImageView);
////        make.left.equalTo(symptomImageView.mas_right).offset(5);
////    }];
////
////    UILabel *symptomValueLabel = [[UILabel alloc] init];
////    symptomValueLabel.numberOfLines = 0;
////    _symptomValueLabel = symptomValueLabel;
////    symptomValueLabel.attributedText = createAttString(@" ", 14,rgba(76, 74, 66, 1));
////    [self.contentView addSubview:symptomValueLabel];
////    [symptomValueLabel mas_makeConstraints:^(MASConstraintMaker *make) {
////        make.top.equalTo(symptomImageView.mas_bottom).offset(13);
////        make.left.mas_equalTo(22.5);
////        make.right.mas_equalTo(-22.5);
////    }];
////
////    UIView *lineView = [[UIView alloc] init];
////    lineView.backgroundColor = rgba(243, 243, 243, 1);
////    [self.contentView addSubview:lineView];
////    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
////        make.left.right.mas_equalTo(0);
////        make.height.mas_equalTo(1);
////        make.top.equalTo(symptomValueLabel.mas_bottom).offset(18);
////    }];

    
    
    UIImageView *nursingImageView = [[UIImageView alloc] init];
    nursingImageView.image = [UIImage imageNamed:@"report_icon_fa_bg"];
    [self.contentView addSubview:nursingImageView];
    [nursingImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(22.5);
        make.top.equalTo(oilLabel.mas_bottom).offset(20);
    }];

    UILabel *nursingTitleLabel = [[UILabel alloc] init];
    _nursingTitleLabel = nursingTitleLabel;
    nursingTitleLabel.attributedText = createAttString(@"护理方法", 17, rgba(68, 57, 53, 1));
    [self.contentView addSubview:nursingTitleLabel];
    [nursingTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(nursingImageView);
        make.left.equalTo(nursingImageView.mas_right).offset(5);
    }];

    UILabel *nursingValueLabel = [[UILabel alloc] init];
    nursingValueLabel.numberOfLines = 0;
    _nursingValueLabel = nursingValueLabel;
    nursingValueLabel.attributedText = createAttString(@"", 14,rgba(76, 74, 66, 1));
    [self.contentView addSubview:nursingValueLabel];
    [nursingValueLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(nursingImageView.mas_bottom).offset(13);
        make.left.mas_equalTo(22.5);
        make.right.mas_equalTo(-22.5);
        make.bottom.mas_equalTo(-28);
    }];

    UIView *twolineView = [[UIView alloc] init];
    twolineView.backgroundColor = rgba(243, 243, 243, 1);
    [self.contentView addSubview:twolineView];
    [twolineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(10);
    }];

}
@end
