//
//  SMShowImageView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/8.
//

#import "SMShowImageView.h"
#import "SMShowImageCell.h"
#import "SMPageControl.h"

@interface SMShowImageView()<UICollectionViewDataSource,UICollectionViewDelegateFlowLayout>

@property(nonatomic, strong)UICollectionView *mainView;
@property(nonatomic, assign)CGRect sRect;
@property(nonatomic, strong)SMPageControl *pageControl;
@end

@implementation SMShowImageView


- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.layer.masksToBounds = YES;
    CGSize sSize =  [UIScreen mainScreen].bounds.size;
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc ] init];
    
    layout.itemSize =sSize;
    layout.minimumLineSpacing = 0;
    layout.minimumInteritemSpacing = 0;
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    self.mainView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
    self.mainView.dataSource = self;
    self.mainView.delegate = self;
    [ self.mainView addObserver:self forKeyPath:@"contentOffset" options:NSKeyValueObservingOptionNew context:nil];
    self.mainView.pagingEnabled = YES;
    self.mainView.showsHorizontalScrollIndicator = NO;
    self.mainView.showsVerticalScrollIndicator = NO;
    [self.mainView registerClass:[SMShowImageCell class] forCellWithReuseIdentifier:NSStringFromClass([SMShowImageCell class])];
    [self addSubview:self.mainView];
    [self.mainView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    
    self.pageControl = [[SMPageControl alloc] initWithFrame:CGRectMake(0, 0, 50, 4)];
    [self addSubview:self.pageControl];
    [self.pageControl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(-30);
    }];

    self.pageControl.cornerRadius = 5;
    self.pageControl.dotHeight = 5;
    self.pageControl.dotSpace = 6;
    self.pageControl.currentDotWidth = 5;
    self.pageControl.otherDotWidth = 5;
    self.pageControl.otherDotColor = rgba(210, 202, 202, 1);
    self.pageControl.currentDotColor = [UIColor whiteColor];
    self.pageControl.numberOfPages = 4;

}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary<NSKeyValueChangeKey,id> *)change context:(void *)context {

    int page =  (int)(self.mainView.contentOffset.x / self.mainView.bounds.size.width+0.5);
    if ( self.pageControl.currentPage != page) {
        self.pageControl.currentPage = page ;
    }
}

-(void)dealloc {
    [self.mainView removeObserver:self forKeyPath:@"contentOffset"];
}


- (void)mm_showFrameView:(UIView *)fView positionView:(UIView *)pView {
    
    CGRect xRect = [pView.superview convertRect:pView.frame toView:fView];
    [fView addSubview:self];
    self.frame = xRect;
    self.sRect = xRect;
    [self.mainView reloadData];
    [UIView animateWithDuration:0.25 animations:^{
        self.frame = CGRectMake(0, 0, fView.frame.size.width,  fView.frame.size.height);
    }];
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.dataArray.count;
}
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    SMLocalReportImageModel *model = self.dataArray[indexPath.row];
    SMShowImageCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([SMShowImageCell class]) forIndexPath:indexPath];
    

    
    @weakify(cell);
    cell.iconImageView.contentMode = UIViewContentModeCenter;
//    cell.iconImageView.backgroundColor = rgba(255, 248, 244, 1);
    [cell.iconImageView sd_setImageWithURL:[NSURL URLWithString:model.iURL] placeholderImage:nil completed:^(UIImage * _Nullable image, NSError * _Nullable error, SDImageCacheType cacheType, NSURL * _Nullable imageURL) {
        @strongify(cell);
        if (image) {
            cell.iconImageView.contentMode = UIViewContentModeScaleAspectFit;
//            cell.iconImageView.backgroundColor = [UIColor blackColor];
        }

    }];
    
    cell.titleLabel.text = model.iname;
    return cell;
}
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    [self removeFromSuperview];
}
@end
