//
//  SMAgreementView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/9.
//

#import "SMAgreementView.h"
#import <WebKit/WebKit.h>


@interface SMAgreementView()<WKNavigationDelegate,WKUIDelegate>
@property(nonatomic, strong)WKWebView *webView;

@end
@implementation SMAgreementView


- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    self.webView = [[WKWebView alloc] init];
    self.webView.UIDelegate = self;
    self.webView.navigationDelegate = self;
    [self addSubview:self.webView];
    [self.webView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    
    UIButton *backBtn = [[UIButton alloc] init];
    backBtn.frame = CGRectMake(10, safaTop(20) , 38, 45);
    [backBtn wb_setImageName:@"nav_black_back"];
    [backBtn addTarget:self action:@selector(backClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:backBtn];
    

    
    @weakify(self);
    [self postFormDataWithUrl:@"/magnifier/public/findServiceAgree" params:nil success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        @strongify(self);
        NSDictionary *rDict = (NSDictionary *)JsonData.data ;

        NSURLRequest *request = [NSURLRequest requestWithURL:[NSURL URLWithString:rDict[@"agreementUrl"]]];
        [self.webView loadRequest:request];
    }];
}
- (void)backClick:(UIButton *)btn {
    [self wb_disLTRMiss];
}
@end
