//
//  SMBase.h
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

#define KPageSize (10)
#define kMultiLangString(str) NSLocalizedString(str, nil)


#ifndef weakify
    #if DEBUG
        #if __has_feature(objc_arc)
        #define weakify(object) autoreleasepool{} __weak __typeof__(object) weak##_##object = object;
        #else
        #define weakify(object) autoreleasepool{} __block __typeof__(object) block##_##object = object;
        #endif
    #else
        #if __has_feature(objc_arc)
        #define weakify(object) try{} @finally{} {} __weak __typeof__(object) weak##_##object = object;
        #else
        #define weakify(object) try{} @finally{} {} __block __typeof__(object) block##_##object = object;
        #endif
    #endif
#endif

#ifndef strongify
    #if DEBUG
        #if __has_feature(objc_arc)
        #define strongify(object) autoreleasepool{} __typeof__(object) object = weak##_##object;
        #else
        #define strongify(object) autoreleasepool{} __typeof__(object) object = block##_##object;
        #endif
    #else
        #if __has_feature(objc_arc)
        #define strongify(object) try{} @finally{} __typeof__(object) object = weak##_##object;
        #else
        #define strongify(object) try{} @finally{} __typeof__(object) object = block##_##object;
        #endif
    #endif
#endif


#ifdef DEBUG
#define NSLog(format, ...) printf("%s\n", [[NSString stringWithFormat:format, ## __VA_ARGS__] UTF8String])
#   define DEBUG_METHOD(format, ...) printf("%s\n", [[NSString stringWithFormat:format, ## __VA_ARGS__] UTF8String])
#else
#define NSLog(format, ...)
#define DEBUG_METHOD(format, ...)
#endif

@interface SMBase : UILabel

UIColor *rgba(int r,int g ,int b ,CGFloat a);
NSAttributedString *createAttString(NSString *str,CGFloat fontSize,UIColor *color);
CGSize biliSize(CGFloat w,CGFloat h);
CGFloat safaTop(CGFloat top);
CGFloat safaBottom(CGFloat bottom);

/// 加密
NSString *encryptAES128(NSString *value, NSString *key);
/// 解密
NSString *decryptAES128(NSString *value, NSString *key);
NSString *md5String(NSString *value);

NSData *hexStringToData(NSString *hexString);
NSString *dataToHexString(NSData *data);
/// 隐私String (xxxx, 2,2,*);  xxx****xxx;
NSString *privacyString(NSString *value, int from, int len,NSString *pString);

NSString *nowTimeTimestamp(void);
NSString *timestampString(long long t ,NSString *formatter);

NSString *deviceWifiName(void);
NSString *deviceWifiPWd(void);

// WiFi地址
NSString *WIFIAddress(void);
// WiFi name
NSString *WIFIName(void);
///WIFI mac地址
NSString *WIFIMacAddress(void);

bool islinkDeviceWifi(void);

@end


@interface UILabel (SMBase)
- (void)wb_setFontSize:(CGFloat )fontSize TextColor:(UIColor *)textColor Text:(NSString *)text;
@end

@interface UIImage (SMBase)

+ (instancetype )wb_imageWithColor:(UIColor *)color;
+ (instancetype )wb_imageWithColor:(UIColor *)color size:(CGSize)size;
/// 根据不同比例设置图片
+ (instancetype )wb_biliImageName:(NSString *)name;
@end

@interface UIButton (SMBase)
- (void)wb_setImageName:(NSString *)imageName;
- (void)wb_setRightImage;
@end

@interface UIColor (SMBase)
+ (instancetype)wb_randColor;
@end

@interface NSAttributedString (SMBase)
- (instancetype)wb_initWithString:(NSString *)str FontSize:(CGFloat )fontSize TextColor:(UIColor *)textColor;
@end

@interface UIViewController (SMBase)


@property(nonatomic, strong)UILabel *wb_titleLabel;


@end

@interface UIView(SMBase)


///从下向上移动
- (void)wb_showFromSuperView:(UIView *)view;
- (void)wb_disMiss;
///从右边向左移动
- (void)wb_showRTLFromSuperView:(UIView *)view;
- (void)wb_disLTRMiss;

/// 中间放大
- (void)wb_showlTBFromSuperView:(UIView *)view;
- (void)wb_disBTlLMiss;

+ (void)showFromView:(UIView *)view text:(NSString *)text afterDelay:(CGFloat )afterDelay;

/// 箭头显示在哪个位置 // 0 上,1下.2,左,3右
-(void)alertToView:(UIView *)pView Postion:(int)postion vsize:(CGSize)vsize;

/// 箭头消息在哪个位置 // 0 上,1下.2,左,3右
-(void)alertDisMiss;
@end

NS_ASSUME_NONNULL_END
