//
//  SMCountDownButton.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/5.
//

#import "SMCountDownButton.h"
@interface SMCountDownButton()
@property(nonatomic, strong)dispatch_source_t timer;
@property(nonatomic, assign)BOOL taskIng;

@end

@implementation SMCountDownButton

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}
- (void)setupUI {
    @weakify(self);
    dispatch_source_t timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0, dispatch_get_main_queue());
    dispatch_source_set_timer(timer, DISPATCH_TIME_NOW, 1 * NSEC_PER_SEC, 0 * NSEC_PER_SEC);
    dispatch_source_set_event_handler(timer, ^{
        @strongify(self);
        [self setTask];
    });
    dispatch_resume(timer);
    _timer = timer;
}

- (void)setTask {
    if (self.taskIng == NO) {
        return;
    }
    if (self.timeBlock) {
        self.timeBlock();
    }
}

- (void)startTime {
    self.taskIng = YES;
    self.userInteractionEnabled = NO;
}
- (void)stopTime {
    self.taskIng = NO;
    self.userInteractionEnabled = YES;
}
@end
