//
//  SMESPhoneView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/7.
//

#import "SMESPhoneView.h"
#import "SMRVerificationCodeView.h"
#import "SMDownView.h"
#import "SMESEditView.h"

@interface SMESPhoneView()
@property(nonatomic, strong)SMRVerificationCodeView *vcView;

@property(nonatomic, strong)SMESEditView *eView;
@property(nonatomic, strong)NSString *phone;
@end

@implementation SMESPhoneView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    self.backgroundColor = rgba(0, 0, 0, 0.3);

    CGSize sSize = [UIScreen mainScreen].bounds.size;
    
    self.eView = [[SMESEditView alloc] init];
    self.eView.frame = CGRectMake(0,0,sSize.width,sSize.height);
    [self addSubview:self.eView];

    self.vcView = [[SMRVerificationCodeView alloc] init];
    self.vcView.hidden = YES;
    self.vcView.frame = CGRectMake(0,0,sSize.width,sSize.height);
    [self addSubview:self.vcView];
    

    
    SMDownView *downView = [[SMDownView alloc] init];
    downView.frame = CGRectMake(0, 0,sSize.width, 104.5);
    [self addSubview:downView];
    
    @weakify(self);
    self.vcView.endInputCodeBlock = ^(NSString * _Nonnull code) {
        @strongify(self);
        self.saveBlock(self.phone);
        [self wb_disMiss];

    };
    self.eView.Nextblock = ^(NSString * _Nonnull phone) {
        @strongify(self);
        self.phone = phone;
        self.vcView.hidden = NO;
        [self.vcView checkCodeWithPhone:phone];
    };

}
- (void)checkCodeWithPhone:(NSString *)phone {

}

@end
