//
//  SMEditShopInfoViewController.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/7.
//

#import "SMEditShopInfoViewController.h"
#import "SMESPhoneView.h"
#import "MTRAreaPickView.h"
#import "SMShopInfoModel.h"


@interface SMEditShopInfoViewController ()

@property(nonatomic, strong)NSMutableArray *labelArray;

@property(nonatomic, strong)UIButton *areaBtn;
@property(nonatomic, strong)UITextField *addressTF;
@property(nonatomic, strong)UITextField *shopNameTF;
@property(nonatomic, strong)UITextField *shopUserTF;
@property(nonatomic, strong)UIButton *editPhoneBtn;
@property(nonatomic, strong)UILabel *phoneLabel;
@property(nonatomic, strong)UIButton *saveBtn;
@property(nonatomic, strong)MTRAreaPickView *addressPickView;
//@property(nonatomic, assign)NSInteger province;
//@property(nonatomic, assign)NSInteger city;
//@property(nonatomic, assign)NSInteger district;

@property(nonatomic, strong)SMShopInfoModel *shopInfoModel;
@end

@implementation SMEditShopInfoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.addressPickView = [[MTRAreaPickView alloc] init];

    self.view.backgroundColor =[UIColor whiteColor];
    self.wb_titleLabel.text = @"编辑门店信息";
    NSArray *tipsArray =  [@"所属地区,门店地址,门店名称,门店联系人,绑定手机号" componentsSeparatedByString:@","];
    self.labelArray = [[NSMutableArray alloc] init];
    [self createViewWithNameArray:tipsArray firstTop:safaTop(93)];

    
    for (int i = 0; i < self.labelArray.count; i++) {
        UILabel *label = self.labelArray[i];
        if (i == 0) {
            UIButton *areaBtn = [[UIButton alloc] init];
            _areaBtn = areaBtn;
            [areaBtn setAttributedTitle:createAttString(@"未填写", 14, rgba(185, 185, 185, 1)) forState:UIControlStateNormal];
            [areaBtn addTarget:self.addressPickView action:@selector(show) forControlEvents:UIControlEventTouchUpInside];
            [areaBtn wb_setImageName:@"customer_icon_xyb"];
            areaBtn.imageEdgeInsets = UIEdgeInsetsMake(0, -4.5, 0, 4.5);
            [areaBtn wb_setRightImage];
            [self.view addSubview:areaBtn];
            [areaBtn mas_makeConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(label);
                make.right.mas_equalTo(-22);
            }];
        }else if (i == 1) {
//            UIButton *addressBtn = [[UIButton alloc] init];
//            [addressBtn setAttributedTitle:createAttString(@"未填写", 14, rgba(185, 185, 185, 1)) forState:UIControlStateNormal];
//            [addressBtn wb_setImageName:@"customer_icon_xyb"];
//            addressBtn.imageEdgeInsets = UIEdgeInsetsMake(0, -4.5, 0, 4.5);
//            [addressBtn wb_setRightImage];
//            [self.view addSubview:addressBtn];
//            [addressBtn mas_makeConstraints:^(MASConstraintMaker *make) {
//                make.centerY.equalTo(label);
//                make.right.mas_equalTo(-22);
//            }];
            UITextField *addressTF = [[UITextField alloc] init];
            addressTF.textColor = rgba(76, 74, 66, 1);
            addressTF.font = [UIFont systemFontOfSize:14];
            addressTF.textAlignment = NSTextAlignmentRight;
            _addressTF = addressTF;
            addressTF.attributedPlaceholder = createAttString(@"未填写", 14, rgba(185, 185, 185, 1));
            [self.view addSubview:addressTF];
            [addressTF mas_makeConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(label);
                make.left.mas_equalTo(100);
                make.right.mas_equalTo(-22);
            }];
        }else if (i == 2) {

            UITextField *shopNameTF = [[UITextField alloc] init];
            shopNameTF.textColor = rgba(76, 74, 66, 1);
            shopNameTF.font = [UIFont systemFontOfSize:14];
            shopNameTF.textAlignment = NSTextAlignmentRight;
            _shopNameTF = shopNameTF;
            shopNameTF.attributedPlaceholder = createAttString(@"未填写", 14, rgba(185, 185, 185, 1));
            [self.view addSubview:shopNameTF];
            [shopNameTF mas_makeConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(label);
                make.left.mas_equalTo(100);
                make.right.mas_equalTo(-22);
            }];
        }else if (i == 3) {
            
            UITextField *shopUserTF = [[UITextField alloc] init];
            shopUserTF.textColor = rgba(76, 74, 66, 1);
            shopUserTF.font = [UIFont systemFontOfSize:14];
            shopUserTF.textAlignment = NSTextAlignmentRight;
            _shopUserTF = shopUserTF;
            shopUserTF.attributedPlaceholder = createAttString(@"未填写", 14, rgba(185, 185, 185, 1));
            [self.view addSubview:shopUserTF];
            [shopUserTF mas_makeConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(label);
                make.right.mas_equalTo(100);
                make.right.mas_equalTo(-22);
            }];
        }else if (i == 4) {
            
//            UIImage *norImage = [[UIImage wb_imageWithColor:[UIColor whiteColor] size:CGSizeMake(48, 26)] sd_roundedCornerImageWithRadius:13 corners:0xff borderWidth:0.5 borderColor:rgba(255, 124, 78, 1)];
////            UIImage *selImage = [[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(75.5, 26)] sd_roundedCornerImageWithRadius:13 corners:0xff borderWidth:0.5 borderColor:rgba(255, 124, 78, 1)];
//
//            UIButton *editPhoneBtn = [[UIButton alloc] init];
//            _editPhoneBtn = editPhoneBtn;
//            [editPhoneBtn setAttributedTitle:createAttString(@"修改", 14, rgba(255, 124, 78, 1)) forState:UIControlStateNormal];
//            [editPhoneBtn setAttributedTitle:createAttString(@"修改", 14, [UIColor whiteColor]) forState:UIControlStateSelected];
//            [editPhoneBtn addTarget:self action:@selector(editPhoneBtnClick:) forControlEvents:UIControlEventTouchUpInside];
//            [editPhoneBtn setBackgroundImage:norImage forState:UIControlStateNormal];
////            [boyBtn setBackgroundImage:selImage forState:UIControlStateSelected];
//            [self.view addSubview:editPhoneBtn];
//            [editPhoneBtn mas_makeConstraints:^(MASConstraintMaker *make) {
//                make.centerY.equalTo(label);
//                make.right.mas_equalTo(-22);
//            }];
            
            UILabel *phoneLabel = [[UILabel alloc] init];
            _phoneLabel = phoneLabel;
//            phoneLabel.attributedText = createAttString(@"131555555", 13, rgba(76, 74, 66, 1));
            [self.view addSubview:phoneLabel];
            [phoneLabel mas_makeConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(label);
//                make.right.equalTo(editPhoneBtn.mas_left).offset(-10);
                make.right.mas_equalTo(-22);
            }];
            
            
        }
    }
    
    UIButton *saveBtn = [[UIButton alloc] init];
    _saveBtn = saveBtn;

    [saveBtn setAttributedTitle:createAttString(@"保存", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];

    [saveBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [saveBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [saveBtn addTarget:self action:@selector(saveBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:saveBtn];

    [saveBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(safaBottom(-50));
        make.centerX.mas_equalTo(0);
    }];
    [self requestData];
    @weakify(self);
    self.addressPickView.selectCityBlock = ^(NSInteger province, NSInteger city, NSInteger district, NSString * _Nonnull resultStr) {
        @strongify(self);
        self.shopInfoModel.arearegion = [NSString stringWithFormat:@"%ld",district];
        self.shopInfoModel.areaprovince = [NSString stringWithFormat:@"%ld",province];
        self.shopInfoModel.areacity = [NSString stringWithFormat:@"%ld",district];
        self.shopInfoModel.areatxt = resultStr;
        [self.areaBtn setAttributedTitle:createAttString(resultStr, 14, rgba(76, 74, 66, 1)) forState:UIControlStateNormal];
    };
}
- (void)requestData {
    
    NSMutableDictionary *pdict = [[NSMutableDictionary alloc] init];
    pdict[@"mid"] = [SMGlobalModel share].mid;
    @weakify(self);
    [self.view postFormDataWithUrl:@"/magnifier/member/findMemberInfoById" params:pdict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        NSLog(@"%@",JsonData);
        @strongify(self);
        if ([JsonData.code isEqualToString:@"200"] && [JsonData.data isKindOfClass:[NSDictionary class]]) {
            NSDictionary *dataDict = (NSDictionary *)JsonData.data;
            
            self.shopInfoModel  = [SMShopInfoModel mj_objectWithKeyValues:dataDict];
            
            if (![dataDict[@"areatxt"] isKindOfClass:[NSNull class]]) {
                [self.areaBtn setAttributedTitle:createAttString(dataDict[@"areatxt"], 14, rgba(76, 74, 66, 1)) forState:UIControlStateNormal];
            }
            if (![dataDict[@"address"] isKindOfClass:[NSNull class]]) {
                self.addressTF.attributedText = createAttString(dataDict[@"address"], 14, rgba(76, 74, 66, 1));
            }
            if (![dataDict[@"dmname"] isKindOfClass:[NSNull class]]) {
                self.shopNameTF.attributedText = createAttString(dataDict[@"dmname"], 14, rgba(76, 74, 66, 1));
            }
            if (![dataDict[@"lxname"] isKindOfClass:[NSNull class]]) {
                self.shopUserTF.attributedText =  createAttString(dataDict[@"lxname"], 14, rgba(76, 74, 66, 1));
            }
            if (![dataDict[@"phone"] isKindOfClass:[NSNull class]]) {
                NSString *phone = dataDict[@"phone"];
                phone = privacyString(phone, 3, 4, @"*");
                self.phoneLabel.attributedText =  createAttString(phone, 14, rgba(76, 74, 66, 1));
            }
        }
    }];
}

- (void)createViewWithNameArray:(NSArray *)nameArray firstTop:(CGFloat)firstTop{
  
    UIView *lastView = nil;
    for (int i = 0; i < nameArray.count; i++) {
        UILabel *nameLabel = [[UILabel alloc] init];
        nameLabel.attributedText = createAttString(nameArray[i], 15, rgba(76, 74, 66, 1));
        [self.view addSubview:nameLabel];
        [nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            if (i == 0) {
                make.top.mas_equalTo(firstTop);
            }else {
                make.top.equalTo(lastView.mas_bottom).offset(18);
            };
            make.left.mas_equalTo(20);
        }];
        [self.labelArray addObject:nameLabel];
        
        UIView *lineView = [[UIView alloc] init];
        lineView.backgroundColor = rgba(229, 229, 229, 1);
        [self.view addSubview:lineView];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(20.5);
            make.right.mas_equalTo(-22);
            make.top.equalTo(nameLabel.mas_bottom).offset(17.5);
            make.height.mas_equalTo(0.5);
        }];
        lastView =lineView;
    }
}

- (void)saveBtnClick:(UIButton *)btn {
    self.shopInfoModel.address = self.addressTF.text;
    self.shopInfoModel.dmname = self.shopNameTF.text;
    self.shopInfoModel.lxname = self.shopUserTF.text;
    
    if (!self.shopInfoModel.areatxt.length) {
        [SVProgressHUD showErrorWithStatus:@"地区不能为空"];
        return;
    }
    if (self.shopInfoModel.address.length > 40) {
        [SVProgressHUD showErrorWithStatus:@"地址不能超过40个字"];
        return;
    }
    if ([self.shopInfoModel.address containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"地址不能输入表情"];
        return;
    }
    if (!self.shopInfoModel.address.length) {
        [SVProgressHUD showErrorWithStatus:@"地址不能为空"];
        return;
    }
    
    if (self.shopInfoModel.dmname.length > 50) {
        [SVProgressHUD showErrorWithStatus:@"门店名称不能超过50个字"];
        return;
    }
    if ([self.shopInfoModel.dmname containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"门店名称不能输入表情"];
        return;
    }
    if (!self.shopInfoModel.dmname.length) {
        [SVProgressHUD showErrorWithStatus:@"门店名称不能为空"];
        return;
    }
    
    if (self.shopInfoModel.lxname.length > 20) {
        [SVProgressHUD showErrorWithStatus:@"门店联系人不能超过20个字"];
        return;
    }
    if ([self.shopInfoModel.lxname containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"门店联系人不能输入表情"];
        return;
    }
    if (!self.shopInfoModel.lxname.length) {
        [SVProgressHUD showErrorWithStatus:@"门店联系人不能为空"];
        return;
    }

    
    
    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
    pDict[@"id"] = [SMGlobalModel share].mid;  //门店id
    pDict[@"areacity"] = self.shopInfoModel.areacity;  //市的id
    pDict[@"areaprovince"] = self.shopInfoModel.areaprovince; //省的id
    pDict[@"arearegion"] = self.shopInfoModel.arearegion; //区的id
    pDict[@"areatxt"] = self.shopInfoModel.areatxt;  //省市区连起来的文字
    pDict[@"address"] = self.shopInfoModel.address;  //详细地址（门店地址）
    pDict[@"dmname"] =  self.shopInfoModel.dmname;  //店面名称
    pDict[@"lxname"] = self.shopInfoModel.lxname;  //联系人
    pDict[@"phone"] =  self.shopInfoModel.phone;  //手机号
    @weakify(self);
    [self.view postFormDataWithUrl:@"/magnifier/member/updateMember" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        @strongify(self);
        if ([JsonData.code isEqualToString:@"200"]) {
            if (self.saveBlock) {
                self.saveBlock( self.shopInfoModel.dmname);
            }
            [self.navigationController popViewControllerAnimated:YES];
        }
    }];
}
- (void)editPhoneBtnClick:(UIButton *)btn {
    SMESPhoneView *rView = [[SMESPhoneView alloc] init];
    @weakify(self);
    rView.saveBlock = ^(NSString * _Nonnull phone) {
        @strongify(self);
        self.shopInfoModel.phone = phone;
        self.phoneLabel.attributedText = createAttString( privacyString(phone, 3, 4, @"*"),13, rgba(76, 74, 66, 1)) ;
    };
    [rView checkCodeWithPhone:self.phoneLabel.text];
    [rView wb_showFromSuperView:self.view];
    
}
@end
