//
//  SMRVerificationCodeView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMRVerificationCodeView.h"
#import "SMCountDownButton.h"
#import "SMYZMView.h"


@interface SMRVerificationCodeView()

@property(nonatomic,strong)NSMutableArray *inputArray;
@property(nonatomic,strong)NSString *phoneString;
@property(nonatomic,weak)SMCountDownButton *cdBtn;
@property(nonatomic,strong)NSString *codeString;
@property(nonatomic,weak)UILabel *phoneLabel;
@end


@implementation SMRVerificationCodeView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self  setupUI];
    }
    return self;
}

- (void)setupUI {
    self.inputArray = [[NSMutableArray alloc] init];
    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(255, 255, 255, 1);
    contView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    contView.layer.shadowOffset = CGSizeMake(0,4);
    contView.layer.shadowOpacity = 1;
    contView.layer.shadowRadius = 30;
    [self addSubview:contView];
    [contView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(64.5) );
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [contView addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(17);
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];

    UILabel *bigTipsLabel = [[UILabel alloc] init];
    bigTipsLabel.attributedText = createAttString(@"请您输入手机号验证码", 25,rgba(76, 74, 66, 1));
    [contView addSubview:bigTipsLabel];
    [bigTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.mas_equalTo(53);
    }];
    
    UILabel *smallTipsLabel = [[UILabel alloc] init];

    smallTipsLabel.attributedText = createAttString(@"验证码已经发送到您的手机", 14,rgba(153, 153, 153, 1));
    [contView addSubview:smallTipsLabel];
    [smallTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.equalTo(bigTipsLabel.mas_bottom).offset(18);
    }];
    
    UILabel *phoneLabel = [[UILabel alloc] init];
    _phoneLabel = phoneLabel;
//    phoneLabel.attributedText = createAttString(@"+86   13145806096", 14,rgba(153, 153, 153, 1));
    [contView addSubview:phoneLabel];
    [phoneLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.equalTo(smallTipsLabel.mas_bottom).offset(10);
    }];
    
    UIImage *norImage = [[UIImage wb_imageWithColor:rgba(241, 241, 241, 1) size:CGSizeMake(57, 57)] sd_roundedCornerImageWithRadius:5 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]];
    
//    UIView *inputBGView = [[UIView alloc] init];
//    [contView addSubview:inputBGView];
//    [inputBGView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.centerX.mas_equalTo(0);
//        make.top.mas_equalTo(171);
//        make.height.mas_equalTo(57);
//    }];
    
  
    SMYZMView *mView = [[SMYZMView alloc ] init];
    @weakify(self);
    mView.editBlock = ^(NSString * _Nonnull str) {
        @strongify(self);
        if ([str isEqualToString:self.codeString]) {

            if (self.endInputCodeBlock) {
                self.endInputCodeBlock(self.codeString);
            }
        }else {
            [SVProgressHUD showErrorWithStatus:@"请输入正确的验证码"];
        }
    };
    [contView addSubview:mView];
    [mView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(200);
        make.centerX.mas_equalTo(0);
        make.width.mas_equalTo((57+19)*4);
        make.height.mas_equalTo(57);
    }];

    
    
    SMCountDownButton *cdbtn = [[SMCountDownButton alloc] init];
    [cdbtn setAttributedTitle:createAttString(@"获取验证码", 12, rgba(153, 153, 153, 1)) forState:UIControlStateNormal];
    [cdbtn addTarget:self action:@selector(cdBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    _cdBtn = cdbtn;
//    @weakify(self);
    __block int maxCount = 60;
    cdbtn.timeBlock = ^{
        @strongify(self);
        maxCount--;
        
        NSAttributedString *btnAtt = nil;
        if (maxCount == 0) {
            btnAtt = createAttString(@"获取验证码", 12, rgba(153, 153, 153, 1));
            [self.cdBtn stopTime];
            maxCount = 60;
        }else {
            btnAtt=  [[NSAttributedString alloc] wb_initWithString:[NSString stringWithFormat:@"%ds",maxCount] FontSize:12 TextColor:rgba(153, 153, 153, 1)];
        }
        [self.cdBtn setAttributedTitle:btnAtt forState:UIControlStateNormal];
    };
    [self addSubview:cdbtn];
    [cdbtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(mView).offset(-15);
        make.bottom.equalTo(mView.mas_top).offset(-15);
    }];
}

- (void)cdBtnClick:(UIButton *)btn {
    [self checkCode];
}

- (void)checkCodeWithPhone:(NSString *)phone {
    self.phoneString = phone;
   _phoneLabel.attributedText = createAttString([NSString stringWithFormat:@"+86   %@",phone], 14,rgba(153, 153, 153, 1));

    [self checkCode];
}

- (void)checkCode {
    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
    pDict[@"phone"] =  self.phoneString;
    @weakify(self);
    [self postFormDataWithUrl:@"/magnifier/public/sendVerifiyCode" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        @strongify(self);
        if ([JsonData.code isEqualToString:@"200"]) {
            self.codeString = [NSString stringWithFormat:@"%@",JsonData.data];
            [self.cdBtn startTime];
        }

    }];
}
@end
