//
//  AppDelegate.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "AppDelegate.h"
#import "SMNavigationController.h"
#import "SMHomeViewController.h"
#import <IQKeyboardManager.h>
#import "MMAutoUploadTool.h"
#import "MMLocalDataBManager.h"
#import <CoreLocation/CoreLocation.h>
#import <Bugly/Bugly.h>
#import <CoreLocation/CoreLocation.h>
@interface AppDelegate ()<CLLocationManagerDelegate>{
    
    CLLocationManager*locationmanager;//定位服务
       
       NSString*strlatitude;//经度
       
       NSString*strlongitude;//纬度
}

@property(nonatomic,strong)CLLocationManager *locationManager;
@property(nonatomic,strong)dispatch_source_t uploadLocalRpoertTimer;
@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.window = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
    self.window.rootViewController = [[SMNavigationController alloc] initWithRootViewController:[SMHomeViewController new]];
    [self.window makeKeyAndVisible];
    

    [self setKeyboard];
    [self getToken];
    
    [self startLocation];
    
    [self setupAutoUploadImage];
    [self setupWifi];
  
    [self setupBugly];
    return YES;
}
- (void)setupBugly {
    [Bugly startWithAppId:@"e2e071b8fe"];
}
- (void)setKeyboard {
    IQKeyboardManager *manager = [IQKeyboardManager sharedManager];
    manager.enable = YES;
    manager.shouldResignOnTouchOutside = YES;
    manager.shouldToolbarUsesTextFieldTintColor = YES;
    manager.enableAutoToolbar = YES;
    manager.toolbarDoneBarButtonItemText = @"完成";
    [SVProgressHUD setDefaultMaskType:SVProgressHUDMaskTypeClear];
    [SVProgressHUD setMinimumDismissTimeInterval:1.0];
}
- (void) setupWifi {
//    NSString* phoneVersion = [[UIDevice currentDevice] systemVersion];
//    CGFloat version = [phoneVersion floatValue];
//    //     如果是iOS13 未开启地理位置权限 需要提示一下
//    if ([CLLocationManager authorizationStatus] == kCLAuthorizationStatusNotDetermined && version >= 13) {
//        self.locationManager = [[CLLocationManager alloc] init];
//        [ self.locationManager requestWhenInUseAuthorization];
//    }
}


- (void)setupAutoUploadData {
    [SMLocalReportBManager sharedManager];
    @weakify(self);
    dispatch_queue_t queue = dispatch_queue_create("com.idankee.DKAutoUpdate5Data", DISPATCH_QUEUE_SERIAL);
    dispatch_source_t timer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0, queue);
    dispatch_source_set_timer(timer, DISPATCH_TIME_NOW, 5 * NSEC_PER_SEC, 0 * NSEC_PER_SEC);
    dispatch_source_set_event_handler(timer, ^{
        @strongify(self);
        [self startTask1];
    });
    dispatch_resume(timer);
    _uploadLocalRpoertTimer = timer;
}


- (void)startTask1{

    
    if ([SMGlobalModel share].mid.length == 0) {
        return;
    }
    if (islinkDeviceWifi()) {
        NSString *macString  = WIFIMacAddress();
        NSArray *macSArray = [macString componentsSeparatedByString:@":"];
        NSMutableString *mac = [[NSMutableString alloc] init];
        for (NSString * str in macSArray) {
            if (str.length == 1) {
                [mac appendFormat:@"0%@",[str uppercaseString]];
            }else {
                [mac appendFormat:@"%@",[str uppercaseString]];
            }
        }
        [SMGlobalModel share].deviceMac = mac;

        [NSThread sleepForTimeInterval:20.0];
        return;
    }


    // 设备绑定到机构
    if ([SMGlobalModel share].shopInfoComplete && [SMGlobalModel share].deviceMac.length) {
        NSString *macS = [[NSUserDefaults standardUserDefaults] objectForKey:@"saveDeviceMacKey"];
        if (![macS containsString:[SMGlobalModel share].deviceMac]) {
            NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
            pDict[@"mid"] = [SMGlobalModel share].mid;
            pDict[@"hardcode"] = [SMGlobalModel share].deviceMac;
            [self.window postFormDataWithUrl:@"/magnifier/member/verifyMemberDevice" params:pDict showHUD:NO success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                if ([JsonData.code isEqualToString:@"200"]) {
                    NSString *string = [NSString stringWithFormat:@"%@%@",macS,[SMGlobalModel share].deviceMac];
                    [[NSUserDefaults standardUserDefaults] setObject:string forKey:@"saveDeviceMacKey"];
                }
            }];
        }
    }

    
    NSArray *modelArray =  [[SMLocalReportBManager sharedManager] selectFristWithMid:[SMGlobalModel share].mid];
    if ( modelArray.count == 0) {
        [NSThread sleepForTimeInterval:20.0];
        return;
    }

    
    SMLocalReportModel *model = modelArray.firstObject;
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self performSelector:@selector(resetData:) withObject:model afterDelay:2.5];
    });

    if ([model.uploadLock isEqualToString:@"1"]) {
        [NSThread sleepForTimeInterval:20.0];
        return;
    }


    [[SMLocalReportBManager sharedManager] updateWithSetKey:@"uploadLock" setValue:@"1" whereKey:@"cgid" whereValue:model.cgid];
    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
    pDict[@"iposition"] = model.iposition;
    
    
    MMAutoUploadTool *uploadTool = [MMAutoUploadTool sharedManager];
    pDict[@"lonlat"] = uploadTool.lonlat;
    if (model.createTime.length > 11) {
        pDict[@"createtime"] = model.createTime;
    }else {
        pDict[@"createtime"] = [NSString stringWithFormat:@"%@000",model.createTime];
    }
    
    pDict[@"clientid"] = model.cid;
    NSMutableArray *images = [[NSMutableArray alloc] init];
    for (int i = 0;  i < model.imageArray.count; i++) {
        SMLocalReportImageModel *imgModel = model.imageArray[i];
        NSMutableDictionary *imgDict = [[NSMutableDictionary alloc] init];
        imgDict[@"lighttype"] =  imgModel.iType;
        imgDict[@"imgUrl"] =  imgModel.iURL;
        [images addObject:imgDict];
    }
    pDict[@"images"] =images;
    
    
    NSMutableArray *analysisReportAitagnameLinkGoods = [[NSMutableArray alloc] init];
    for (int i = 0;  i < model.productArray.count; i++) {
        SMLocalReportProductModel *proModel = model.productArray[i];
        NSMutableDictionary *proDict = [[NSMutableDictionary alloc] init];
        proDict[@"goodsname"] =  proModel.pName;
        proDict[@"goodstype"] =  proModel.pType;
        [analysisReportAitagnameLinkGoods addObject:proDict];
    }
    pDict[@"analysisReportAitagnameLinkGoods"] =analysisReportAitagnameLinkGoods;

    NSMutableArray *magnifierReports = [[NSMutableArray alloc] init];
    

    if (model.AISymptomArray.count < 5 ) {
        NSMutableDictionary *symDict = [[NSMutableDictionary alloc] init];
        symDict[@"tagFlag"] = @"magn_water";
        if (model.moisture.ofen.intValue == 0) {
            symDict[@"tagValue"] = @"0";
        }else {
            symDict[@"tagValue"] = model.moisture.ofen;
        }
        symDict[@"aiImageUrl"] = @"";
        symDict[@"tagname"] = @"水份";
        symDict[@"tagNum"] = @"0";
        symDict[@"dermalogicatext"] =model.moisture.oMethod;
        [magnifierReports addObject:symDict];
    }else {
        for (int i = 0;  i < model.AISymptomArray.count; i++) {
            SMLocalReportAIModel *symModel = model.AISymptomArray[i];
            NSMutableDictionary *symDict = [[NSMutableDictionary alloc] init];
            symDict[@"tagFlag"] = symModel.tagFlag;
            symDict[@"tagValue"] = symModel.tagValue;
            symDict[@"aiImageUrl"] = symModel.aiImageUrl;
            symDict[@"tagname"] = symModel.tagname;
            symDict[@"tagNum"] = symModel.tagNum;
            symDict[@"dermalogicatext"] = symModel.dermalogicatext;
            [magnifierReports addObject:symDict];
        }
    }


    pDict[@"magnifierReports"] = magnifierReports;
    
        NSMutableArray *magnifierCustomReports = [[NSMutableArray alloc] init];
        for (int i = 0;  i < model.symptomArray.count; i++) {
            SMLocalReportSymptomModel *symModel = model.symptomArray[i];
            NSMutableDictionary *symDict = [[NSMutableDictionary alloc] init];
            symDict[@"tagname"] = symModel.sName;
            symDict[@"dermalogicatext"] = symModel.sMethod;
            [magnifierCustomReports addObject:symDict];
        }
    
    pDict[@"magnifierCustomReports"] = magnifierCustomReports;

    dispatch_semaphore_t sema = dispatch_semaphore_create(0);
    [self.window postJsonWithUrl:@"/magnifierCaseGroup/saveMagnifierInfo" params:pDict showHUD:NO success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(resetData:) object:model];
        if ([JsonData.code isEqualToString:@"200"]) {
            [[SMLocalReportBManager sharedManager] deleteWitCgid:model.cgid];
        }else {
            [[SMLocalReportBManager sharedManager] updateWithSetKey:@"uploadLock" setValue:@"0" whereKey:@"cgid" whereValue:model.cgid];
        }
        dispatch_semaphore_signal(sema);
    }];
    dispatch_semaphore_wait(sema, DISPATCH_TIME_FOREVER);
    
}

//- (void)startTask {
//
//
//    if ([SMGlobalModel share].mid.length == 0) {
//        return;
//    }
//    if (islinkDeviceWifi()) {
//        NSString *macString  = WIFIMacAddress();
//        NSArray *macSArray = [macString componentsSeparatedByString:@":"];
//        NSMutableString *mac = [[NSMutableString alloc] init];
//        for (NSString * str in macSArray) {
//            if (str.length == 1) {
//                [mac appendFormat:@"0%@",[str uppercaseString]];
//            }else {
//                [mac appendFormat:@"%@",[str uppercaseString]];
//            }
//        }
//        [SMGlobalModel share].deviceMac = mac;
//
//        [NSThread sleepForTimeInterval:20.0];
//        return;
//    }
//
//
//    /// 设备绑定到机构
//    if ([SMGlobalModel share].shopInfoComplete && [SMGlobalModel share].deviceMac.length) {
//        NSString *macS = [[NSUserDefaults standardUserDefaults] objectForKey:@"saveDeviceMacKey"];
//        if (![macS containsString:[SMGlobalModel share].deviceMac]) {
//            NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
//            pDict[@"mid"] = [SMGlobalModel share].mid;
//            pDict[@"hardcode"] = [SMGlobalModel share].deviceMac;
//            [self.window postFormDataWithUrl:@"/magnifier/member/verifyMemberDevice" params:pDict showHUD:NO success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
//                if ([JsonData.code isEqualToString:@"200"]) {
//                    NSString *string = [NSString stringWithFormat:@"%@%@",macS,[SMGlobalModel share].deviceMac];
//                    [[NSUserDefaults standardUserDefaults] setObject:string forKey:@"saveDeviceMacKey"];
//                }
//            }];
//        }
//    }
//
//
//    NSArray *modelArray =  [[SMLocalReportBManager sharedManager] selectFristWithMid:[SMGlobalModel share].mid];
//    if ( modelArray.count == 0) {
//        [NSThread sleepForTimeInterval:20.0];
//        return;
//    }
//
//
//    SMLocalReportModel *model = modelArray.firstObject;
//    [self performSelector:@selector(resetData:) withObject:model afterDelay:3];
//    if ([model.uploadLock isEqualToString:@"1"]) {
//        [NSThread sleepForTimeInterval:20.0];
//        return;
//    }
//
//
//    [[SMLocalReportBManager sharedManager] updateWithSetKey:@"uploadLock" setValue:@"1" whereKey:@"cgid" whereValue:model.cgid];
//    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
//    pDict[@"iposition"] = model.iposition;
//    if (model.createTime.length > 11) {
//        pDict[@"createtime"] = model.createTime;
//    }else {
//        pDict[@"createtime"] = [NSString stringWithFormat:@"%@000",model.createTime];
//    }
//
//    pDict[@"clientid"] = model.cid;
//    pDict[@"moisture"] = model.moisture.ofen;
//    NSMutableArray *images = [[NSMutableArray alloc] init];
//    for (int i = 0;  i < model.imageArray.count; i++) {
//        SMLocalReportImageModel *imgModel = model.imageArray[i];
//        NSMutableDictionary *imgDict = [[NSMutableDictionary alloc] init];
//        imgDict[@"lighttype"] =  imgModel.iType;
//        imgDict[@"imgUrl"] =  imgModel.iURL;
//        [images addObject:imgDict];
//    }
//    pDict[@"images"] =images;
//
//
//    NSMutableArray *analysisReportAitagnameLinkGoods = [[NSMutableArray alloc] init];
//    for (int i = 0;  i < model.productArray.count; i++) {
//        SMLocalReportProductModel *proModel = model.productArray[i];
//        NSMutableDictionary *proDict = [[NSMutableDictionary alloc] init];
//        proDict[@"goodsname"] =  proModel.pName;
//        proDict[@"goodstype"] =  proModel.pType;
//        [analysisReportAitagnameLinkGoods addObject:proDict];
//    }
//    pDict[@"analysisReportAitagnameLinkGoods"] =analysisReportAitagnameLinkGoods;
//
//    NSMutableArray *analysisReportLinkAitagnameVOs = [[NSMutableArray alloc] init];
//    /// 水份
//    NSMutableDictionary *oilDict = [[NSMutableDictionary alloc] init];
//    oilDict[@"tagname"] =  model.moisture.oName;
//    if (model.moisture.ofen.intValue == 0) {
//        oilDict[@"areasonList"] =   @[@{@"reasontext":@""}];
//        oilDict[@"adermalogicaList"] =  @[@{@"dermalogicatext":@""}];
//    }else {
//        oilDict[@"areasonList"] =  @[@{@"reasontext":model.moisture.oDescribe}];
//        oilDict[@"adermalogicaList"] =  @[@{@"dermalogicatext":model.moisture.oMethod}];
//    }
//
//    oilDict[@"systSign"] = @"1";
//    [analysisReportLinkAitagnameVOs addObject:oilDict];
//    for (int i = 0;  i < model.symptomArray.count; i++) {
//        SMLocalReportSymptomModel *symModel = model.symptomArray[i];
//        NSMutableDictionary *symDict = [[NSMutableDictionary alloc] init];
//        symDict[@"tagname"] =  symModel.sName;
//        symDict[@"areasonList"] =  @[@{@"reasontext":symModel.sDescribe}];
//        symDict[@"adermalogicaList"] =  @[@{@"dermalogicatext":symModel.sMethod}];
//        symDict[@"systSign"] = @"0";
//        [analysisReportLinkAitagnameVOs addObject:symDict];
//    }
//
//    pDict[@"analysisReportLinkAitagnameVOs"] = analysisReportLinkAitagnameVOs;
//
//    dispatch_semaphore_t sema = dispatch_semaphore_create(0);
//    [self.window postJsonWithUrl:@"/magnifierCaseGroup/saveData" params:pDict showHUD:NO success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
//        [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(resetData:) object:model];
//        if ([JsonData.code isEqualToString:@"200"]) {
//            [[SMLocalReportBManager sharedManager] deleteWitCgid:model.cgid];
//        }else {
//            [[SMLocalReportBManager sharedManager] updateWithSetKey:@"uploadLock" setValue:@"0" whereKey:@"cgid" whereValue:model.cgid];
//        }
//        dispatch_semaphore_signal(sema);
//    }];
//    dispatch_semaphore_wait(sema, DISPATCH_TIME_FOREVER);
//
//
//
//}
- (void)resetData:(SMLocalReportModel *)model {
    [[SMLocalReportBManager sharedManager] updateWithSetKey:@"uploadLock" setValue:@"0" whereKey:@"cgid" whereValue:model.cgid];
}
- (void)setupAutoUploadImage {
    
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        
        MMAutoUploadTool *uploadTool = [MMAutoUploadTool sharedManager];
        uploadTool.endPoint = @"https://oss-cn-shenzhen.aliyuncs.com";
//        uploadTool.BucketName = @"djm-skin";
//        uploadTool.SecretKey = @"YErRX4C9igPUENphQLD107XgrAIYeI";
//        uploadTool.AccessKey = @"LTAIFNybYwi2WuWK";
        uploadTool.BucketName = @"imoreme";
        uploadTool.SecretKey = @"rTC1hmCKmmCoLzdxc7pw8FAzbjWG7H";
        uploadTool.AccessKey = @"LTAI4G35R8m8wsP5hQNrjm8i";
        [uploadTool setupDKEnvironmen];
        uploadTool.timeblock = ^(void (^ cBlock)(NSString *i, NSData* bufData,void (^ c2block)(NSString *i2))) {
            if (islinkDeviceWifi()) {
                return;
            }
            
            NSArray *array = [[MMLocalDataBManager sharedManager] seleteWithGreaterThanOrEqualTo:0 limit:1];
            if (!array.count) {
                return  ;
            }
            NSDictionary *dict = array.firstObject;
            cBlock( dict[@"objectKey"], dict[@"updateData"],^(NSString *i2){
                if (i2) {
                    [[MMLocalDataBManager sharedManager] deleteWithID:[dict[@"ID"]intValue]];
                }
            });
        };
        
    });
    
}

- (void)getToken {


    

//    [UIView setDefaultHost:@"http://192.168.1.164:8083"];//测试

//    [UIView setDefaultHost:@"http://waterapi.test.hoyar.com.cn"];//正式
    
    [UIView setDefaultHost:@"http://waterapi.imoreme.com"];//正式


    [UIView setAuthorizationDefaultRequestValue:@"jinhaoyang_metis" key:@"appid"];
    [UIView setAuthorizationDefaultRequestValue:@"0FFC183F4BF9BB4737BA8B5B83D1039023F18C60D0636C34F4EF8C7AEEDCBD31" key:@"appsecret"];
    [UIView setAuthorizationDefaultRequestValue:@"zh" key:@"language"];
    @weakify(self);
    [self.window postFormDataWithUrl:@"/token/createToken" params:nil showHUD:NO success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        @strongify(self);
        if ([JsonData.code isEqualToString:@"200"] && [JsonData.data isKindOfClass:[NSArray class]]) {
            NSArray *dataArray = (NSArray *)JsonData.data;
            [UIView setAuthorizationDefaultRequestValue:dataArray.firstObject  key:@"token"];
        }else {
            [self performSelector:@selector(getToken) withObject:nil afterDelay:5];
        }
        
    }];
    
}


#pragma mark - 定位
//开始定位
-(void) startLocation
{
    //判断定位功能是否打开
    if ([CLLocationManager locationServicesEnabled]) {
        locationmanager = [[CLLocationManager alloc]init];
        locationmanager.delegate = self;
        [locationmanager requestAlwaysAuthorization];
        [locationmanager requestWhenInUseAuthorization];
        
        //设置寻址精度
        
        locationmanager.distanceFilter=kCLDistanceFilterNone;//实时更新定位位置
        locationmanager.pausesLocationUpdatesAutomatically=NO;

       
        locationmanager.desiredAccuracy = kCLLocationAccuracyBest;
        locationmanager.distanceFilter = 5.0;
        [locationmanager startUpdatingLocation];
    }else{
        
      
          [self checkAuth:kMultiLangString(@"定位服务已关闭 您需要打开定位权限，以便提升数据的获取速度。请到设置->隐私->定位服务中开启【MoreMe水肤镜】的定位服务")];
        
    }
}

- (void)checkAuth:(NSString *)tipString {
    UIAlertController *alert;
    if ([tipString isEqualToString:@"定位服务已关闭 您需要打开定位权限，以便提升数据的获取速度。请到设置->隐私->定位服务中开启【MoreMe水肤镜】的定位服务"]) {
      alert = [UIAlertController alertControllerWithTitle:kMultiLangString(@"定位服务已关闭") message:@"您需要打开定位权限，以便提升数据的获取速度。请到设置->隐私->定位服务中开启【MoreMe水肤镜】的定位服务" preferredStyle:UIAlertControllerStyleAlert];
    }else{
        
           alert = [UIAlertController alertControllerWithTitle:kMultiLangString(@"") message:tipString preferredStyle:UIAlertControllerStyleAlert];
    }

  // alert = [UIAlertController alertControllerWithTitle:kMultiLangString(@"定位服务已关闭") message:tipString preferredStyle:UIAlertControllerStyleAlert];
    [alert addAction:[UIAlertAction actionWithTitle:kMultiLangString(@"确定")  style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:UIApplicationOpenSettingsURLString]];
             [alert dismissViewControllerAnimated:YES completion:nil];
    }]];
//    [alert addAction:[UIAlertAction actionWithTitle:kMultiLangString(@"取消")  style:UIAlertActionStyleCancel handler:^(UIAlertAction *action) {
//        [alert dismissViewControllerAnimated:YES completion:nil];
//    }]];
    
 
             [self.window.rootViewController presentViewController:alert animated:YES completion:nil];
  
}


#pragma mark CoreLocation delegate (定位失败)
//定位失败后调用此代理方法
-(void)locationManager:(CLLocationManager *)manager didFailWithError:(NSError *)error
{


        [self checkAuth:kMultiLangString(@"您需要打开定位权限，以便提升数据的获取速度。请到设置->隐私->定位服务中开启【MoreMe水肤镜】的定位服务")];
    return;
}

#pragma mark 定位成功后则执行此代理方法
-(void)locationManager:(CLLocationManager *)manager didUpdateLocations:(NSArray<CLLocation *> *)locations
{
    [locationmanager stopUpdatingHeading];
    //旧址
    CLLocation *currentLocation = [locations lastObject];
    CLGeocoder *geoCoder = [[CLGeocoder alloc]init];
    //打印当前的经度与纬度
    NSLog(@"%f,%f",currentLocation.coordinate.latitude,currentLocation.coordinate.longitude);
    MMAutoUploadTool *uploadTool = [MMAutoUploadTool sharedManager];
    uploadTool.lonlat = [NSString stringWithFormat:@"%f,%f",currentLocation.coordinate.longitude,currentLocation.coordinate.latitude];
    if (uploadTool.lonlat == nil) {
        uploadTool.lonlat = @"113.9212390000,22.5188880000";
    }
    
    [self setupAutoUploadData];
    UIAlertController *alert;
        [alert dismissViewControllerAnimated:YES completion:nil];
    //反地理编码
    [geoCoder reverseGeocodeLocation:currentLocation completionHandler:^(NSArray<CLPlacemark *> * _Nullable placemarks, NSError * _Nullable error)
     {
//         NSLog(@"反地理编码");
//         NSLog(@"反地理编码%ld",placemarks.count);
         if (placemarks.count > 0) {
             CLPlacemark *placeMark = placemarks[0];

             /*看需求定义一个全局变量来接收赋值*/
//             NSLog(@"城市----%@",placeMark.country);//当前国家
//            // NSLog(@"城市%@",self.label_city.text);//当前的城市
//             NSLog(@"%@",placeMark.subLocality);//当前的位置
//             NSLog(@"%@",placeMark.thoroughfare);//当前街道
//             NSLog(@"%@",placeMark.name);//具体地址

         }
     }];
    
      [alert dismissViewControllerAnimated:YES completion:nil];

}
@end
