//
//  SMReportAddProjectView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/1.
//

#import "SMReportAddProjectView.h"
#import "SMDownView.h"

@interface SMReportAddProjectView()

@property(nonatomic, strong)UITextField *pTF;
@property(nonatomic, strong)NSString *type;
@property(nonatomic, weak)UIButton *cpselBtn;
@property(nonatomic, weak)UIButton *yqselBtn;
@property(nonatomic, weak)UIButton *cpImageView;
@property(nonatomic, weak)UIButton *yqImageView;
@property(nonatomic, weak)UIButton *cpBtn;
@property(nonatomic, weak)UIButton *yqBtn;

@property(nonatomic, weak)UIButton *delBtn;
@property(nonatomic, weak)UIButton *qdBtn;
@property(nonatomic, weak)UILabel *tipsLabel;
@end

@implementation SMReportAddProjectView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}



- (void)setupUI {
    self.backgroundColor = rgba(0, 0, 0, 0.34);
    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(255, 255, 255, 1);
    contView.layer.shadowColor = [UIColor colorWithRed:0/255.0 green:0/255.0 blue:0/255.0 alpha:0.17].CGColor;
    contView.layer.shadowOffset = CGSizeMake(0,4);
    contView.layer.shadowOpacity = 1;
    contView.layer.shadowRadius = 30;
    [self addSubview:contView];
    [contView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(64.5) );
        make.left.bottom.right.mas_equalTo(0);
    }];
    
    UIView *hLineView = [[UIView alloc] init];
    hLineView.backgroundColor = rgba(239, 239, 239, 1);
    hLineView.layer.cornerRadius = 1;
    [contView addSubview:hLineView];
    [hLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(17);
        make.size.mas_equalTo(CGSizeMake(39.5, 2));
    }];
    
    CGSize sSize = [UIScreen mainScreen].bounds.size;
    SMDownView *downView = [[SMDownView alloc] init];
    downView.frame = CGRectMake(0, 0,sSize.width, 104.5);
    [self addSubview:downView];
    
    UILabel *tipsLabel = [[UILabel alloc]init];
    tipsLabel.attributedText = createAttString(@"添加项目", 25, rgba(76, 74, 66, 1));
    [contView addSubview:tipsLabel];
    _tipsLabel = tipsLabel;
    [tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(45);
        make.top.mas_equalTo(51.5);
    }];
    
    UIButton *cpImageView = [[UIButton alloc] init];
    _cpImageView = cpImageView;
    [cpImageView addTarget:self action:@selector(cpClick:) forControlEvents:UIControlEventTouchUpInside];
    [cpImageView wb_setImageName:@"report_icon_add_cp"];
    [contView addSubview:cpImageView];
    [cpImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(75);
        make.top.mas_equalTo(117);
        make.size.mas_equalTo(CGSizeMake(79, 79));
    }];
    UIButton *cpBtn = [[UIButton alloc] init];
    _cpBtn = cpBtn;
    [cpBtn setAttributedTitle:createAttString(@"产品",12, [UIColor whiteColor]) forState:UIControlStateNormal];
    UIImage *img1 = [[[UIImage wb_imageWithColor:rgba(201, 199, 199, 1) size:CGSizeMake(38, 18)] sd_roundedCornerImageWithRadius:5 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]] resizableImageWithCapInsets:UIEdgeInsetsMake(14, 6, 14, 6)];
    UIImage *img = [[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(38, 18)] sd_roundedCornerImageWithRadius:5 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]] resizableImageWithCapInsets:UIEdgeInsetsMake(14, 6, 14, 6)];
    [ cpBtn  setBackgroundImage:img1 forState:UIControlStateNormal];
    
    [ cpBtn  setBackgroundImage:img forState:UIControlStateSelected];
    cpBtn.contentEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 5);
    [contView addSubview:cpBtn];
    [cpBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo( cpImageView);
        make.centerX.equalTo(cpImageView.mas_right);
    }];
    
    UIButton *cpselBtn = [[UIButton alloc] init];
    _cpselBtn = cpselBtn;
    [cpselBtn addTarget:self action:@selector(cpClick:) forControlEvents:UIControlEventTouchUpInside];
    [cpselBtn wb_setImageName:@"report_icon_check"];
    [contView addSubview:cpselBtn];
    [cpselBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo( cpImageView.mas_bottom).offset(12.5);
        make.centerX.equalTo(cpImageView);
    }];
    
    UIButton *yqImageView =  [[UIButton alloc] init];
    _yqImageView = yqImageView;
    [yqImageView addTarget:self action:@selector(yqClick:) forControlEvents:UIControlEventTouchUpInside];

    [yqImageView wb_setImageName:@"report_icon_add_yq"];
    [contView addSubview:yqImageView];
    [yqImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-75);
        make.top.mas_equalTo(117);
        make.size.mas_equalTo(CGSizeMake(79, 79));
    }];
    
    UIButton *yqBtn = [[UIButton alloc] init];
    _yqBtn = yqBtn;
    [yqBtn setAttributedTitle:createAttString(@"仪器", 12, [UIColor whiteColor]) forState:UIControlStateNormal];
    [ yqBtn  setBackgroundImage:img1 forState:UIControlStateNormal];
    [ yqBtn  setBackgroundImage:img forState:UIControlStateSelected];
    yqBtn.contentEdgeInsets = UIEdgeInsetsMake(0, 5, 0, 5);
    [contView addSubview:yqBtn];
    [yqBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo( yqImageView);
        make.centerX.equalTo(yqImageView.mas_right);
    }];
    
    UIButton *yqselBtn = [[UIButton alloc] init];
    _yqselBtn = yqselBtn;
    [yqselBtn addTarget:self action:@selector(yqClick:) forControlEvents:UIControlEventTouchUpInside];
    [yqselBtn wb_setImageName:@"report_icon_check"];
    [contView addSubview:yqselBtn];
    [yqselBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo( yqImageView.mas_bottom).offset(12.5);
        make.centerX.equalTo(yqImageView);
    }];
    
    UITextField *pTF = [[UITextField alloc] init];
    [pTF addTarget:self action:@selector(pTFValueChange:) forControlEvents:UIControlEventEditingChanged];
    _pTF = pTF;
    pTF.attributedPlaceholder = createAttString(@"请输入名称", 18, rgba(185, 185, 185, 1));
    [contView addSubview:pTF];
    [pTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo( yqImageView.mas_bottom).offset(68-13);
        make.left.mas_equalTo(45);
        make.right.mas_equalTo(-45);
        make.height.mas_equalTo(26+19);
    }];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(229, 229, 229, 1);
    [contView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(0.5);
        make.right.left.bottom.equalTo(pTF);
    }];
    UIImage *saveImage = [[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(146, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)] resizableImageWithCapInsets:UIEdgeInsetsMake(0, 20, 0, 20)];
    
    UIImage *delImage =[[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(146, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)] resizableImageWithCapInsets:UIEdgeInsetsMake(0, 20, 0, 20)];
    
    UIButton * delBtn = [[UIButton alloc ]init];
    delBtn.hidden = YES;
    _delBtn = delBtn;
    [delBtn addTarget:self action:@selector(delBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [delBtn setAttributedTitle:createAttString(@"删除", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    [delBtn setBackgroundImage:delImage  forState:UIControlStateNormal];
//    [delBtn setBackgroundImage:selImage  forState:UIControlStateSelected];
    [contView addSubview:delBtn];
    [delBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(lineView.mas_bottom).offset(30);
        make.size.mas_equalTo(CGSizeMake(146, 45));
        make.centerX.equalTo(self).multipliedBy(0.6);
    }];
    
    UIButton *qdBtn = [[UIButton alloc] init];
    qdBtn.selected = YES;
    qdBtn.userInteractionEnabled = NO;
    _qdBtn = qdBtn;
    [qdBtn addTarget:self action:@selector(qdBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [qdBtn setAttributedTitle:createAttString(@"保存", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    [qdBtn setBackgroundImage:saveImage  forState:UIControlStateNormal];
//    [qdBtn setBackgroundImage:selImage  forState:UIControlStateSelected];
    [contView addSubview:qdBtn];
    [self.qdBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(lineView.mas_bottom).offset(30);
        make.size.mas_equalTo(CGSizeMake(225, 45));
        make.centerX.mas_equalTo(0);
    }];

    

    [self cpClick:self.cpselBtn];
}

- (void)pTFValueChange:(UITextField *)tf {
    self.qdBtn.selected =  !tf.text.length;
    self.qdBtn.userInteractionEnabled = tf.text.length;
}

- (void)cpClick:(UIButton *)btn {
    self.cpBtn.selected = self.cpImageView.selected = self.cpselBtn.selected = YES;
    self.yqBtn.selected = self.yqImageView.selected =  self.yqselBtn.selected = NO;

    self.type = @"2";
}

- (void)yqClick:(UIButton *)btn {
    
    self.cpBtn.selected = self.cpImageView.selected = self.cpselBtn.selected = NO;
    self.yqBtn.selected = self.yqImageView.selected =  self.yqselBtn.selected = YES;

    self.type = @"1";
}


- (void)qdBtnClick:(UIButton *)btn {
    if (self.pTF.text.length > 100) {
        [SVProgressHUD showErrorWithStatus:@"项目名称不能超过100个字"];
        return;
    }
    
    if ([self.pTF.text containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"项目名称不能输入表情"];
        return;
    }
    
    if (self.saveBlock) {
        self.saveBlock(self.type,self.pTF.text,1);
    }
    [self wb_disMiss];
}

- (void)delBtnClick:(UIButton *)btn {


    if (self.saveBlock) {
        self.saveBlock(self.type,self.pTF.text,2);
    }
    [self wb_disMiss];

}

- (void)updateType:(NSString *)tyep name:(NSString *)name {
    self.tipsLabel.attributedText = createAttString(@"编辑项目", 25, rgba(76, 74, 66, 1));


    
    self.delBtn.hidden = NO;
    if ([tyep isEqualToString:@"2"]) {
        
        self.cpBtn.selected = self.cpImageView.selected = self.cpselBtn.selected = YES;
        self.yqBtn.selected = self.yqImageView.selected =  self.yqselBtn.selected = NO;
        

    }else {
        self.cpBtn.selected = self.cpImageView.selected = self.cpselBtn.selected = NO;
        self.yqBtn.selected = self.yqImageView.selected =  self.yqselBtn.selected = YES;

    }
    self.qdBtn.selected = NO;
    self.qdBtn.userInteractionEnabled = YES;
    self.pTF.text = name;
    
    [self.qdBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(146, 45));
        make.centerX.equalTo(self).multipliedBy(1.4);
    }];
}
@end
