//
//  SMReportAddSchemeView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/1.
//

#import "SMReportAddSchemeView.h"
#import <IQKeyboardManager/IQTextView.h>


@interface SMReportAddSchemeView()<UITextViewDelegate>

@property(nonatomic, weak)UIView *zzConetView;
//@property(nonatomic, weak)UIView *ssConetView;
@property(nonatomic, weak)UIView *ffConetView;

@property(nonatomic, weak)IQTextView *zzNameTV;
//@property(nonatomic, weak)IQTextView *ssNameTV;
@property(nonatomic, weak)IQTextView *ffNameTV;
@property(nonatomic, strong)NSMutableArray *wenAnArray;
@property(nonatomic, weak)UIButton *qdBtn;
@property(nonatomic, strong)NSMutableArray *typeBtnArray;
@property(nonatomic, assign)CGFloat startY;
@end
@implementation SMReportAddSchemeView



- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = [UIColor whiteColor];
    UIImageView *tipsImageView = [[UIImageView alloc] init];
    tipsImageView.image = [UIImage imageNamed:@"report_header_bg"];
    [self addSubview:tipsImageView];
    [tipsImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.right.left.mas_equalTo(0);
//        make.height.mas_equalTo(258);
    }];
    
    
    UIButton *backBtn = [[UIButton alloc] init];
    backBtn.frame = CGRectMake(10, safaTop(20) , 38, 45);
    [backBtn wb_setImageName:@"nav_black_back"];
    [backBtn addTarget:self action:@selector(backClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:backBtn];
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.attributedText = createAttString(@"添加方案", 17, rgba(76, 74, 66, 1));
    [self addSubview:titleLabel];
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.centerY.equalTo(backBtn);
    }];
    
    
    UILabel *tipsLabel = [[UILabel alloc] init];
    tipsLabel.attributedText = createAttString(@"预设方案", 17, rgba(68, 57, 53, 1));
    [self addSubview:tipsLabel];
    [tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.mas_equalTo(safaTop(79));
    }];
    
    NSString *path = [[NSBundle mainBundle] pathForResource:@"ysfa" ofType: @"json"];
    NSData *data = [[NSData alloc] initWithContentsOfFile:path];
    NSError * error;
    NSDictionary *typeDict = [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:&error];

    
    NSArray *typeStringArray = typeDict[@"category"];
    _wenAnArray = typeStringArray;
    self.typeBtnArray = [[NSMutableArray alloc] init];
//    [@"敏感,纹理,毛孔粗大,毛孔堵塞,皮脂偏多,皮脂偏少,色素沉淀" componentsSeparatedByString:@","];
    UIView *lastView = nil;
    CGFloat space = biliSize(10, 10).width;
    for (int i = 0; i < typeStringArray.count; i++ ) {
        NSDictionary *dict = typeStringArray[i];
        NSString *typeString = dict[@"bt"];
        UIButton *tipsBtn = [[UIButton alloc] init];
        
        /*
         
         UIImage *selectImage = [[UIImage wb_imageWithColor:rgba(255, 124, 78, 1)size:CGSizeMake(64, 30)]sd_roundedCornerImageWithRadius:30/2 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]];
         UIImage *normalImage = [[UIImage wb_imageWithColor:rgba(242, 238, 233, 1) size:CGSizeMake(64, 30)]sd_roundedCornerImageWithRadius:30/2 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]];
         for (int i = 0; i < nameArray.count; i++) {
             NSString *title = nameArray[i];
             UIButton *btn = [[UIButton alloc] init];
         rgba(255, 124, 78, 1)
             [btn setAttributedTitle:createAttString(title, 14, rgba(255, 255, 255, 1)) forState: UIControlStateSelected];
             [btn setAttributedTitle:createAttString(title, 14, rgba(255, 124, 78, 1)) forState: UIControlStateNormal];
         */
        [tipsBtn setAttributedTitle:createAttString(typeString, 14, rgba(255, 255, 255, 1)) forState: UIControlStateSelected];

        [tipsBtn setAttributedTitle:createAttString(typeString, 14, rgba(153, 153, 153, 1)) forState:UIControlStateNormal];
        tipsBtn.tag = 1590 + i;
        [tipsBtn addTarget:self action:@selector(typeBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        UIImage *img = [[[UIImage wb_imageWithColor:[UIColor whiteColor] size:CGSizeMake(64, 30)] sd_roundedCornerImageWithRadius:15 corners:0xf borderWidth:0 borderColor:[UIColor clearColor]] resizableImageWithCapInsets:UIEdgeInsetsMake(30, 14, 30, 14)];
        UIImage *selectImage = [[UIImage wb_imageWithColor:rgba(255, 124, 78, 1)size:CGSizeMake(64, 30)]sd_roundedCornerImageWithRadius:30/2 corners:0xff borderWidth:0 borderColor:[UIColor clearColor]];
        [ tipsBtn setBackgroundImage:img forState:UIControlStateNormal];
        [ tipsBtn setBackgroundImage:selectImage forState:UIControlStateSelected];
        [self addSubview:tipsBtn];
        [self.typeBtnArray addObject:tipsBtn];
        CGFloat lastX = CGRectGetMaxX(lastView.frame);
        CGFloat vW = 0;
        if (typeString.length == 2) {
            vW = 64;
        }else if(typeString.length == 4) {
            vW = 84;
        }
        CGFloat tempW = lastX + space+space + vW;
        if (tempW < self.frame.size.width) {
            if (i == 0) {
                tipsBtn.frame = CGRectMake(20,safaTop(111), vW, 30);
            }else {
                tipsBtn.frame = CGRectMake( lastX + space, lastView.frame.origin.y, vW, 30);
            }
        }else {
            tipsBtn.frame = CGRectMake(20, CGRectGetMaxY(lastView.frame)+space, vW, 30);
        }
        lastView = tipsBtn;
    }
    // 症状名称
    self.startY = CGRectGetMaxY(lastView.frame)+20;
    UIView *zzConetView = [[UIView alloc] init];
    zzConetView.backgroundColor = [UIColor whiteColor];
    [self addSubview:zzConetView];
    _zzConetView = zzConetView;
    zzConetView.frame = CGRectMake(0, self.startY , self.frame.size.width, 120);

    UILabel *zztipsLabel = [[UILabel alloc] init];
    [zztipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisVertical];
    zztipsLabel.attributedText = createAttString(@"症状名称", 17, rgba(68, 57, 53, 1));
    [zzConetView addSubview:zztipsLabel];
    [zztipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.mas_equalTo(20);
    }];

    IQTextView *zzNameTV = [[IQTextView alloc] init];
    _zzNameTV = zzNameTV;
    zzNameTV.placeholder = @"请输入症状名称";
    zzNameTV.delegate = self;
    zzNameTV.font = [UIFont systemFontOfSize:14];
    zzNameTV.textColor = rgba(76, 74, 66, 1);
    [zzConetView addSubview:zzNameTV];
    [zzNameTV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.top.equalTo(zztipsLabel.mas_bottom).offset(10);
        make.bottom.mas_equalTo(-10);
    }];

    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(243, 243, 243, 1);
    [zzConetView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(10);
    }];
    
//    //症状描述
//    UIView *ssConetView = [[UIView alloc] init];
//    ssConetView.backgroundColor = [UIColor whiteColor];
//    [self addSubview:ssConetView];
//    _ssConetView = ssConetView;
//    ssConetView.frame = CGRectMake(0,safaTop(310), self.frame.size.width, 130);

//    UILabel *sstipsLabel = [[UILabel alloc] init];
//    [sstipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisVertical];
//    sstipsLabel.attributedText = createAttString(@"症状描述", 17, rgba(68, 57, 53, 1));
//    [ssConetView addSubview:sstipsLabel];
//    [sstipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(20);
//        make.top.mas_equalTo(20);
//    }];
//
//    IQTextView *ssNameTV = [[IQTextView alloc] init];
//    _ssNameTV = ssNameTV;
//    ssNameTV.placeholder = @"请输入症状描述";
//    ssNameTV.delegate = self;
//    ssNameTV.font = [UIFont systemFontOfSize:14];
//    ssNameTV.textColor = rgba(76, 74, 66, 1);
//    [ssConetView addSubview:ssNameTV];
//    [ssNameTV mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(20);
//        make.right.mas_equalTo(-20);
//        make.top.equalTo(sstipsLabel.mas_bottom).offset(14);
//        make.bottom.mas_equalTo(-10);
//    }];
//
//    UIView *sslineView = [[UIView alloc] init];
//    sslineView.backgroundColor = rgba(243, 243, 243, 1);
//    [ssConetView addSubview:sslineView];
//    [sslineView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.bottom.right.mas_equalTo(0);
//        make.height.mas_equalTo(10);
//    }];
    
// 护理方法
    UIView *ffConetView = [[UIView alloc] init];
    ffConetView.backgroundColor = [UIColor whiteColor];
    [self addSubview:ffConetView];
    _ffConetView = ffConetView;
//    ffConetView.frame = CGRectMake(0,safaTop(440), self.frame.size.width, 130);
    

    
    ffConetView.frame = CGRectMake(0,self.startY+120, self.frame.size.width, ([UIScreen mainScreen].bounds.size.height - (self.startY+120) - 100));

    


    UILabel *fftipsLabel = [[UILabel alloc] init];
    [fftipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisVertical];
    fftipsLabel.attributedText = createAttString(@"护理方法", 17, rgba(68, 57, 53, 1));
    [ffConetView addSubview:fftipsLabel];
    [fftipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.mas_equalTo(20);
    }];
    
    IQTextView *ffNameTV = [[IQTextView alloc] init];
    _ffNameTV = ffNameTV;
    ffNameTV.placeholder = @"请输入护理方法";
    ffNameTV.delegate = self;
    ffNameTV.font = [UIFont systemFontOfSize:14];
    ffNameTV.textColor = rgba(76, 74, 66, 1);
    [ffConetView addSubview:ffNameTV];
    [ffNameTV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.top.equalTo(fftipsLabel.mas_bottom).offset(10);
        make.bottom.mas_equalTo(-10);
    }];
    
//    UIView *fflineView = [[UIView alloc] init];
//    fflineView.backgroundColor = rgba(243, 243, 243, 1);
//    [ffConetView addSubview:fflineView];
//    [fflineView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.bottom.right.mas_equalTo(0);
//        make.height.mas_equalTo(10);
//    }];
    
    
    UIButton *qdBtn = [[UIButton alloc] init];
    qdBtn.selected = YES;
    qdBtn.userInteractionEnabled = NO;
    _qdBtn = qdBtn;
    [qdBtn addTarget:self action:@selector(qdBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [qdBtn setAttributedTitle:createAttString(@"保存", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    [qdBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [qdBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [self addSubview:qdBtn];
    [qdBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(-37);
    }];
    
}
- (void)typeBtnClick:(UIButton *)btn {

    
    
    NSInteger index = btn.tag - 1590;
    NSDictionary *dict = self.wenAnArray[index];
    self.ffNameTV.text = dict[@"fa"];
    self.zzNameTV.text = dict[@"bt"];
//    self.ssNameTV.text = dict[@"zz"];
    self.qdBtn.selected = NO;
    self.qdBtn.userInteractionEnabled = YES;
    
    
    for (int i = 0; i < self.wenAnArray.count; i++) {
        NSDictionary *dict =  self.wenAnArray[i];
        UIButton *btn =  self.typeBtnArray[i];
        if ( [dict[@"fa"] isEqualToString: self.ffNameTV.text] &&
            [dict[@"bt"] isEqualToString: self.zzNameTV.text]) {
            btn.selected = YES;
            btn.userInteractionEnabled = NO;
        }else {
            btn.selected = NO;
            btn.userInteractionEnabled = YES;
        }
    }

    
}

- (void)textViewDidBeginEditing:(UITextView *)textView {
    
    [self bringSubviewToFront:textView.superview];
    [UIView animateWithDuration:0.25 animations:^{
        CGFloat h = self.frame.size.height - 150;
        if ([textView.superview isEqual:self.zzConetView]) {
            self.zzConetView.frame = CGRectMake(0, safaTop(64), self.frame.size.width, h);
        }else if([textView.superview isEqual:self.ffConetView]) {
            self.ffConetView.frame = CGRectMake(0, safaTop(64), self.frame.size.width, h);
        }else if([textView.superview isEqual:self.ffConetView]) {
            self.ffConetView.frame = CGRectMake(0, safaTop(64), self.frame.size.width, h);
        }
    }];
}

- (void)textViewDidEndEditing:(UITextView *)textView {
    [self bringSubviewToFront:textView.superview];
    [UIView animateWithDuration:0.25 animations:^{
        if ([textView.superview isEqual:self.zzConetView]) {
            self.zzConetView.frame = CGRectMake(0,self.startY, self.frame.size.width, 120);
        }else if([textView.superview isEqual:self.ffConetView]) {
            self.ffConetView.frame = CGRectMake(0, self.startY+120, self.frame.size.width, ([UIScreen mainScreen].bounds.size.height - ( self.startY+120) - 100));
        }
        
    }];

}


- (void)textViewDidChange:(UITextView *)textView {
    if ( self.ffNameTV.text.length && self.zzNameTV.text.length) {
        self.qdBtn.selected = NO;
        self.qdBtn.userInteractionEnabled = YES;
    }else {
        self.qdBtn.selected = YES;
        self.qdBtn.userInteractionEnabled = NO;
    }
    
    for (int i = 0; i < self.wenAnArray.count; i++) {
        NSDictionary *dict =  self.wenAnArray[i];
        UIButton *btn =  self.typeBtnArray[i];
        if ( [dict[@"fa"] isEqualToString: self.ffNameTV.text] &&
            [dict[@"bt"] isEqualToString: self.zzNameTV.text]) {
            btn.selected = YES;
            btn.userInteractionEnabled = NO;
        }else {
            btn.selected = NO;
            btn.userInteractionEnabled = YES;
        }
    }

}

- (void)backClick:(UIButton *)btn {
    [self wb_disLTRMiss];
}

- (void)qdBtnClick:(UIButton *)btn {
    
    NSString *sname = self.zzNameTV.text;
    if (sname == 0) {
        [SVProgressHUD showErrorWithStatus:@"症状名称不能为空"];
        return;
    }
    if ([sname containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"症状名称不能输入表情"];
        return;
    }
    if (sname.length > 30) {
        [SVProgressHUD showErrorWithStatus:@"症状名称不能超过30个字"];
        return;
    }
    
    
//    NSString *sDescribe = self.ssNameTV.text;
//    if (sDescribe == 0) {
//        [SVProgressHUD showErrorWithStatus:@"症状描述不能为空"];
//        return;
//    }
//    if ([sDescribe containsEmoji]) {
//        [SVProgressHUD showErrorWithStatus:@"症状描述不能输入表情"];
//        return;
//    }
//    if (sDescribe.length > 2000) {
//        [SVProgressHUD showErrorWithStatus:@"症状描述不能超过2000个字"];
//        return;
//    }
//
    NSString *sMethod = self.ffNameTV.text;
    if (sMethod == 0) {
        [SVProgressHUD showErrorWithStatus:@"护理方法不能为空"];
        return;
    }
    if ([sMethod containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"护理方法不能输入表情"];
        return;
    }
    if (sMethod.length > 2000) {
        [SVProgressHUD showErrorWithStatus:@"护理方法不能超过2000个字"];
        return;
    }
    
    if (self.saveBlock) {
        self.saveBlock(self.zzNameTV.text,@"",self.ffNameTV.text);
    }
    [self wb_disLTRMiss];
}

@end
