//
//  SMReportEditSchemeView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/1.
//

#import "SMReportEditSchemeView.h"
#import <IQKeyboardManager/IQUIView+Hierarchy.h>
#import <IQKeyboardManager/IQTextView.h>



@interface SMReportEditSchemeView()<UITextViewDelegate>

@property(nonatomic, weak)UIView *zzConetView;
//@property(nonatomic, weak)UIView *ssConetView;
@property(nonatomic, weak)UIView *ffConetView;

@property(nonatomic, weak)IQTextView *zzNameTV;
//@property(nonatomic, weak)IQTextView *ssNameTV;
@property(nonatomic, weak)IQTextView *ffNameTV;
@property(nonatomic, weak)UIButton *qdBtn;
@end
@implementation SMReportEditSchemeView

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.backgroundColor = [UIColor whiteColor];
    UIImageView *tipsImageView = [[UIImageView alloc] init];
    tipsImageView.image = [UIImage imageNamed:@"report_header_bg"];
    [self addSubview:tipsImageView];
    [tipsImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.right.left.mas_equalTo(0);
//        make.height.mas_equalTo(258);
    }];
    // 症状名称
    
    UIButton *backBtn = [[UIButton alloc] init];
    backBtn.frame = CGRectMake(10, safaTop(20) , 38, 45);
    [backBtn wb_setImageName:@"nav_black_back"];
    [backBtn addTarget:self action:@selector(backClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:backBtn];
    
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.attributedText = createAttString(@"编辑方案", 17, rgba(76, 74, 66, 1));
    [self addSubview:titleLabel];
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.centerY.equalTo(backBtn);
    }];
    
    UIView *zzConetView = [[UIView alloc] init];
    zzConetView.backgroundColor = [UIColor whiteColor];
    [self addSubview:zzConetView];
    _zzConetView = zzConetView;
    zzConetView.frame = CGRectMake(0, 96.5, self.frame.size.width, 120);

    UILabel *zztipsLabel = [[UILabel alloc] init];
    [zztipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisVertical];
    zztipsLabel.attributedText = createAttString(@"症状名称", 17, rgba(68, 57, 53, 1));
    [zzConetView addSubview:zztipsLabel];
    [zztipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.mas_equalTo(20);
    }];

    IQTextView *zzNameTV = [[IQTextView alloc] init];
    _zzNameTV = zzNameTV;
    zzNameTV.placeholder = @"请输入症状名称";
    zzNameTV.delegate = self;
    zzNameTV.font = [UIFont systemFontOfSize:14];
    zzNameTV.textColor = rgba(76, 74, 66, 1);
    [zzConetView addSubview:zzNameTV];
    [zzNameTV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.top.equalTo(zztipsLabel.mas_bottom).offset(10);
        make.bottom.mas_equalTo(-10);
    }];

    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(243, 243, 243, 1);
    [zzConetView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(10);
    }];
    
//  症状描述
//    UIView *ssConetView = [[UIView alloc] init];
//    ssConetView.backgroundColor = [UIColor whiteColor];
//    [self addSubview:ssConetView];
//    _ssConetView = ssConetView;
//    ssConetView.frame = CGRectMake(0, 196.5, self.frame.size.width, 130);
//
//    UILabel *sstipsLabel = [[UILabel alloc] init];
//    [sstipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisVertical];
//    sstipsLabel.attributedText = createAttString(@"症状描述", 17, rgba(68, 57, 53, 1));
//    [ssConetView addSubview:sstipsLabel];
//    [sstipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(20);
//        make.top.mas_equalTo(20);
//    }];
//
//    IQTextView *ssNameTV = [[IQTextView alloc] init];
//    _ssNameTV = ssNameTV;
//    ssNameTV.placeholder = @"请输入症状描述";
//    ssNameTV.delegate = self;
//    ssNameTV.font = [UIFont systemFontOfSize:14];
//    ssNameTV.textColor = rgba(76, 74, 66, 1);
//    [ssConetView addSubview:ssNameTV];
//    [ssNameTV mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(20);
//        make.right.mas_equalTo(-20);
//        make.top.equalTo(sstipsLabel.mas_bottom).offset(10);
//        make.bottom.mas_equalTo(-10);
//    }];
//
//    UIView *sslineView = [[UIView alloc] init];
//    sslineView.backgroundColor = rgba(243, 243, 243, 1);
//    [ssConetView addSubview:sslineView];
//    [sslineView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.bottom.right.mas_equalTo(0);
//        make.height.mas_equalTo(10);
//    }];
    
    
// 护理方法
    UIView *ffConetView = [[UIView alloc] init];
    ffConetView.backgroundColor = [UIColor whiteColor];
    [self addSubview:ffConetView];
    _ffConetView = ffConetView;
    ffConetView.frame = CGRectMake(0, 220, self.frame.size.width, ([UIScreen mainScreen].bounds.size.height - 220 - 100));
  
    UILabel *fftipsLabel = [[UILabel alloc] init];
    [fftipsLabel setContentHuggingPriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisVertical];
    fftipsLabel.attributedText = createAttString(@"护理方法", 17, rgba(68, 57, 53, 1));
    [ffConetView addSubview:fftipsLabel];
    [fftipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.mas_equalTo(20);
    }];
    
    IQTextView *ffNameTV = [[IQTextView alloc] init];
    _ffNameTV = ffNameTV;
    ffNameTV.placeholder = @"请输入护理方法";
    ffNameTV.delegate = self;
    ffNameTV.font = [UIFont systemFontOfSize:14];
    ffNameTV.textColor = rgba(76, 74, 66, 1);
    [ffConetView addSubview:ffNameTV];
    [ffNameTV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.top.equalTo(fftipsLabel.mas_bottom).offset(14);
        make.bottom.mas_equalTo(-10);
    }];
    
//    UIView *fflineView = [[UIView alloc] init];
//    fflineView.backgroundColor = rgba(243, 243, 243, 1);
//    [ffConetView addSubview:fflineView];
//    [fflineView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.bottom.right.mas_equalTo(0);
//        make.height.mas_equalTo(10);
//    }];
    
    
    UIButton *qdBtn = [[UIButton alloc] init];
    qdBtn.selected = YES;
    qdBtn.userInteractionEnabled = NO;
    _qdBtn = qdBtn;
    [qdBtn addTarget:self action:@selector(qdClick:) forControlEvents:UIControlEventTouchUpInside];
    [qdBtn setAttributedTitle:createAttString(@"保存", 15, rgba(255, 255, 255, 1)) forState:UIControlStateNormal];
    [qdBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [qdBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 200, 180, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateSelected];
    [self addSubview:qdBtn];
    [qdBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.bottom.mas_equalTo(-37);
    }];
    
    UIButton *delBtn = [[UIButton alloc] init];
    [delBtn addTarget:self action:@selector(delBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [delBtn wb_setImageName:@"Program_icon_delete"];
    [self addSubview:delBtn];
    [delBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(backBtn);
        make.right.mas_equalTo(-10);
        make.size.mas_equalTo(CGSizeMake(25, 25));
    }];
    
    
}
- (void)delBtnClick:(UIButton *)btn {
 
    @weakify(self);
        
        //1.创建UIAlertControl
           UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"删除解决方案" message:@"" preferredStyle:UIAlertControllerStyleAlert];
           /*
            参数说明：
            Title:弹框的标题
            message:弹框的消息内容
            preferredStyle:弹框样式：UIAlertControllerStyleAlert
            */
           
           //2.添加按钮动作
           //2.1 确认按钮
           UIAlertAction *conform = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {

               @strongify(self);
               
               if (self.saveBlock) {
                   self.saveBlock(self.zzNameTV.text,@"",self.ffNameTV.text,2);
               }
               
               [self wb_disLTRMiss];
               
                 
           }];
         
        UIAlertAction *cancleAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {

              
        }];
       
        
           //3.将动作按钮 添加到控制器中

        [alert addAction:cancleAction];
        [alert addAction:conform];
           
           //4.显示弹框
         
    [self.viewContainingController presentViewController:alert animated:YES completion:nil];
        

}
- (void)qdClick:(UIButton *)btn {

    
    NSString *sname = self.zzNameTV.text;
    if (sname == 0) {
        [SVProgressHUD showErrorWithStatus:@"症状名称不能为空"];
        return;
    }
    if ([sname containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"症状名称不能输入表情"];
        return;
    }
    if (sname.length > 30) {
        [SVProgressHUD showErrorWithStatus:@"症状名称不能超过30个字"];
        return;
    }
    
    
//    NSString *sDescribe = self.ssNameTV.text;
//    if (sDescribe == 0) {
//        [SVProgressHUD showErrorWithStatus:@"症状描述不能为空"];
//        return;
//    }
//    if ([sDescribe containsEmoji]) {
//        [SVProgressHUD showErrorWithStatus:@"症状描述不能输入表情"];
//        return;
//    }
//    if (sDescribe.length > 2000) {
//        [SVProgressHUD showErrorWithStatus:@"症状描述不能超过2000个字"];
//        return;
//    }
//
    NSString *sMethod = self.ffNameTV.text;
    if (sMethod == 0) {
        [SVProgressHUD showErrorWithStatus:@"护理方法不能为空"];
        return;
    }
    if ([sMethod containsEmoji]) {
        [SVProgressHUD showErrorWithStatus:@"护理方法不能输入表情"];
        return;
    }
    if (sMethod.length > 2000) {
        [SVProgressHUD showErrorWithStatus:@"护理方法不能超过2000个字"];
        return;
    }
    
    if (self.saveBlock) {
        self.saveBlock(self.zzNameTV.text,@"",self.ffNameTV.text,1);
    }
    
    [self wb_disLTRMiss];
}

- (void)textViewDidBeginEditing:(UITextView *)textView {
    
    [self bringSubviewToFront:textView.superview];
    [UIView animateWithDuration:0.25 animations:^{
        CGFloat h = self.frame.size.height - 150;
        if ([textView.superview isEqual:self.zzConetView]) {
            self.zzConetView.frame = CGRectMake(0, safaTop(64), self.frame.size.width, h);
        }else if([textView.superview isEqual:self.ffConetView]) {
            self.ffConetView.frame = CGRectMake(0, safaTop(64), self.frame.size.width, h);
        }
        
        
    }];


}

- (void)textViewDidEndEditing:(UITextView *)textView {
    [self bringSubviewToFront:textView.superview];
    [UIView animateWithDuration:0.25 animations:^{
        if ([textView.superview isEqual:self.zzConetView]) {
            self.zzConetView.frame = CGRectMake(0, 96.5, self.frame.size.width, 120);
        }else if([textView.superview isEqual:self.ffConetView]) {
            self.ffConetView.frame = CGRectMake(0, 220, self.frame.size.width, ([UIScreen mainScreen].bounds.size.height - 220 - 100));
        }
        
    }];
}


- (void)textViewDidChange:(UITextView *)textView {
    if ( self.ffNameTV.text.length && self.zzNameTV.text.length) {
        self.qdBtn.selected = NO;
        self.qdBtn.userInteractionEnabled = YES;
    }else {
        self.qdBtn.selected = YES;
        self.qdBtn.userInteractionEnabled = NO;
    }
}

- (void)backClick:(UIButton *)btn {
    [self wb_disLTRMiss];
}

- (void)updateSname:(NSString *)sname sDescribe:(NSString *)sDescribe sMethod:(NSString *)sMethod {
    self.zzNameTV.text = sname;
    self.ffNameTV.text = sMethod;
    self.qdBtn.selected = NO;
    self.qdBtn.userInteractionEnabled = YES;
}
@end
