//
//  SMReportHeaderCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/23.
//

#import "SMReportHeaderCell.h"
#import "SMPageControl.h"
#import "SMRaderMapCompleteView.h"
#import "SMReportImageCell.h"
#import "SMShowImageView.h"
#import <IQUIView+Hierarchy.h>

@interface SMReportHeaderCell()<UICollectionViewDataSource,UICollectionViewDelegateFlowLayout>
@property(nonatomic, strong)SMPageControl *pageControl;
@end

@implementation SMReportHeaderCell


//- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
//    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
//        [self setupUI];
//    }
//    return self;
//}
- initWithModel:(SMLocalReportModel *)model {
    if (self = [super init]) {
        _lrModel = model;
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    self.selectionStyle =UITableViewCellSelectionStyleNone;
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc ] init];
    layout.itemSize = biliSize(335, 175.5);
    layout.minimumLineSpacing = 0;
    layout.minimumInteritemSpacing = 0;
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    UICollectionView *imageCView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
    _imageCView = imageCView;
    imageCView.layer.masksToBounds = YES;
    imageCView.layer.cornerRadius = 10;
    [imageCView addObserver:self forKeyPath:@"contentOffset" options:NSKeyValueObservingOptionNew context:nil];
    imageCView.pagingEnabled = YES;
    imageCView.showsHorizontalScrollIndicator = NO;
    imageCView.showsVerticalScrollIndicator = NO;
    
    imageCView.dataSource = self;
    imageCView.delegate = self;
    [imageCView registerClass:[SMReportImageCell class] forCellWithReuseIdentifier:NSStringFromClass([SMReportImageCell class])];
    [self.contentView addSubview:imageCView];
    [imageCView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(0);
        make.centerX.mas_equalTo(0);
        make.size.mas_equalTo(biliSize(335, 175.5));
    }];
    
    UIButton *fdBtn = [[UIButton alloc] init];
    fdBtn.userInteractionEnabled = NO;
    [fdBtn wb_setImageName:@"report_icon_amplification"];
    [self.contentView addSubview:fdBtn];
    [fdBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(imageCView).offset(-10);
        make.right.equalTo(imageCView).offset(-15);
    }];
    
    
    self.pageControl = [[SMPageControl alloc] initWithFrame:CGRectMake(0, 0, 50, 4)];
    [self.contentView addSubview:self.pageControl];
    [self.pageControl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(imageCView);
        make.bottom.equalTo(imageCView).offset(-10);
    }];
    
    self.pageControl.cornerRadius = 5;
    self.pageControl.dotHeight = 5;
    self.pageControl.dotSpace = 6;
    self.pageControl.currentDotWidth = 5;
    self.pageControl.otherDotWidth = 5;
    self.pageControl.otherDotColor = rgba(210, 202, 202, 1);
    self.pageControl.currentDotColor = [UIColor whiteColor];
    self.pageControl.numberOfPages = 4;
    
    self.pageControl.currentPage = 0;
    UIView *lastView = imageCView;
    if (self.lrModel.AISymptomArray.count < 5) {
        
    }else {
        
        UIView *xVivew = [[UIView alloc] init];
        xVivew.layer.masksToBounds = YES;
        [self.contentView addSubview:xVivew];
        [xVivew mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(imageCView.mas_bottom).offset(20);
            make.centerX.mas_equalTo(0);
            make.height.width.mas_equalTo(300);
            
        }];
        NSMutableArray *nameArray = [[NSMutableArray alloc] init];
        NSMutableArray *fenArray = [[NSMutableArray alloc] init];
        for (int i = 0; i < self.lrModel.AISymptomArray.count; i++) {
            
            
            SMLocalReportAIModel *model = self.lrModel.AISymptomArray[i];

            
            
            /// 症状标志名（* ：； ：；纹理：magn_wrinkle； 毛孔堵塞：magn_pore_clogging；毛孔粗大：magn_pore_large；色素沉淀：magn_pigmentation；皮脂：magn_sebum；）与服务端一一对应，不可修改
            if ([model.tagFlag isEqualToString:@"magn_water"] ) {//水份
                if (model.tagNum.intValue == 0) {
                    continue;
                    [fenArray addObject:@"0.1"];
                }else if (model.tagNum.intValue < 45) {
                    [fenArray addObject:@"0.33"];
                }else if (model.tagNum.intValue <= 55) {
                    [fenArray addObject:@"0.66"];
                }else {
                    [fenArray addObject:@"0.99"];
                }
            }else if ([model.tagFlag isEqualToString:@"magn_sensity"] ) {//敏感
                int fen = 0;
                if (model.tagNum.doubleValue > 0 && model.tagNum.doubleValue  < 1) {
                    fen = 1;
                }else {
                    fen = ceilf(model.tagNum.doubleValue);
                }
                
                if (fen == 0) {
                    [fenArray addObject:@"0.99"];
                }else if (fen <= 10) {
                    [fenArray addObject:@"0.66"];
                }else if (fen <= 20) {
                    [fenArray addObject:@"0.33"];
                }else {
                    [fenArray addObject:@"0.1"];
                }

            }else if ([model.tagFlag isEqualToString:@"magn_pigmentation"]) {
                
                int fen = 0;
                if (model.tagNum.doubleValue > 0 && model.tagNum.doubleValue  < 1) {
                    fen = 1;
                }else {
                    fen = ceilf(model.tagNum.doubleValue);
                }
                
                if (fen == 0) {
                    [fenArray addObject:@"0.99"];
                }else if (fen <= 7) {
                    [fenArray addObject:@"0.66"];
                }else if (fen <= 15) {
                    [fenArray addObject:@"0.33"];
                }else {
                    [fenArray addObject:@"0.1"];
                }
            
            }else if ([model.tagFlag isEqualToString:@"magn_wrinkle"]) {
                if (model.tagNum.intValue == 0) {
                    [fenArray addObject:@"0.99"];
                }else if (model.tagNum.intValue <= 25) {
                    [fenArray addObject:@"0.66"];
                }else if (model.tagNum.intValue <= 40) {
                    [fenArray addObject:@"0.33"];
                }else {
                    [fenArray addObject:@"0.1"];
                }
            

            }else if ([model.tagFlag isEqualToString:@"magn_pore_large"] ||
                      [model.tagFlag isEqualToString:@"magn_pore_clogging"]) {
                if (model.tagNum.intValue == 0) {
                    [fenArray addObject:@"0.99"];
                }else if (model.tagNum.intValue <= 50000) {
                    [fenArray addObject:@"0.66"];
                }else if (model.tagNum.intValue <= 120000) {
                    [fenArray addObject:@"0.33"];
                }else {
                    [fenArray addObject:@"0.1"];
                }
            }else if ([model.tagFlag isEqualToString:@"magn_sebum"]) {
                
                
                if (model.tagNum.intValue <= 9) {
                    [fenArray addObject:@"0.99"];
                }else {
                    int fen = abs(model.tagNum.intValue - 90);
                    [fenArray addObject:[NSString stringWithFormat:@"%0.2f",fen/100.0]];
                }
            }
            [nameArray addObject:model.tagname];
        
        }
        
        
        ElementItem *item1 = [[ElementItem alloc]init];
        item1.itemPercent =  fenArray;
        item1.itemColor = rgba(225, 207, 183, 1);
        
        //        @[@"水份",@"皮脂",@"色沉",@"毛孔粗大",@"毛孔堵塞",@"纹理"  ,@"敏感"];
        SMRaderMapCompleteView *radar = [[SMRaderMapCompleteView alloc]initWithRadarElements:nameArray size:CGSizeMake(300, 300) lengthColor:rgba(229, 213, 193, 1)];
        [radar addAbilitysWithElements:@[item1]];
        [xVivew addSubview:radar];
        [self.contentView bringSubviewToFront:imageCView];
        [self.contentView bringSubviewToFront:fdBtn];
        
        UIView *tipsBgView = [[UIView alloc] init];
        lastView = tipsBgView;
        tipsBgView.backgroundColor =  rgba(248, 246, 244, 1);
        tipsBgView.layer.cornerRadius =14;
        [self.contentView addSubview:tipsBgView];
        [tipsBgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(xVivew.mas_bottom).offset(-40);
            make.centerX.mas_equalTo(0);
            make.size.mas_equalTo(CGSizeMake(300, 27));
        }];
        
        UILabel *tipsLabel = [[UILabel alloc] init];
        tipsLabel.backgroundColor = rgba(248, 246, 244, 1);
        tipsLabel.attributedText = createAttString(@"雷达图越往外代表越健康",12, rgba(153, 153, 153, 1));
        tipsLabel.textAlignment = NSTextAlignmentCenter;
        [tipsBgView addSubview:tipsLabel];
        [tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.mas_equalTo(0);
        }];
        
        UILabel *xinLabel = [[UILabel alloc] init];
        xinLabel.backgroundColor = rgba(248, 246, 244, 1);
        xinLabel.attributedText = createAttString(@"*",12, rgba(153, 153, 153, 1));
        xinLabel.textAlignment = NSTextAlignmentCenter;
        [tipsBgView addSubview:xinLabel];
        [xinLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_equalTo(2);
            make.right.equalTo(tipsLabel.mas_left);
        }];
        
    }
    
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(243, 243, 243, 1);
    [self.contentView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(lastView.mas_bottom).offset(25);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(11.5);
        make.bottom.mas_equalTo(0);
    }];
    
}


- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary<NSKeyValueChangeKey,id> *)change context:(void *)context {
    
    int page =  (int)(self.imageCView.contentOffset.x / self.imageCView.bounds.size.width+0.5);
    if ( self.pageControl.currentPage != page) {
        self.pageControl.currentPage = page ;
    }
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.lrModel.imageArray.count;;
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    SMReportImageCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([SMReportImageCell class]) forIndexPath:indexPath];
    SMLocalReportImageModel *model = self.lrModel.imageArray[indexPath.row];

    @weakify(cell);
    cell.iconImageView.contentMode = UIViewContentModeCenter;
    [cell.iconImageView sd_setImageWithURL:[NSURL URLWithString:model.iURL] placeholderImage:[UIImage imageNamed:@"report_Placeholder_img"]completed:^(UIImage * _Nullable image, NSError * _Nullable error, SDImageCacheType cacheType, NSURL * _Nullable imageURL) {
        @strongify(cell);
        if (image) {
            cell.iconImageView.contentMode = UIViewContentModeScaleAspectFill;
        }

    }];
    
    [cell.tipsBtn setAttributedTitle:createAttString(model.iname ,15, [UIColor whiteColor]) forState:UIControlStateNormal];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    SMReportImageCell *cell = (SMReportImageCell *)[collectionView cellForItemAtIndexPath:indexPath];
    SMShowImageView *iview = [SMShowImageView new];
    iview.dataArray = self.lrModel.imageArray;
    iview.selectIndex = indexPath.row;
    [iview mm_showFrameView:self.viewContainingController.view positionView:cell];
}


-(void)dealloc {
    [self.imageCView removeObserver:self forKeyPath:@"contentOffset"];
}
@end
