//
//  SMReportImageCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/23.
//

#import "SMReportImageCell.h"

@implementation SMReportImageCell

- (instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.iconImageView = [[UIImageView alloc] init];
    self.iconImageView.backgroundColor = rgba(255, 248, 244, 1);
    self.iconImageView.layer.masksToBounds = YES;
    [self.contentView addSubview:self.iconImageView];
    [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(UIEdgeInsetsMake(0, 0, 0, 0));
    }];
    
    self.tipsBtn = [[UIButton alloc] init];
    self.tipsBtn.imageEdgeInsets = UIEdgeInsetsMake(0, -4.5, 0, 4.5);
    [self.tipsBtn setAttributedTitle:createAttString(@" ", 15, [UIColor whiteColor]) forState:UIControlStateNormal];
    [self.tipsBtn wb_setImageName:@"report_icon_tips_nor"];
    [self.contentView addSubview:self.tipsBtn];
    [self.tipsBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(15);
        make.top.mas_equalTo(15);
    }];
    
}
@end
