//
//  SMReportOilCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/7.
//

#import "SMReportOilCell.h"


@interface SMReportOilCell()

@property(nonatomic, weak)UILabel *symptomTitleLabel;

@property(nonatomic, weak)UILabel *nursingTitleLabel;
@property(nonatomic, weak)UILabel *oilValueLabel;

@property(nonatomic, strong)UIButton *oneBtn;
@property(nonatomic, strong)UIButton *twoBtn;
@property(nonatomic, strong)UIButton *threeBtn;

@end



@implementation SMReportOilCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    UILabel *oilLabel = [[UILabel alloc] init];
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    _nameValueLabel = oilLabel;
    oilLabel.attributedText = createAttString(@" ", 18, rgba(76, 74, 66, 1));
    [self.contentView addSubview:oilLabel];
    [oilLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(19);
        make.centerX.mas_equalTo(0);
    }];

    UIView *oliLineView = [[UIView alloc] init];
    oliLineView.backgroundColor = rgba(235, 230, 223, 1);
    [self.contentView insertSubview:oliLineView belowSubview:oilLabel];
    [oliLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(oilLabel.mas_bottom).offset(-1);
        make.centerX.equalTo(oilLabel);
        make.height.mas_equalTo(6);
        make.left.equalTo(oilLabel).offset(-10);
        make.right.equalTo(oilLabel).offset(10);
    }];
    
    UIView *bgView = [[UIView alloc] init];
    bgView.backgroundColor = [UIColor whiteColor];
    bgView.layer.borderColor =rgba(255, 217, 204, 1).CGColor;
    bgView.layer.borderWidth =1;
    bgView.layer.cornerRadius = 10;
    bgView.layer.masksToBounds = YES;
    [self.contentView addSubview:bgView];
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.height.mas_equalTo(100);
        make.top.equalTo(oilLabel.mas_bottom).offset(20);
    }];
    
    
    NSMutableAttributedString *mAtt = [[NSMutableAttributedString alloc] init];
    [mAtt appendAttributedString:createAttString(@" ", 30, rgba(255, 124, 78, 1))];
    [mAtt appendAttributedString:createAttString(@"%", 12, rgba(255, 124, 78, 1))];

    UILabel *oilValueLabel = [[UILabel alloc] init];
    _oilValueLabel = oilValueLabel;
    oilValueLabel.backgroundColor = rgba(255, 242, 237, 1);
    oilValueLabel.textAlignment = NSTextAlignmentCenter;
    oilValueLabel.attributedText = mAtt;
    [bgView addSubview:oilValueLabel];
    [oilValueLabel mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(12);
//        make.centerY.mas_equalTo(0);
        make.top.left.bottom.mas_equalTo(0);
        make.width.mas_equalTo(70);
    }];

    CGFloat mw = [UIScreen mainScreen].bounds.size.width;
    CGFloat space = (mw - 40 - 70 - (68*3))/4;
    UIButton *oneBtn = [[UIButton alloc] init];
    _oneBtn = oneBtn;
    [oneBtn setBackgroundImage:[UIImage imageNamed:@"report_bg_qs_nor"] forState:UIControlStateSelected];
    [oneBtn setBackgroundImage:[UIImage imageNamed:@"report_bg_qs_sel"] forState: UIControlStateNormal];
    [oneBtn setAttributedTitle:createAttString(@"缺水", 14, rgba(129, 109, 80, 0.3)) forState:UIControlStateNormal ];
    [oneBtn setAttributedTitle:createAttString(@"缺水", 14, rgba(68, 57, 53, 1)) forState: UIControlStateSelected];
    oneBtn.titleEdgeInsets = UIEdgeInsetsMake(-50, 0, 0, 0);
    [bgView addSubview:oneBtn];
    [oneBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(oilValueLabel.mas_right).offset(space);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(68, 80));
    }];
    
    UIButton *twoBtn = [[UIButton alloc] init];
    _twoBtn = twoBtn;
    [twoBtn setBackgroundImage:[UIImage imageNamed:@"report_bg_qdqs_nor"] forState: UIControlStateSelected];
    [twoBtn setBackgroundImage:[UIImage imageNamed:@"report_bg_qdqs_sel"] forState:UIControlStateNormal];
    [twoBtn setAttributedTitle:createAttString(@"轻度缺水", 14, rgba(129, 109, 80, 0.3)) forState:  UIControlStateNormal];
    [twoBtn setAttributedTitle:createAttString(@"轻度缺水", 14, rgba(68, 57, 53, 1)) forState:UIControlStateSelected];
    twoBtn.titleEdgeInsets = UIEdgeInsetsMake(-50, 0, 0, 0);
    [bgView addSubview:twoBtn];
    [twoBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(oneBtn.mas_right).offset(space);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(68, 80));
    }];
    
    UIButton *threeBtn = [[UIButton alloc] init];
    _threeBtn = threeBtn;
    [threeBtn setBackgroundImage:[UIImage imageNamed:@"report_bg_lh_nor"] forState: UIControlStateSelected];
    [threeBtn setBackgroundImage:[UIImage imageNamed:@"report_bg_lh_sel"] forState:UIControlStateNormal];
    [threeBtn setAttributedTitle:createAttString(@"良好", 14, rgba(129, 109, 80, 0.3)) forState:UIControlStateNormal ];
    [threeBtn setAttributedTitle:createAttString(@"良好", 14, rgba(68, 57, 53, 1)) forState: UIControlStateSelected];
    threeBtn.titleEdgeInsets = UIEdgeInsetsMake(-50, 0, 0, 0);
    [bgView addSubview:threeBtn];
    [threeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(twoBtn.mas_right).offset(space);
        make.centerY.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(68, 80));
    }];
    

//    UIImageView *symptomImageView = [[UIImageView alloc] init];
//    symptomImageView.image = [UIImage imageNamed:@"report_icon_fa_bg"];
//    [self.contentView addSubview:symptomImageView];
//    [symptomImageView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.mas_equalTo(22.5);
//        make.top.equalTo(bgView.mas_bottom).offset(20);
//
//    }];
//
//    UILabel *symptomTitleLabel = [[UILabel alloc] init];
//    _symptomTitleLabel = symptomTitleLabel;
//    symptomTitleLabel.attributedText = createAttString(@"症状描述", 17, rgba(68, 57, 53, 1));
//    [self.contentView addSubview:symptomTitleLabel];
//    [symptomTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.centerY.equalTo(symptomImageView);
//        make.left.equalTo(symptomImageView.mas_right).offset(5);
//
//    }];
//
//    UILabel *symptomValueLabel = [[UILabel alloc] init];
//    symptomValueLabel.numberOfLines = 0;
//    _symptomValueLabel = symptomValueLabel;
//    symptomValueLabel.attributedText = createAttString(@" ", 14,rgba(76, 74, 66, 1));
//    [self.contentView addSubview:symptomValueLabel];
//    [symptomValueLabel mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.top.equalTo(symptomImageView.mas_bottom).offset(13);
//        make.left.mas_equalTo(22.5);
//        make.right.mas_equalTo(-22.5);
//    }];
//
//    UIView *lineView = [[UIView alloc] init];
//    lineView.backgroundColor = rgba(243, 243, 243, 1);
//    [self.contentView addSubview:lineView];
//    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.right.mas_equalTo(0);
//        make.height.mas_equalTo(1);
//        make.top.equalTo(symptomValueLabel.mas_bottom).offset(18);
//    }];


    UIImageView *nursingImageView = [[UIImageView alloc] init];
    nursingImageView.image = [UIImage imageNamed:@"report_icon_fa_bg"];
    [self.contentView addSubview:nursingImageView];
    [nursingImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(22.5);
        make.top.equalTo(bgView.mas_bottom).offset(31);
    }];

    UILabel *nursingTitleLabel = [[UILabel alloc] init];
    _nursingTitleLabel = nursingTitleLabel;
    nursingTitleLabel.attributedText = createAttString(@"护理方法", 17, rgba(68, 57, 53, 1));
    [self.contentView addSubview:nursingTitleLabel];
    [nursingTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(nursingImageView);
        make.left.equalTo(nursingImageView.mas_right).offset(5);
    }];

    UILabel *nursingValueLabel = [[UILabel alloc] init];
    nursingValueLabel.numberOfLines = 0;
    _nursingValueLabel = nursingValueLabel;
    nursingValueLabel.attributedText = createAttString(@"", 14,rgba(76, 74, 66, 1));
    [self.contentView addSubview:nursingValueLabel];
    [nursingValueLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(nursingImageView.mas_bottom).offset(13);
        make.left.mas_equalTo(22.5);
        make.right.mas_equalTo(-22.5);
        make.bottom.mas_equalTo(-28);
    }];

    UIView *twolineView = [[UIView alloc] init];
    twolineView.backgroundColor = rgba(243, 243, 243, 1);
    [self.contentView addSubview:twolineView];
    [twolineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(10);
    }];

}
- (void)updateOil:(NSString *)oil {
    NSMutableAttributedString *mAtt = [[NSMutableAttributedString alloc] init];
    [mAtt appendAttributedString:createAttString(oil, 30, rgba(255, 124, 78, 1))];
    [mAtt appendAttributedString:createAttString(@"%", 12, rgba(255, 124, 78, 1))];
    self.oilValueLabel.attributedText = mAtt;
    
    if (oil.intValue < 45) {
        self.oneBtn.selected = YES;
    }else if (oil.intValue > 55) {
        self.threeBtn.selected = YES;
    } else {
        self.twoBtn.selected = YES;
    }
}
@end
