//
//  SMReportSymptomCell.m
//  SkinMagnifier
//
//  Created by nana on 2021/1/7.
//

#import "SMReportSymptomCell.h"


@interface SMReportSymptomCell()

@end

@implementation SMReportSymptomCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self setupUI];
    }
    return self;
}


- (void)setupUI {
    self.selectionStyle =UITableViewCellSelectionStyleNone;
    self.nameLabel = [[UILabel alloc] init];
    self.nameLabel.attributedText = createAttString(@"敏感", 18, rgba(68, 57, 53, 1));
    [self.contentView addSubview:self.nameLabel];
    [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(25);
    }];
    
    UIView *oliLineView = [[UIView alloc] init];
    oliLineView.backgroundColor = rgba(235, 230, 223, 1);
    [self.contentView insertSubview:oliLineView belowSubview: self.nameLabel];
    [oliLineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.nameLabel.mas_bottom).offset(-1);
        make.centerX.equalTo(self.nameLabel);
        make.height.mas_equalTo(6);
        make.left.equalTo(self.nameLabel).offset(-10);
        make.right.equalTo(self.nameLabel).offset(10);
    }];
    
    self.fenLabel = [[UILabel alloc] init];
    self.fenLabel.textColor =  rgba(68, 57, 53, 1);
    self.fenLabel.font = [UIFont systemFontOfSize:14];
    [self.contentView addSubview:self.fenLabel];
    [self.fenLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.top.equalTo(self.nameLabel.mas_bottom).offset(30);
    }];
    
    UIView *bgView = [[UIView alloc] init];
    bgView.backgroundColor = [UIColor whiteColor];
    bgView.layer.borderColor =rgba(221, 213, 201, 1).CGColor;
    bgView.layer.borderWidth =1;
    bgView.layer.cornerRadius = 10;
    bgView.layer.masksToBounds = YES;
    [self.contentView addSubview:bgView];
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(20);
        make.right.mas_equalTo(-20);
        make.height.mas_equalTo(100);
        make.top.equalTo(self.fenLabel.mas_bottom).offset(20);
    }];
    
    
    UIButton *AIBtn = [[UIButton alloc] init];
    AIBtn.layer.masksToBounds = YES;
    AIBtn.layer.cornerRadius = 10;
    [AIBtn addTarget:self action:@selector(AIBtnClick:) forControlEvents:UIControlEventTouchUpInside];
//    AIBtn.backgroundColor = [UIColor redColor];
    [bgView addSubview:AIBtn];
    _AIBtn = AIBtn;
    [AIBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(68, 68));
        make.left.mas_equalTo(15);
        make.centerY.mas_equalTo(0);
    }];
    UIImageView *aiTipsImageView = [[UIImageView alloc] init];
    aiTipsImageView.image = [UIImage imageNamed:@"report_icon_ai_amplification1"];
    [AIBtn addSubview:aiTipsImageView];
    [aiTipsImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.bottom.mas_equalTo(-7);
    }];
    
    CGFloat mw = [UIScreen mainScreen].bounds.size.width;
    CGFloat space = (mw - 40 -15-68-220)/2;
    
    UIImageView *oneImageView = [[UIImageView alloc] init];
    _oneImageView = oneImageView;
    oneImageView.image = [UIImage imageNamed:@"re_no_ai_bg"];
    [bgView addSubview:oneImageView];
    [oneImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(AIBtn.mas_right).offset(space);
        make.top.equalTo(AIBtn).offset(21);
    }];
    
    UIImageView *twoImageView = [[UIImageView alloc] init];
    _twoImageView = twoImageView;
    twoImageView.image = [UIImage imageNamed:@"re_normal_bg"];
    [bgView addSubview:twoImageView];
    [twoImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(AIBtn.mas_right).offset(space);
        make.top.equalTo(AIBtn).offset(21);
    }];
    
    UIImageView *threeImageView = [[UIImageView alloc] init];
    _threeImageView = threeImageView;
    threeImageView.image = [UIImage imageNamed:@"re_Mild_bg"];
    [bgView addSubview:threeImageView];
    [threeImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(oneImageView).offset(-1);
        make.top.equalTo(AIBtn).offset(21);
    }];
    
    UIImageView *foureImageView = [[UIImageView alloc] init];
    _fourImageView = foureImageView;
    foureImageView.image = [UIImage imageNamed:@"re_Severe_bg"];
    [bgView addSubview:foureImageView];
    [foureImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(oneImageView);
        make.top.equalTo(AIBtn).offset(21);
    }];
    
    UILabel *oneLevelLabel = [[UILabel alloc] init];
    _onelevelLabel = oneLevelLabel;
    oneLevelLabel.text = @"无";
    oneLevelLabel.backgroundColor = [UIColor redColor];
    oneLevelLabel.layer.cornerRadius = 10;
    oneLevelLabel.layer.cornerRadius = 10;
    oneLevelLabel.layer.masksToBounds = YES;
    oneLevelLabel.textAlignment = NSTextAlignmentCenter;
    oneLevelLabel.font = [UIFont systemFontOfSize:12];
    oneLevelLabel.textColor = rgba(222, 215, 205, 1);
    [bgView addSubview:oneLevelLabel];
    [oneLevelLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(twoImageView).offset(-15);
        make.top.equalTo(twoImageView.mas_bottom).offset(2);
        make.size.mas_equalTo(CGSizeMake(30, 20));
    }];
    
    UILabel *twolevelLabel = [[UILabel alloc] init];
    _twolevelLabel = twolevelLabel;
    twolevelLabel.text = @"轻度";
    twolevelLabel.backgroundColor = [UIColor redColor];
    twolevelLabel.layer.cornerRadius = 10;
    twolevelLabel.layer.cornerRadius = 10;
    twolevelLabel.layer.masksToBounds = YES;
    twolevelLabel.textAlignment = NSTextAlignmentCenter;
    twolevelLabel.font = [UIFont systemFontOfSize:12];
    twolevelLabel.textColor = rgba(222, 215, 205, 1);
    [bgView addSubview:twolevelLabel];
    [twolevelLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(twoImageView);
        make.top.equalTo(twoImageView.mas_bottom).offset(2);
        make.size.mas_equalTo(CGSizeMake(43, 20));
    }];
    
    UILabel *threelevelLabel = [[UILabel alloc] init];
    _threelevelLabel = threelevelLabel;
    threelevelLabel.text = @"中度";
    threelevelLabel.backgroundColor = [UIColor redColor];
    threelevelLabel.layer.cornerRadius = 10;
    threelevelLabel.layer.masksToBounds = YES;
    threelevelLabel.textAlignment = NSTextAlignmentCenter;
    threelevelLabel.font = [UIFont systemFontOfSize:12];
    threelevelLabel.textColor = rgba(222, 215, 205, 1);
    [bgView addSubview:threelevelLabel];
    [threelevelLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(threeImageView);
        make.top.equalTo(threeImageView.mas_bottom).offset(2);
        make.size.mas_equalTo(CGSizeMake(43, 20));
    }];
    
    UILabel *fourlevelLabel = [[UILabel alloc] init];
    _fourlevelLabel = fourlevelLabel;
    fourlevelLabel.text = @"重度";
    fourlevelLabel.backgroundColor = [UIColor redColor];
    fourlevelLabel.layer.cornerRadius = 10;
    fourlevelLabel.layer.masksToBounds = YES;
    fourlevelLabel.textAlignment = NSTextAlignmentCenter;

    fourlevelLabel.font = [UIFont systemFontOfSize:12];
    fourlevelLabel.textColor = rgba(222, 215, 205, 1);
    [bgView addSubview:fourlevelLabel];
    [fourlevelLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(foureImageView);
        make.top.equalTo(foureImageView.mas_bottom).offset(2);
        make.size.mas_equalTo(CGSizeMake(43, 20));
    }];
    
    
    UIImageView *nursingImageView = [[UIImageView alloc] init];
    nursingImageView.image = [UIImage imageNamed:@"report_icon_fa_bg"];
    [self.contentView addSubview:nursingImageView];
    [nursingImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(22.5);
        make.top.equalTo(bgView.mas_bottom).offset(31);
    }];

    UILabel *nursingTitleLabel = [[UILabel alloc] init];
    nursingTitleLabel.attributedText = createAttString(@"护理方法", 17, rgba(68, 57, 53, 1));
    [self.contentView addSubview:nursingTitleLabel];
    [nursingTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(nursingImageView);
        make.left.equalTo(nursingImageView.mas_right).offset(5);
    }];
    

    self.fangfaLabel = [[UILabel alloc] init];
    self.fangfaLabel.numberOfLines = 0;
    self.fangfaLabel.attributedText = createAttString(@"  ", 14, rgba(76, 74, 66, 1));
    [self.contentView addSubview: self.fangfaLabel];
    [ self.fangfaLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(nursingTitleLabel.mas_bottom).offset(13);
        make.left.mas_equalTo(22.5);
        make.right.mas_equalTo(-30);
    }];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = rgba(243, 243, 243, 1);
    [self.contentView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.fangfaLabel.mas_bottom).offset(25);
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(11.5);
        make.bottom.mas_equalTo(0);
    }];
}

- (void)AIBtnClick:(UIButton *)btn {
    if (self.AIBtnClickBlock) {
        self.AIBtnClickBlock();
    }
}
@end
