//
//  SMReportViewController.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/18.
//

#import "SMReportViewController.h"
#import "SMReportHeaderCell.h"
#import "SMReportSchemeCell.h"
#import "SMReportImageCell.h"
#import "SMReportOilCell.h"
#import "SMReportProjectCell.h"
#import "SMReportAddProjectView.h"
#import "SMReportAddSchemeView.h"
#import "SMReportEditSchemeView.h"
#import <IQKeyboardManager.h>

#import "SMTempCell.h"
#import "SMReportSymptomCell.h"
#import "SMShowOriginalImageView.h"

#define HeaderSectionNumber (0)

#define AISymptomSectionNumber (1)
#define SchemeSectionNumber (2)
#define ProductSectionNumber (3)

@interface SMReportViewController ()<UITableViewDataSource,UITableViewDelegate>
@property(nonatomic, strong)UILabel *reportTitleLabel;
@property(nonatomic, strong)UITableView *mainView;
@end

@implementation SMReportViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    if (self.navigationController) {
        NSArray *childVC = self.navigationController.viewControllers;
        NSMutableArray *xinVC = [[NSMutableArray alloc] init];
        for (int i = 0 ; i < childVC.count; i++) {
            UIViewController *vc = childVC[i];
            if ([NSStringFromClass([vc class]) isEqualToString:@"SMCreateClientViewController"] || [NSStringFromClass([vc class]) isEqualToString:@"SMTakeImageViewController"] ) {
            }else {
                [xinVC addObject:vc];
            }
        }
        self.navigationController.viewControllers = xinVC;
    }
    
    self.view.backgroundColor = [UIColor whiteColor];
    UILabel *reportTitleLabel = [[UILabel alloc] init];
    reportTitleLabel.textAlignment = NSTextAlignmentCenter;
    NSString *nameString = [NSString stringWithFormat:@"%@_分析报告",self.clinetModel.cname];
    reportTitleLabel.attributedText = createAttString(nameString, 20, rgba(68, 57, 53, 1));
    [self.view addSubview:reportTitleLabel];
    _reportTitleLabel = reportTitleLabel;
    [reportTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(33));
        make.centerX.mas_equalTo(0);
        make.right.mas_equalTo(-70);
        make.left.mas_equalTo(70);
    }];
    
    UILabel *reportTimeLabel = [[UILabel alloc] init];
    reportTimeLabel.attributedText = createAttString(timestampString(self.lrModel.createTime.longLongValue, @"YYYY/MM/dd HH:mm:ss"), 12,rgba(153, 153, 153, 1));
    [self.view addSubview:reportTimeLabel];
    _reportTitleLabel = reportTimeLabel;
    [reportTimeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(reportTitleLabel.mas_bottom).offset(7);
        make.centerX.mas_equalTo(0);
    }];
    
    self.mainView = [[UITableView alloc] init];
    self.mainView.separatorStyle = UITableViewCellSeparatorStyleNone;
    self.mainView.dataSource = self;
    self.mainView.delegate = self;
    [self.mainView registerClass:[SMReportHeaderCell class] forCellReuseIdentifier:NSStringFromClass([SMReportHeaderCell class])];
    
    [self.mainView registerClass:[SMReportSchemeCell class] forCellReuseIdentifier:NSStringFromClass([SMReportSchemeCell class])];
    
    [self.mainView registerClass:[SMReportOilCell class] forCellReuseIdentifier:NSStringFromClass([SMReportOilCell class])];
    
    [self.mainView registerClass:[SMReportProjectCell class] forCellReuseIdentifier:NSStringFromClass([SMReportProjectCell class])];
    [self.mainView registerClass:[SMTempCell class] forCellReuseIdentifier:NSStringFromClass([SMTempCell class])];
    [self.mainView registerClass:[SMReportSymptomCell class] forCellReuseIdentifier:NSStringFromClass([SMReportSymptomCell class])];
    
    [self.view addSubview:self.mainView];
    
    [self.mainView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.top.equalTo(reportTimeLabel.mas_bottom).offset(10);
    }];
    UIButton *schemebtn = [[UIButton alloc] init];
    [schemebtn wb_setImageName:@"report_icon_add"];
    [schemebtn addTarget:self action:@selector(schemebtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:schemebtn];
    [schemebtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(-14.5);
        make.bottom.mas_equalTo(-100);
    }];
    

}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[IQKeyboardManager sharedManager] setEnable:NO];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [[IQKeyboardManager sharedManager] setEnable:YES];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 4;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    if (section == HeaderSectionNumber) {
        return 1;
    }else if (section == SchemeSectionNumber) {
        return self.lrModel.symptomArray.count;
    }else if (section == ProductSectionNumber) {
        return self.lrModel.productArray.count;
    }else if (section == AISymptomSectionNumber) {
        return self.lrModel.AISymptomArray.count;
    }
    return 1;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell ;
    if (indexPath.section == AISymptomSectionNumber) {
        SMLocalReportAIModel *model = self.lrModel.AISymptomArray[indexPath.row];
        if ([model.tagFlag isEqualToString:@"magn_water"]) {
            if ([model.tagValue isEqualToString:@"0"]) {
                SMTempCell *bCell =  [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMTempCell class])];
                cell = bCell;
            }else {
                SMReportOilCell *bCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMReportOilCell class])];
                bCell.nameValueLabel.attributedText =  createAttString(model.tagname, 18, rgba(76, 74, 66, 1));
                bCell.nursingValueLabel.attributedText =  createAttString(model.dermalogicatext,14,rgba(76, 74, 66, 1));
                [bCell updateOil:model.tagValue];
                cell = bCell;
            }
            return  cell;
        }
        
        
        SMReportSymptomCell *bCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMReportSymptomCell class])];

        bCell.nameLabel.attributedText =  createAttString(model.tagname, 18, rgba(76, 74, 66, 1));
        bCell.fangfaLabel.attributedText =  createAttString(model.dermalogicatext,14,rgba(76, 74, 66, 1));
        [bCell.AIBtn sd_setImageWithURL:[NSURL URLWithString:model.aiImageUrl] forState:UIControlStateNormal placeholderImage:[UIImage imageNamed:@"re_Placeholder_img1"]];
        
        bCell.onelevelLabel.text = @"无";
        bCell.twolevelLabel.text = @"轻度";
        bCell.threelevelLabel.text = @"中度";
        bCell.fourlevelLabel.text = @"重度";
        
        bCell.onelevelLabel.textColor = rgba(222, 215, 205, 1);
        bCell.twolevelLabel.textColor = rgba(222, 215, 205, 1);
        bCell.threelevelLabel.textColor = rgba(222, 215, 205, 1);
        bCell.fourlevelLabel.textColor = rgba(222, 215, 205, 1);
        
        bCell.onelevelLabel.backgroundColor = [UIColor clearColor];
        bCell.twolevelLabel.backgroundColor = [UIColor clearColor];
        bCell.threelevelLabel.backgroundColor = [UIColor clearColor];
        bCell.fourlevelLabel.backgroundColor = [UIColor clearColor];
        
        bCell.twoImageView.hidden = YES;
        bCell.threeImageView.hidden = YES;
        bCell.fourImageView.hidden = YES;
        bCell.twoImageView.image = [UIImage imageNamed:@"re_Mild_bg"];
        bCell.threeImageView.image = [UIImage imageNamed:@"re_moderate_bg"];
        bCell.fourImageView.image = [UIImage imageNamed:@"re_Severe_bg"];
        if ([model.tagFlag isEqualToString:@"magn_sebum"]) {
            bCell.onelevelLabel.text = @"";
            bCell.twolevelLabel.text = @"偏少";
            bCell.threelevelLabel.text = @"正常";
            bCell.fourlevelLabel.text = @"偏多";
            int fen = 0;
            if (model.tagValue.doubleValue > 0 && model.tagValue.doubleValue  < 1) {
                fen = 1;
            }else {
                fen = ceilf(model.tagValue.doubleValue);
            }

            bCell.fenLabel.text = [NSString stringWithFormat:@"皮脂面积占比：%d%%",fen];
      //      无：绿色   轻度：黄色   中度：橙色   重度:红色
//            re_normal_bg 绿色
//            re_Severe_bg 红色
//            re_Mild_bg 黄色
            // re_moderate_bg 橙色
            bCell.twoImageView.image = [UIImage imageNamed:@"re_moderate_bg"];
            bCell.threeImageView.image = [UIImage imageNamed:@"re_normal_bg"];
            bCell.fourImageView.image = [UIImage imageNamed:@"re_moderate_bg"];
            if (fen <= 1) {

                bCell.twoImageView.hidden = NO;
                bCell.twolevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.twolevelLabel.textColor = rgba(255, 255, 255, 1);
            }else if (fen <= 9) {
                bCell.threeImageView.hidden = NO;
                bCell.threelevelLabel.backgroundColor = rgba(90, 219, 90, 1);
                bCell.threelevelLabel.textColor = rgba(255, 255, 255, 1);
            }else {
                bCell.fourImageView.hidden = NO;
                bCell.fourlevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.fourlevelLabel.textColor = rgba(255, 255, 255, 1);
            }
            
        }else if ([model.tagFlag isEqualToString:@"magn_sensity"]) {// 敏感：

            int fen = 0;
            if (model.tagValue.doubleValue > 0 && model.tagValue.doubleValue  < 1) {
                fen = 1;
            }else {
                fen = ceilf(model.tagValue.doubleValue);
            }
            bCell.fenLabel.text = [NSString stringWithFormat:@"敏感面积占比：%d%%",fen];
            if (fen == 0) {
                bCell.onelevelLabel.backgroundColor = rgba(90, 219, 90, 1);
                bCell.onelevelLabel.textColor = rgba(255, 255, 255, 1);
            }else if (fen <= 10) {
                bCell.twoImageView.hidden = NO;
                bCell.twolevelLabel.backgroundColor = rgba(253, 188, 50, 1);
                bCell.twolevelLabel.textColor = rgba(255, 255, 255, 1);
            }else if (fen <= 20) {
                bCell.threeImageView.hidden = NO;
                bCell.threelevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.threelevelLabel.textColor = rgba(255, 255, 255, 1);
            }else {
                bCell.fourImageView.hidden = NO;
                bCell.fourlevelLabel.backgroundColor = rgba(255, 85, 25, 1);
                bCell.fourlevelLabel.textColor = rgba(255, 255, 255, 1);
            }
            
        }else if ([model.tagFlag isEqualToString:@"magn_wrinkle"]) {// 纹理：
            bCell.fenLabel.text = [NSString stringWithFormat:@"皱纹数量：%@条",model.tagValue];

            if (model.tagNum.intValue == 0) {
                bCell.onelevelLabel.backgroundColor = rgba(90, 219, 90, 1);
                bCell.onelevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else if (model.tagNum.intValue <=24) {
                bCell.twoImageView.hidden = NO;
                bCell.twolevelLabel.backgroundColor = rgba(253, 188, 50, 1);
                bCell.twolevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else if (model.tagNum.intValue <= 40) {
                bCell.threeImageView.hidden = NO;
                bCell.threelevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.threelevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else {
                bCell.fourImageView.hidden = NO;
                bCell.fourlevelLabel.backgroundColor = rgba(255, 85, 25, 1);
                bCell.fourlevelLabel.textColor = rgba(255, 255, 255, 1);
            }
            
            
        }else if ([model.tagFlag isEqualToString:@"magn_pore_large"]) {// 毛孔粗大： 毛孔堵塞
            bCell.fenLabel.text = [NSString stringWithFormat:@"毛孔粗大数量：%@个",model.tagValue];
            

            if (model.tagNum.intValue == 0) {
                bCell.onelevelLabel.backgroundColor = rgba(90, 219, 90, 1);
                bCell.onelevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else if (model.tagNum.intValue <= 50000) {
                bCell.twoImageView.hidden = NO;
                bCell.twolevelLabel.backgroundColor = rgba(253, 188, 50, 1);
                bCell.twolevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else if (model.tagNum.intValue <= 120000) {
                bCell.threeImageView.hidden = NO;
                bCell.threelevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.threelevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else {
                bCell.fourImageView.hidden = NO;
                bCell.fourlevelLabel.backgroundColor = rgba(255, 85, 25, 1);
                bCell.fourlevelLabel.textColor = rgba(255, 255, 255, 1);
            }
            
        }else if (
                  [model.tagFlag isEqualToString:@"magn_pore_clogging"]  ) {// 毛孔粗大： 毛孔堵塞
                  bCell.fenLabel.text = [NSString stringWithFormat:@"毛孔堵塞数量：%@个",model.tagValue];
            

            if (model.tagNum.intValue == 0) {
                bCell.onelevelLabel.backgroundColor = rgba(90, 219, 90, 1);
                bCell.onelevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else if (model.tagNum.intValue <= 50000) {
                bCell.twoImageView.hidden = NO;
                bCell.twolevelLabel.backgroundColor = rgba(253, 188, 50, 1);
                bCell.twolevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else if (model.tagNum.intValue <= 120000) {
                bCell.threeImageView.hidden = NO;
                bCell.threelevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.threelevelLabel.textColor = rgba(255, 255, 255, 1);
                
            }else {
                bCell.fourImageView.hidden = NO;
                bCell.fourlevelLabel.backgroundColor = rgba(255, 85, 25, 1);
                bCell.fourlevelLabel.textColor = rgba(255, 255, 255, 1);
            }
            
        }else if ([model.tagFlag isEqualToString:@"magn_pigmentation"]) {// 色素沉淀：
            int fen = 0;
            if (model.tagValue.doubleValue > 0 && model.tagValue.doubleValue  < 1) {
                fen = 1;
            }else {
                fen = ceilf(model.tagValue.doubleValue);
            }
            
            bCell.fenLabel.text = [NSString stringWithFormat:@"色沉面积占比：%d%%",fen];
            
            
            if (fen == 0) {
                bCell.onelevelLabel.backgroundColor = rgba(90, 219, 90, 1);
                bCell.onelevelLabel.textColor = rgba(255, 255, 255, 1);
            }else if (fen <= 7) {
                bCell.twoImageView.hidden = NO;
                bCell.twolevelLabel.backgroundColor = rgba(253, 188, 50, 1);
                bCell.twolevelLabel.textColor = rgba(255, 255, 255, 1);
            }else if (fen <= 15) {
                bCell.threeImageView.hidden = NO;
                bCell.threelevelLabel.backgroundColor = rgba(247, 138, 67, 1);
                bCell.threelevelLabel.textColor = rgba(255, 255, 255, 1);
            }else {
                bCell.fourImageView.hidden = NO;
                bCell.fourlevelLabel.backgroundColor = rgba(255, 85, 25, 1);
                bCell.fourlevelLabel.textColor = rgba(255, 255, 255, 1);
            }
            
        }

        @weakify(bCell);
        @weakify(self);
        bCell.AIBtnClickBlock = ^(void){
            @strongify(bCell);
            @strongify(self);
            SMShowOriginalImageView *imgView = [SMShowOriginalImageView new];
            imgView.imgUrlString = model.aiImageUrl;
            [imgView mm_showFrameView:self.view positionView:bCell.AIBtn];
        };
        cell = bCell;
        
        

        
    }else if (indexPath.section == HeaderSectionNumber) {
//        SMReportHeaderCell *bCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMReportHeaderCell class])];

//        [bCell.leidaVivew removeFromSuperview];
        SMReportHeaderCell *bCell = [[SMReportHeaderCell alloc] initWithModel:self.lrModel];
        cell = bCell;
    }else if (indexPath.section == SchemeSectionNumber){
        SMLocalReportSymptomModel *model = self.lrModel.symptomArray[indexPath.row];
        
        SMReportSchemeCell *bCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMReportSchemeCell class])];

        bCell.nameValueLabel.attributedText =  createAttString(model.sName, 18, rgba(76, 74, 66, 1));
//        bCell.symptomValueLabel.attributedText =  createAttString(model.sDescribe,14,rgba(76, 74, 66, 1));
        bCell.nursingValueLabel.attributedText =  createAttString(model.sMethod,14,rgba(76, 74, 66, 1));
        cell = bCell;
    }else if (indexPath.section == ProductSectionNumber){
        SMLocalReportProductModel *model = self.lrModel.productArray[indexPath.row];
        SMReportProjectCell *bCell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([SMReportProjectCell class])];
        bCell.projectTypeBtn.selected = [model.pType isEqualToString:@"2"];

        bCell.iconImageView.selected = [model.pType isEqualToString:@"2"];
        bCell.projectNameLabel.attributedText = createAttString(model.pName, 15, rgba(76, 74, 66, 1));
        cell = bCell;
    }
    return cell;
}

- (nullable UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    if (section == ProductSectionNumber) {
        UIView *view = [[UIView alloc] init];
        view.frame = CGRectMake(0, 0, 40, 20);
        view.backgroundColor = [UIColor whiteColor];
        
        UIButton *btn = [[UIButton alloc] init];
        btn.titleEdgeInsets = UIEdgeInsetsMake(0, 5, 0,-5);
        [btn wb_setImageName:@"report_icon_fa_bg"];
        [btn setAttributedTitle:createAttString(@"推荐项目", 17, rgba(68, 57, 53, 1)) forState:UIControlStateNormal];
        [view addSubview:btn];

        [btn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(20);
            make.centerY.mas_equalTo(0);
        }];
        
        UIButton *addBtn = [[UIButton alloc] init];
        [addBtn addTarget:self action:@selector(addBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [addBtn wb_setImageName:@"report_button_add"];
        [view addSubview:addBtn];
        [addBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(-20);
            make.centerY.mas_equalTo(0);
        }];
        
        return view;
    }
    return nil;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:NO];
    @weakify(self);
    if (indexPath.section == SchemeSectionNumber) {
        SMLocalReportSymptomModel *sModel = self.lrModel.symptomArray[indexPath.row];

        SMReportEditSchemeView *view = [[SMReportEditSchemeView alloc] initWithFrame:self.view.bounds];
        [view updateSname:sModel.sName sDescribe:sModel.sDescribe sMethod:sModel.sMethod];
        [view wb_showRTLFromSuperView:self.view];
        view.saveBlock = ^(NSString * _Nonnull sname, NSString * _Nonnull sDescribe, NSString * _Nonnull sMethod, NSInteger status) {
            @strongify(self);
            
            if (self.netWorkData) {
                if (status == 2) {
                    NSMutableDictionary *pdict = [[NSMutableDictionary alloc] init];
                    pdict[@"aReportLinkAitagnameId"] = sModel.sID;
                    [self.view postFormDataWithUrl:@"/magnifier/report/delReport" params:pdict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                        @strongify(self);
                        if ([JsonData.code isEqualToString:@"200"]) {
                            [self.lrModel.symptomArray removeObjectAtIndex:indexPath.row];
                            [self.mainView reloadData];
                        }else {
                            [SVProgressHUD showErrorWithStatus:@"删除失败"];
                        }
                    }];
                }else if(status == 1) {
                    
      
                        NSMutableDictionary *xDict = [[NSMutableDictionary alloc] init];
                        xDict[@"tagname"] = sname;
                        xDict[@"areasonList"] = @[@{@"reasontext":sDescribe}];
                        xDict[@"adermalogicaList"] = @[@{@"dermalogicatext":sMethod}];
                        xDict[@"magnifierCgid"] = self.lrModel.cgid;
                        xDict[@"areportLinkAitagnameId"] =sModel.sID;
                        xDict[@"systSign"] = @"0";
                        [self.view postJsonWithUrl:@"/magnifier/report/updateReportById" params:xDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                            @strongify(self);
                            if ([JsonData.code isEqualToString:@"200"]) {
                                

                                sModel.sName = sname;
                                sModel.sDescribe = sDescribe;
                                sModel.sMethod = sMethod;

                                
                                [self.mainView reloadData];
                                
                            }else {
                                [SVProgressHUD showErrorWithStatus:@"更新失败"];
                            }
                        }];
                }
            }else {
                NSArray *localDataArray = [[SMLocalReportBManager sharedManager] selectWithCgid:self.lrModel.cgid];
                if (localDataArray.count == 0) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                    return ;
                }
                SMLocalReportModel *localModel = localDataArray.firstObject;
                if ([localModel.uploadLock isEqualToString:@"1"]) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                    return ;
                }
                if (status == 2) {
                    [self.lrModel.symptomArray removeObjectAtIndex:indexPath.row];
                }else if ( status == 1) {
                    sModel.sName = sname;
                    sModel.sDescribe = sDescribe;
                    sModel.sMethod = sMethod;
                }
                [[SMLocalReportBManager sharedManager] updateWithModel:self.lrModel cgid:self.lrModel.cgid];
                [self.mainView reloadData];
            }
        };
    }else if (indexPath.section == ProductSectionNumber) {
        SMLocalReportProductModel *rModel = self.lrModel.productArray[indexPath.row];
        SMReportAddProjectView *view = [[SMReportAddProjectView alloc] init];
        [view updateType:rModel.pType name:rModel.pName];
        [view wb_showFromSuperView:self.view];

        view.saveBlock = ^(NSString * _Nonnull type, NSString * _Nonnull name,NSInteger status) {
            @strongify(self);
            
            if (self.netWorkData) {
                if (status == 2) {
                    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
                    pDict[@"id"] = rModel.pId;
                    [self.view postFormDataWithUrl:@"/magnifier/report/delReportGoods" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                        @strongify(self);
                        if ([JsonData.code isEqualToString:@"200"]) {
                            [self.lrModel.productArray removeObjectAtIndex:indexPath.row];
                        }else {
                            [SVProgressHUD showErrorWithStatus:@"删除失败"];
                        }
                        [self.mainView reloadData];
                    }];
                }else {
                    
                    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
                    pDict[@"goodstype"] = type;
                    pDict[@"goodsname"] = name;
                    pDict[@"magnifierCgid"] = self.lrModel.cgid;
                    pDict[@"id"] = rModel.pId;
                    [self.view postFormDataWithUrl:@"/magnifier/report/saveOrUpdateReportGoods" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                        @strongify(self);
                        if ([JsonData.code isEqualToString:@"200"]) {
                            rModel.pType = type;
                            rModel.pName = name;
                            [self.mainView reloadData];
                        }else {
                            [SVProgressHUD showErrorWithStatus:@"更新失败"];
                        }
                    }];
                    
                }
                
                
            }else {

                NSArray *localDataArray = [[SMLocalReportBManager sharedManager] selectWithCgid:self.lrModel.cgid];
                if (localDataArray.count == 0) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                    return ;
                }
                SMLocalReportModel *localModel = localDataArray.firstObject;
                if ([localModel.uploadLock isEqualToString:@"1"]) {
                    [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                    return ;
                }
                
                if (status == 2) {
                    [self.lrModel.productArray removeObjectAtIndex:indexPath.row];
                }else if ( status == 1) {
                    rModel.pType = type;
                    rModel.pName = name;
                }
                [[SMLocalReportBManager sharedManager] updateWithModel:self.lrModel cgid:self.lrModel.cgid];
                [self.mainView reloadData];
                
            }
 
        };
    }

}
- (void)addBtnClick:(UIButton *)btn {
    SMReportAddProjectView *view = [[SMReportAddProjectView alloc] init];
    [view wb_showFromSuperView:self.view];
    @weakify(self);
    view.saveBlock = ^(NSString * _Nonnull type, NSString * _Nonnull name,NSInteger status) {
        @strongify(self);
        if (self.netWorkData) {
            NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
            pDict[@"goodstype"] = type;
            pDict[@"goodsname"] = name;
            pDict[@"magnifierCgid"] = self.lrModel.cgid;
            [self.view postFormDataWithUrl:@"/magnifier/report/saveOrUpdateReportGoods" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                @strongify(self);
                if ([JsonData.code isEqualToString:@"200"]) {
                    SMLocalReportProductModel *rModel = [[SMLocalReportProductModel alloc] init];
                    rModel.pType = type;
                    rModel.pName = name;
                    rModel.pId = [NSString stringWithFormat:@"%@",((NSDictionary *)JsonData.data)[@"id"]];
                    [self.lrModel.productArray insertObject:rModel atIndex:0];
                    [self.mainView reloadData];
                }else {
                    [SVProgressHUD showErrorWithStatus:@"保存失败"];
                }
            }];
        }else {
            
            NSArray *localDataArray = [[SMLocalReportBManager sharedManager] selectWithCgid:self.lrModel.cgid];
            if (localDataArray.count == 0) {
                [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                return ;
            }
            SMLocalReportModel *localModel = localDataArray.firstObject;
            if ([localModel.uploadLock isEqualToString:@"1"]) {
                [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                return ;
            }
            
            
            SMLocalReportProductModel *rModel = [[SMLocalReportProductModel alloc] init];
            rModel.pType = type;
            rModel.pName = name;
            [self.lrModel.productArray insertObject:rModel atIndex:0];
            [[SMLocalReportBManager sharedManager] updateWithModel:self.lrModel cgid:self.lrModel.cgid];
            [self.mainView reloadData];
        }

    };
}

- (void)schemebtnClick:(UIButton *)btn {
    SMReportAddSchemeView *view = [[SMReportAddSchemeView alloc] initWithFrame:self.view.bounds];
    @weakify(self);
    view.saveBlock = ^(NSString * _Nonnull sName, NSString * _Nonnull sDescribe, NSString * _Nonnull sMethod) {
        @strongify(self);
        if (self.netWorkData) {
            NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
            pDict[@"tagname"] = sName;
            pDict[@"areasonList"] = @[@{@"reasontext":sDescribe}];
            pDict[@"adermalogicaList"] = @[@{@"dermalogicatext":sMethod}];
            pDict[@"magnifierCgid"] = self.lrModel.cgid;
            
            pDict[@"systSign"] = @"0";
            [self.view postJsonWithUrl:@"/magnifier/report/addReport" params:pDict success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
                @strongify(self);
                if ([JsonData.code isEqualToString:@"200"]) {
                    
                    SMLocalReportSymptomModel *rModel = [[SMLocalReportSymptomModel alloc] init];
                    rModel.sName = sName;
                    rModel.sDescribe = sDescribe;
                    rModel.sMethod = sMethod;
                    rModel.sID = [NSString stringWithFormat:@"%@",JsonData.data];
                    [self.lrModel.symptomArray insertObject:rModel atIndex:0];
                    [self.mainView reloadData];
                    
                }else {
                    [SVProgressHUD showErrorWithStatus:@"添加失败"];
                }
            }];
        }else {
            
            NSArray *localDataArray = [[SMLocalReportBManager sharedManager] selectWithCgid:self.lrModel.cgid];
            if (localDataArray.count == 0) {
                [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                return ;
            }
            SMLocalReportModel *localModel = localDataArray.firstObject;
            if ([localModel.uploadLock isEqualToString:@"1"]) {
                [SVProgressHUD showErrorWithStatus:@"本地数据变成网络数据,有网的时候再编辑"];
                return ;
            }
            
            SMLocalReportSymptomModel *rModel = [[SMLocalReportSymptomModel alloc] init];
            rModel.sName = sName;
            rModel.sDescribe = sDescribe;
            rModel.sMethod = sMethod;
            [self.lrModel.symptomArray insertObject:rModel atIndex:0];
            [[SMLocalReportBManager sharedManager] updateWithModel:self.lrModel cgid:self.lrModel.cgid];
            [self.mainView reloadData];
        }
        

    };
    [view wb_showRTLFromSuperView:self.view];
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    if (section == ProductSectionNumber) {
        return 40;
    }
    return 0;
}


@end
