//
//  SMShowOriginalImageView.m
//  SkinMagnifier
//
//  Created by nana on 2021/1/12.
//

#import "SMShowOriginalImageView.h"


@interface SMShowOriginalImageView()
@property(nonatomic, assign)CGRect sRect;
@property(nonatomic, strong)UIImageView *imgView;
@end

@implementation SMShowOriginalImageView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    self.layer.masksToBounds = YES;
    self.backgroundColor = [UIColor blackColor];
    UIControl *ctl =  [[UIControl alloc] init];
    [ctl addTarget:self action:@selector(ctlClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:ctl];
    [ctl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    
    self.imgView = [[UIImageView alloc] init];
//    self.imgView.backgroundColor = rgba(255, 248, 244, 1);
    self.imgView.backgroundColor = [UIColor blackColor];

    [self addSubview:self.imgView];
    CGFloat w = [UIScreen mainScreen].bounds.size.width;
    [self.imgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
//        make.center.mas_equalTo(0);
//        make.width.height.mas_equalTo(w);
    }];
}

- (void)ctlClick:(UIControl *)ctl {
    ctl.userInteractionEnabled = NO;
    [self removeFromSuperview];
}
- (void)setImgUrlString:(NSString *)imgUrlString {
    _imgUrlString = imgUrlString;
    self.imgView.contentMode = UIViewContentModeCenter;
//    self.imgView.backgroundColor = rgba(255, 248, 244, 1);
    @weakify(self);
    [self.imgView sd_setImageWithURL:[NSURL URLWithString:imgUrlString] placeholderImage:nil completed:^(UIImage * _Nullable image, NSError * _Nullable error, SDImageCacheType cacheType, NSURL * _Nullable imageURL) {
        @strongify(self);
        if (image) {
            self.imgView.contentMode = UIViewContentModeScaleAspectFit;
//            self.imgView.backgroundColor = [UIColor blackColor];
        }
    }];
}
- (void)mm_showFrameView:(UIView *)fView positionView:(UIView *)pView {
    
    CGRect xRect = [pView.superview convertRect:pView.frame toView:fView];
    [fView addSubview:self];
    self.frame = xRect;
    self.sRect = xRect;
   
    [UIView animateWithDuration:0.25 animations:^{
  
        self.frame =  [UIScreen mainScreen].bounds;
    }];
}

@end
