//
//  SMTempCell.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/18.
//

#import "SMTempCell.h"

@implementation SMTempCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    self.tipsImageView = [[UIImageView alloc] init];
    self.tipsImageView.image = [UIImage imageNamed:@"report_icon_detected"];
    [self.contentView addSubview:self.tipsImageView];
    [self.tipsImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.mas_equalTo(30);
    }];
    
    self.tipsLabel = [[UILabel alloc] init];
    self.tipsLabel.attributedText = createAttString(@"水份未检测哦~", 12, rgba(153, 153, 153, 1));
    [self.contentView addSubview:self.tipsLabel];
    [self.tipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.mas_equalTo(0);
        make.top.equalTo(self.tipsImageView.mas_bottom).offset(10);
        make.bottom.mas_equalTo(-30);
    }];
    
    UIView *twolineView = [[UIView alloc] init];
    twolineView.backgroundColor = rgba(243, 243, 243, 1);
    [self.contentView addSubview:twolineView];
    [twolineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(10);
    }];
}
@end
