//
//  SMConfigWIFIView.m
//  SkinMagnifier
//
//  Created by nana on 2021/3/26.
//

#import "SMConfigWIFIView.h"
#import "DKSocket.h"
#import "DKCmdTool.h"

@interface SMConfigWIFIView ()

@property(nonatomic, strong)UITextField *wifiNameTView;
@property(nonatomic, strong)UITextField *wifiPwdTView;
@property(nonatomic, strong)UILabel   *configWIFILabel;
@property(nonatomic, strong)DKSocket *socket;
@property(nonatomic, assign)BOOL connectStatus;
@end

@implementation SMConfigWIFIView


- (instancetype)init {
    if (self = [super init]) {
        self.backgroundColor = [UIColor whiteColor];
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.wifiNameTView = [[UITextField alloc] init];
    self.wifiNameTView.placeholder = @"wifi名字";
    self.wifiNameTView.backgroundColor = [UIColor orangeColor];
    [self addSubview:self.wifiNameTView];
    [self.wifiNameTView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(100);
        make.left.mas_equalTo(10);
        make.right.mas_equalTo(-10);
        make.height.mas_equalTo(40);
    }];
    
    self.wifiPwdTView = [[UITextField alloc] init];
    self.wifiPwdTView.placeholder = @"wifi名字";
    self.wifiPwdTView.backgroundColor = [UIColor orangeColor];
    [self addSubview:self.wifiPwdTView];
    [self.wifiPwdTView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.wifiNameTView.mas_bottom).offset(10);
        make.left.mas_equalTo(10);
        make.right.mas_equalTo(-10);
        make.height.mas_equalTo(40);
    }];
    
    UIButton *cfgBtn = [[UIButton alloc] init];
    [cfgBtn setTitle:@"配网" forState:UIControlStateNormal];
    [cfgBtn setBackgroundImage:[UIImage wb_imageWithColor:[UIColor blueColor] size:CGSizeMake(40, 40)] forState:UIControlStateNormal];
    [cfgBtn addTarget:self action:@selector(cfgBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:cfgBtn];
    [cfgBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(10);
        make.right.mas_equalTo(-10);
        make.top.equalTo(self.wifiPwdTView.mas_bottom).offset(10);
        make.height.mas_equalTo(40);
    }];
    

    
    UIButton *checkBtn = [[UIButton alloc] init];
    [checkBtn setTitle:@"查看" forState:UIControlStateNormal];
    [checkBtn setBackgroundImage:[UIImage wb_imageWithColor:[UIColor blueColor] size:CGSizeMake(40, 40)] forState:UIControlStateNormal];
    [checkBtn addTarget:self action:@selector(checkBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:checkBtn];
    [checkBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(10);
        make.right.mas_equalTo(-10);
        make.top.equalTo(cfgBtn.mas_bottom).offset(50);
        make.height.mas_equalTo(40);
    }];
    
    self.configWIFILabel = [[UILabel alloc] init];
    self.configWIFILabel.numberOfLines = 0;
    self.configWIFILabel.text = @"12312";
    self.configWIFILabel.textColor = [UIColor blueColor];
    [self addSubview:self.configWIFILabel];
    [self.configWIFILabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(10);
        make.right.mas_equalTo(-10);
        make.top.equalTo(checkBtn.mas_bottom).offset(10);
        make.height.mas_equalTo(200);
    }];
    
    self.socket = [[DKSocket alloc] init];
    [self.socket connectHost:@"192.168.168.1" port:8899];
    @weakify(self);
    self.socket.checkNetWorkBlock = ^(BOOL networkStaus) {
        @strongify(self);
        self.connectStatus = networkStaus;
    };
    
}

- (void)checkBtnClick:(UIButton *)btn {
    if (self.connectStatus == NO) {
        [SVProgressHUD showErrorWithStatus:@"未脸上服务器"];
        return;
    }
    self.configWIFILabel.text = @"";
    NSData *sendData =sendGetWIFIInfo();
    @weakify(self);
    [self.socket sendData:sendData completeBlock:^(NSData * _Nonnull response) {
        @strongify(self);
        if (response) {
           NSString *xxString = [[NSString alloc] initWithData:response encoding:NSUTF8StringEncoding];
            NSLog(@"ss %@",xxString);
           self.configWIFILabel.text = xxString;
        }
    }];
}
- (void)cfgBtnClick:(UIButton *)btn {
    if (self.connectStatus == NO) {
        [SVProgressHUD showErrorWithStatus:@"未脸上服务器"];
        return;
    }
    if (!self.wifiNameTView.text.length ) {
        [SVProgressHUD showErrorWithStatus:@"Wi-Fi账号"];
        return;
    }
    if (!self.wifiPwdTView.text.length ) {
        [SVProgressHUD showErrorWithStatus:@"Wi-Fi密码"];
        return;
    }
    
    NSData *sendData = sendSetWIFI(self.wifiNameTView.text, self.wifiPwdTView.text);
    @weakify(self);
    [self.socket sendData:sendData completeBlock:^(NSData * _Nonnull response) {
        @strongify(self);
        if (response) {
            [SVProgressHUD showSuccessWithStatus:@"发送成功准备重启"];
        }else {
            [SVProgressHUD showSuccessWithStatus:@"发送 失败"];
        }
    }];
}
@end
