//
//  SMHomeViewController.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMHomeViewController.h"
#import "SMLoginView.h"
#import "SMLinkDeviceView.h"
#import "SMClientViewController.h"
#import "SMEditShopInfoViewController.h"
#import "SMReportViewController.h"
#import "SMCreateClientViewController.h"
#import "SMLinkDeviceView.h"
#import "SMCheckOilBGView.h"
#import "SMConfigWIFIView.h"

@interface SMHomeViewController()

@property(nonatomic, strong)UILabel *shopNameLabel;
@property(nonatomic, strong)UILabel *shopIdLabel;
@property(nonatomic, strong)SMLoginView *loginView;


@property (nonatomic,assign)BOOL shopInfoComplete;



@end

@implementation SMHomeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
//    [SMAIImageTool piZhiDuSheWithRiGuangImg:[UIImage imageNamed:@"111"]];
    
    UIImageView *bgImageView = [[UIImageView alloc] init];
    bgImageView.image = [UIImage wb_biliImageName:@"home_bg"];
    bgImageView.contentMode =UIViewContentModeScaleAspectFill ;
    [self.view addSubview:bgImageView];
    [bgImageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(safaTop(122.5));
        make.centerX.mas_equalTo(0);
        make.size.mas_equalTo(biliSize(318, 413));
    }];

    
    UILabel *shopNameLabel = [[UILabel alloc] init];
    _shopNameLabel = shopNameLabel;
    [self.view addSubview:shopNameLabel];
    shopNameLabel.attributedText = createAttString(@"深圳南山区天利名城店", 19, rgba(76, 74, 66, 1));
    [shopNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(bgImageView);
        make.top.mas_equalTo( safaTop(53) );
        make.right.mas_equalTo(-100);
    }];
    
    UILabel *shopidLabel = [[UILabel alloc] init];
    _shopIdLabel = shopidLabel;
    [self.view addSubview:shopidLabel];

    [shopidLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(bgImageView);
        make.top.mas_equalTo(safaTop(79) );
    }];
    
    UIButton *showBtn = [[UIButton alloc] init];
    [showBtn addTarget:self action:@selector(showBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [showBtn wb_setImageName:@"home_tool_icon_clas"];
    [self.view addSubview:showBtn];
    [showBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo( safaTop(50) );
        make.right.mas_equalTo(-22);
    }];
    
    UIButton *clientBtn = [[UIButton alloc] init];
    [clientBtn wb_setImageName:@"home_icon_xyp"];
    [clientBtn setAttributedTitle:createAttString(@"档案列表", 14, rgba(76, 74, 66, 1)) forState:UIControlStateNormal];
    clientBtn.imageEdgeInsets = UIEdgeInsetsMake(0, -4.5, 0, 4.5);
    [clientBtn wb_setRightImage];
    [clientBtn addTarget:self action:@selector(clientClick:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:clientBtn];
    [clientBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo( safaBottom(-101.5));
        make.centerX.mas_equalTo(0);
    }];
    
    UIButton *createBtn = [[UIButton alloc] init];
   
    [createBtn setAttributedTitle:createAttString(@"新建档案", 17,rgba(254, 254, 255, 1)) forState:UIControlStateNormal];
    [createBtn addTarget:self action:@selector(createBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [createBtn setBackgroundImage:[[UIImage wb_imageWithColor:rgba(255, 124, 78, 1) size:CGSizeMake(225.5, 45)] sd_roundedCornerImageWithRadius:45/2.0 corners:0xff borderWidth:0 borderColor:rgba(0, 0, 0, 0)]  forState:UIControlStateNormal];
    [createBtn wb_setImageName:@"home_icon_personal"];
    [self.view addSubview:createBtn];
    [createBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(safaBottom(-37.5));
        make.centerX.mas_equalTo(0);
    }];
    
    
    SMLoginView *lView = [[SMLoginView alloc] init];
    _loginView = lView;
    @weakify(lView);
    @weakify(self);
    lView.loginBlock = ^(NSString *account ,NSString *dmname){
        @strongify(lView);
        @strongify(self);
        [lView removeFromSuperview];
        
        self.shopIdLabel.attributedText = createAttString(account, 12, rgba(153, 153, 153, 1));
        self.shopNameLabel.attributedText = createAttString(dmname, 18, rgba(76, 74, 66, 1));
        [self requestData ];
    };
    lView.frame =self.view.bounds;
    [self.view addSubview:lView];
    

//    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
//        SMLinkDeviceView *smView = [[SMLinkDeviceView alloc] init];
//        [smView wb_showFromSuperView:self.view];
//    });

    
}



- (void)requestData {
    NSMutableDictionary *pDict = [[NSMutableDictionary alloc] init];
    pDict[@"mid"] = [SMGlobalModel share].mid;
    @weakify(self);
    [self.view postFormDataWithUrl:@"/magnifier/member/verifyMemberInfo" params:pDict showHUD:NO success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        @strongify(self);
        self.shopInfoComplete = [((NSDictionary *)JsonData.data)[@"info"] intValue];
        [SMGlobalModel share].shopInfoComplete = self.shopInfoComplete;
        if (!self.shopInfoComplete) {
            [self alertEditShop];
        }
    }];
}

- (void)createBtnClick:(UIButton *)btn {
    
    if (self.shopInfoComplete) {
        SMCreateClientViewController *vc = [[SMCreateClientViewController alloc] init];
        [self.navigationController pushViewController:vc animated:YES];
    }else {
        [self alertEditShop];
    }

}
- (void)clientClick:(UIButton *)btn {
    
    
    if (self.shopInfoComplete) {
        SMClientViewController *vc = [[SMClientViewController alloc] init];
        [self.navigationController pushViewController:vc animated:YES];
    }else {
        [self alertEditShop];
    }

    

}

- (void)alertEditShop {
    
    //1.创建UIAlertControl
       UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"编辑门店信息" message:@"" preferredStyle:UIAlertControllerStyleAlert];
       /*
        参数说明：
        Title:弹框的标题
        message:弹框的消息内容
        preferredStyle:弹框样式：UIAlertControllerStyleAlert
        */
       
       //2.添加按钮动作
       //2.1 确认按钮
       UIAlertAction *conform = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {

           [self pushEditCV];
             
       }];
     
    UIAlertAction *cancleAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {

          
    }];
   
    
       //3.将动作按钮 添加到控制器中

    [alert addAction:cancleAction];
    [alert addAction:conform];
       
       //4.显示弹框
       [self presentViewController:alert animated:YES completion:nil];
    
    
}
- (void)pushEditCV {
    SMEditShopInfoViewController *vc = [[SMEditShopInfoViewController alloc] init];

    [self.navigationController pushViewController:vc animated:YES];
    @weakify(self);
    vc.saveBlock = ^(NSString * _Nonnull dname) {
        @strongify(self);
        self.shopNameLabel.text = dname;
        self.shopInfoComplete = YES;
        [SMGlobalModel share].shopInfoComplete = self.shopInfoComplete;
    };

}

- (void)showBtnClick:(UIButton *)btn {



    UIView *showView = [[UIView alloc] init];
    showView.backgroundColor = [UIColor whiteColor];
    showView.layer.cornerRadius = 5;
    showView.layer.masksToBounds = YES;
    //,连接设备 home_pop_lj
    NSArray *iconArray = [@"home_pop_bj,home_pop_esc,home_pop_esc" componentsSeparatedByString:@","];
    NSArray *titleArray = [@"编辑信息,退出登录,配网" componentsSeparatedByString:@","];
    for (int i = 0 ; i < iconArray.count; i++) {
        NSString *titleString = titleArray[i];
        NSString *iconString = iconArray[i];
        UIButton *btn  = [[UIButton alloc] init];
        btn.imageEdgeInsets = UIEdgeInsetsMake(0, -7.5, 0, 7.5);
        btn.titleEdgeInsets = UIEdgeInsetsMake(0, 7.5, 0, -7.5);
        btn.tag = 1650+i;
        [btn addTarget:self action:@selector(tagBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [btn wb_setImageName:iconString];
        [btn setAttributedTitle:createAttString(titleString, 14, rgba(75, 74, 70, 1)) forState:UIControlStateNormal];
        [showView addSubview:btn];
        btn.frame = CGRectMake(0, i*52, 127, 51);
        
        UIView *lineView = [[UIView alloc] init];
        lineView.backgroundColor = rgba(229, 229, 229, 1);
        [showView addSubview:lineView];
        lineView.frame = CGRectMake(20, (i+1)*53, 127-40, 1);
    }
    
    [showView alertToView:btn Postion:3 vsize:CGSizeMake(127, 157)];
}

- (void)tagBtnClick:(UIButton *)btn {
    [btn alertDisMiss];
    int indexID = (int)btn.tag - 1650;
    if (indexID == 0) {

        [self pushEditCV];
    }else if (indexID == 1) {
        [self loginOut];
//        SMLinkDeviceView *smView = [[SMLinkDeviceView alloc] init];
//        [smView wb_showFromSuperView:self.view];
    }else if (indexID == 2) {
        NSLog(@"配网");
        SMConfigWIFIView *smView = [[SMConfigWIFIView alloc] init];
        [smView wb_showFromSuperView:self.view];
        
        UIButton *canBtn = [[UIButton alloc] init];
        [canBtn setTitle:@"返回" forState:UIControlStateNormal];
        [canBtn setBackgroundImage:[UIImage wb_imageWithColor:[UIColor blueColor]] forState:UIControlStateNormal];
        [canBtn addTarget:smView action:@selector(wb_disMiss) forControlEvents:UIControlEventTouchUpInside];
        [smView addSubview:canBtn];
        [canBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(40);
            make.left.mas_equalTo(40);
            make.size.mas_equalTo(CGSizeMake(80, 40));
        }];
        
        
    }
}

- (void)loginOut {
    //1.创建UIAlertControler
       UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"退出登录" message:@"" preferredStyle:UIAlertControllerStyleAlert];
       /*
        参数说明：
        Title:弹框的标题
        message:弹框的消息内容
        preferredStyle:弹框样式：UIAlertControllerStyleAlert
        */
       
       //2.添加按钮动作
       //2.1 确认按钮
       UIAlertAction *conform = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {

           [self.loginView wb_showFromSuperView:self.view];
             
       }];
     
    UIAlertAction *cancleAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {

          
    }];
   
    
       //3.将动作按钮 添加到控制器中

    [alert addAction:cancleAction];
    [alert addAction:conform];
       
       //4.显示弹框
       [self presentViewController:alert animated:YES completion:nil];
}
@end
