//
//  DKCmdTool.h
//  DKWF_Example
//
//  Created by nana on 2020/7/3.
//  Copyright © 2020 304635659@qq.com. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, JFDeviceSendCommand) {
    JFDeviceSendCommandLightsRG = 0,                //日光模式
    JFDeviceSendCommandLightsJXPZ,                  //交叉偏振模式
    JFDeviceSendCommandLightsPHPZ,                  //平衡偏振模式
    JFDeviceSendCommandLightsUV,                    //UV灯光模式
    JFDeviceSendCommandLightsOFF,                   //关灯
    JFDeviceSendCommandLightsCurrent,               //灯光当前模式
    JFDeviceSendCommandBatteryLevel,                //电池电量
    JFDeviceSendCommandFirmwareVersion,              //固件版本
    
    JFDeviceRecvCommandPhotograph,                    //拍照
    JFDeviceRecvCommandCheckWaterOil,                      //检测水油
    JFDeviceRecvCommandHaveWaterOil,                      //是否有水油模块
    JFDeviceRecvCommandXiaoYanWaterOil,                    //是否有水油模块
    JFDeviceRecvCommandXiaoYanHeightWaterOil                      //是否有水油模块
};

typedef NS_ENUM(NSInteger, JFDeviceConfig) {
    JFDeviceConfigScanWiFI= 0,                      //扫描WiFi
    JFDeviceConfigSetWiFI,                          //设置WiFi账号密码
    JFDeviceConfigGetWiFI,                          //获取WiFi账号密码
    JFDeviceConfigSetCameraFPS,                     //设置相机帧数
    JFDeviceConfigSetCameraSessionPreset,           //设置相机分辨率
    JFDeviceConfigGetCameraSessionPresetFPS         //设置相机分辨率
};



@interface DKCmdTool : NSObject
/// 发送cmd
NSData *dataWithCmd(JFDeviceSendCommand cmd);
///  接收数据解析
bool cmdWithData(NSData *inData,int *outValue, JFDeviceSendCommand *cmd);

unsigned int CRC_16_Check(NSData *databuf);

/// 发送 扫描周围WiFi
NSData *sendScanWIFI();
/// 发送 配置 硬件设备连网的 WiFi 账号 和密码,  如果WiFi 没有 密码 WifiPwd = @""
NSData *sendSetWIFI(NSString *wifiName ,NSString *WifiPwd );
/// 获取硬件连网的账号和密码
NSData *sendGetWIFIInfo();
/// 发送配置硬件相机的帧数 帧数范围 10 -- 25
NSData *sendSetCameraFPS(int FPS);
/// 发送配置硬件相机的分辨率  分辨率选项为 640x480 800x600 1280x720 1920x1080
NSData *sendSetCameraResolutionRatio(NSString *rr) ;
/// 获取 硬件相机 的分辨率 和帧数
NSData *sendGetCameraInfo();



@end

NS_ASSUME_NONNULL_END
