//
//  JFBaseModel.m
//  JFFD
//
//  Created by nana on 2020/1/2.
//  Copyright © 2020 idankee. All rights reserved.
//

#import "JFBaseModel.h"
#import <objc/runtime.h>

@implementation JFBaseModel

+(NSDictionary *)mj_replacedKeyFromPropertyName {
    return @{@"ID" : @"id"};
}

 - (instancetype)init {
    if (self = [super init]) {
        
        unsigned int count;// 记录属性个数
        Ivar *ivarList = class_copyIvarList([self class], &count);
        
        for (int i = 0; i < count; i++) {
            Ivar ivar = ivarList[i];
            NSString *type = [NSString  stringWithUTF8String:ivar_getTypeEncoding(ivar)];
            NSString *name = [NSString  stringWithUTF8String:ivar_getName(ivar)];
            if (type.length <2) {
                [self setValue:@0 forKey:name];
            }else {
               type = [type stringByReplacingOccurrencesOfString:@"@" withString:@""];
               type = [type stringByReplacingOccurrencesOfString:@"\"" withString:@""];
                [self setValue:[[NSClassFromString(type) alloc] init] forKey:name];
            }

        }
        free(ivarList);
        
    }
    return self;
}

#ifdef DEBUG
- (NSString *)description {

    NSMutableString* text = [NSMutableString stringWithFormat:@"\n<%@>\n", [self class]];
    NSArray* properties = [self filterPropertys];
    [properties enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stop) {
        NSString* key = (NSString*)obj;
        id value = [self valueForKey:key];
        NSString* valueDescription = (value)?[value description]:@"(null)";
        valueDescription = [valueDescription stringByReplacingOccurrencesOfString:@"\n" withString:@"\n   "];
        [text appendFormat:@"   [%@][%@]: %@ \n", key,[value class], valueDescription];
    }];
    [text appendFormat:@"</%@>", [self class]];;
    return text;
    
}

- (NSArray *)filterPropertys
{
    NSMutableArray* props = [NSMutableArray array];
    unsigned int count;
    objc_property_t *properties = class_copyPropertyList([self class], &count);
    for(int i = 0; i < count; i++)
    {
        objc_property_t property = properties[i];
        const char* char_f =property_getName(property);
        NSString *propertyName = [NSString stringWithUTF8String:char_f];
        [props addObject:propertyName];
    }
    free(properties);
    return props;
}
#endif
@end
