//
//  MTRAreaPickView.m
//  Metis
//
//  Created by wb on 2019/9/26.
//  Copyright © 2019 曾凌坤. All rights reserved.
//

#import "MTRAreaPickView.h"
#import "MTRegisterAreaModel.h"
#import <MJExtension/MJExtension.h>

@interface MTRAreaPickView()<UIPickerViewDataSource,UIPickerViewDelegate>

@property(nonatomic, strong)UIPickerView *areaView;
@property(nonatomic, strong)NSArray<MTRegisterAreaModel *> *dataArray;
/// 省份选择 记录
@property (nonatomic,assign) NSInteger provinceIndex;
/// 市选择 记录
@property (nonatomic,assign) NSInteger cityIndex;
/// 区选择 记录
@property (nonatomic,assign) NSInteger districtIndex;

@end


@implementation MTRAreaPickView

- (instancetype)init {
    if (self = [super init]) {
        [self setupUI];
        [self loadData];
    }
    return self;
}

- (void)loadData {
    @weakify(self);
    static NSArray *dataArray;
    if (dataArray) {
        self.dataArray = dataArray;
        [self.areaView reloadAllComponents];
        return ;
    }
    [self postFormDataWithUrl:@"/magnifier/member/findArea" params:nil success:^(NSDictionary * _Nonnull responseObject, JFResponseModel * _Nonnull JsonData) {
        @strongify(self);
        if ([JsonData.data  isKindOfClass:[NSArray class]]) {
            self.dataArray = [MTRegisterAreaModel mj_objectArrayWithKeyValuesArray:JsonData.data];
            dataArray = self.dataArray;
            [self.areaView reloadAllComponents];
        }
    }];
//    [DKNetworkTools post:@"publicAuth/findArea" params:@{}.mutableCopy networkHUD:0 target:self success:^(DKStatusModel *jsonData) {
//        @strongify(self);
//        if ([jsonData.records  isKindOfClass:[NSArray class]]) {
//            self.dataArray = [MTRegisterAreaModel mj_objectArrayWithKeyValuesArray:jsonData.records];
//            [self.areaView reloadAllComponents];
//        }
//    } failure:^(NSError *error) {
//
//    }];
    
}
- (void)setupUI {
    
    self.backgroundColor =rgba(0, 0, 0, 0.34);
    UIControl *ctl = [[UIControl alloc] init];
    [ctl addTarget:self action:@selector(dismiss) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:ctl];
    [ctl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.right.mas_equalTo(0);
    }];
    
    

    
    self.areaView = [[UIPickerView alloc] init];
    self.areaView.dataSource =self;
    self.areaView.delegate = self;
    self.areaView.backgroundColor =[UIColor whiteColor];
    [self addSubview:self.areaView];
    [self.areaView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.bottom.right.mas_equalTo(0);
        make.height.mas_equalTo(240);
    }];
    
    UIView *bgView = [[UIView alloc] init];
    bgView.backgroundColor =[UIColor whiteColor];
    [self addSubview:bgView];
    [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.mas_equalTo(0);
        make.height.mas_equalTo(40);
        make.bottom.equalTo(self.areaView.mas_top);
    }];
    
    UIButton *cancelBtn = [[UIButton alloc] init];
//    [cancelBtn setTitle: (@"取消") textColor:[UIColor whiteColor] font:kFontSize(14) forState:UIControlStateNormal];
    [cancelBtn setAttributedTitle:createAttString(@"取消", 14, [UIColor blackColor]) forState:UIControlStateNormal];
    [cancelBtn addTarget:self action:@selector(cancelBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:cancelBtn];
    [cancelBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(0);
        make.bottom.equalTo(self.areaView.mas_top);
        make.size.mas_equalTo(CGSizeMake(60, 40));
    }];
    
    UIButton *saveBtn = [[UIButton alloc] init];

    [saveBtn setAttributedTitle:createAttString(@"完成", 14, [UIColor blackColor]) forState:UIControlStateNormal];
    [saveBtn addTarget:self action:@selector(saveBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:saveBtn];
    [saveBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(0);
        make.bottom.equalTo(self.areaView.mas_top);
        make.size.mas_equalTo(CGSizeMake(60, 40));
    }];
    UIView *lineView = [[UIView alloc] init];
    lineView.backgroundColor = [UIColor blackColor];
    [self.areaView addSubview:lineView];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.mas_equalTo(0);
        make.height.mas_equalTo(0.5);
//        make.top.equalTo(lineView.mas_bottom);
    }];
}
- (void)cancelBtnClick:(UIButton *)btn {
    [self dismiss];
}

- (void)saveBtnClick:(UIButton *)btn {
    
    if (self.selectCityBlock) {

        NSString * address = @"";
        NSString *fristName = @"";
        if (_provinceIndex > 1) {
            fristName = self.dataArray.count > _provinceIndex ? self.dataArray[_provinceIndex].name : @"";
        }

        address = [NSString stringWithFormat:@"%@%@%@",fristName, self.dataArray.count > _provinceIndex && self.dataArray[_provinceIndex].childs.count > _cityIndex ? self.dataArray[_provinceIndex].childs[_cityIndex].name : @"",self.dataArray.count > _provinceIndex && self.dataArray[_provinceIndex].childs.count > _cityIndex && self.dataArray[_provinceIndex].childs[_cityIndex].childs.count > _districtIndex ? self.dataArray[_provinceIndex].childs[_cityIndex].childs[_districtIndex].name : @""];

        self.selectCityBlock(self.dataArray.count > _provinceIndex ? self.dataArray[_provinceIndex].ID : 0, self.dataArray.count > _provinceIndex && self.dataArray[_provinceIndex].childs.count > _cityIndex ? self.dataArray[_provinceIndex].childs[_cityIndex].ID : 0, self.dataArray.count > _provinceIndex && self.dataArray[_provinceIndex].childs.count > _cityIndex && self.dataArray[_provinceIndex].childs[_cityIndex].childs.count ? self.dataArray[_provinceIndex].childs[_cityIndex].childs[_districtIndex].ID : 0,address);
    }
    [self dismiss];
}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView {
    return 3;
}


- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
    if(component == 0){
        return self.dataArray.count;
    }
    else if (component == 1){
        return self.dataArray[_provinceIndex].childs.count;
    }
    else{
        return self.dataArray[_provinceIndex].childs[_cityIndex].childs.count;
    }
}
- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component {
    return self.bounds.size.width /3;
}


// 返回每一行的内容
-(NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
     [pickerView setValue:[UIColor blackColor] forKey:@"textColor"];
    if(component == 0){
        return self.dataArray[row].name;
    }
    else if (component == 1){
        return self.dataArray[_provinceIndex].childs[row].name;
    }
    else{
        return self.dataArray[_provinceIndex].childs[_cityIndex].childs[row].name;
    }
}


// 滑动或点击选择，确认pickerView选中结果
-(void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    
    if(component == 0){
        _provinceIndex = row;
        _cityIndex = 0;
        _districtIndex = 0;
        [self.areaView reloadAllComponents];

    }
    else if (component == 1){
        _cityIndex = row;
        _districtIndex = 0;
        
        [self.areaView reloadAllComponents];
    }
    else{
        _districtIndex = row;
    }
    
    // 重置当前选中项
    [self resetPickerSelectRow];
}


-(void)resetPickerSelectRow
{
    [self.areaView selectRow:_provinceIndex inComponent:0 animated:YES];
    [self.areaView selectRow:_cityIndex inComponent:1 animated:YES];
    [self.areaView selectRow:_districtIndex inComponent:2 animated:YES];
    
    
}

- (void)show {
    if (self.dataArray == nil) {
        [self loadData];
    }
    UIWindow *wind = [UIApplication sharedApplication].keyWindow;
    self.frame = wind.bounds;
    [wind addSubview:self];
}
- (void)dismiss {
    [self removeFromSuperview];
}
@end
