//
//  SMDownView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/4.
//

#import "SMDownView.h"


@interface SMDownView()
@property(nonatomic, assign)CGFloat startY;

@end
@implementation SMDownView


- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

-(void)setupUI {
    UILongPressGestureRecognizer *longTap = [[UILongPressGestureRecognizer alloc] initWithTarget:self action: @selector(longTapClick:)];
    longTap.minimumPressDuration = 0;
    [self addGestureRecognizer:longTap];
}

- (void)longTapClick:(UILongPressGestureRecognizer *)tap {
   UIWindow *window =   [[[UIApplication sharedApplication] delegate] window];
    CGPoint p = [tap locationInView:window];

    
    CGRect sFrame = self.superview.frame;
    switch (tap.state) {
        case UIGestureRecognizerStateBegan:
            self.startY = p.y;
            break;
        case UIGestureRecognizerStateEnded:
        {

            
            [UIView animateWithDuration:0.25 animations:^{
                CGFloat y = 0;
                if (p.y > 300) {
                    y = window.bounds.size.height;
                }
                self.superview.frame = CGRectMake(sFrame.origin.x, y, sFrame.size.width, sFrame.size.height);
            }];
       
            break;
        }
        default:

            self.superview.frame = CGRectMake(0, p.y-self.startY, sFrame.size.width, sFrame.size.height);
            break;
    }
}

@end
