//
//  SMLocalReportModel.h
//  SkinMagnifier
//
//  Created by nana on 2020/12/7.
//

#import "JFBaseModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface SMLocalReportImageModel : JFBaseModel
///  图片类型
@property(nonatomic, strong)NSString *iType;
///  图片类型名字
@property(nonatomic, strong)NSString *iname;
/// 图片地址
@property(nonatomic, strong)NSString *iURL;
@end

@interface SMLocalReportSymptomModel : JFBaseModel
/// 症状名字
@property(nonatomic, strong)NSString *sID;
/// 症状名字
@property(nonatomic, strong)NSString *sName;
/// 症状描述
@property(nonatomic, strong)NSString *sDescribe;
/// 症状描述
@property(nonatomic, strong)NSString *sMethod;
@end

@interface SMLocalReportProductModel : JFBaseModel
/// 产品类型 ：1-仪器 2-产品',
@property(nonatomic, strong)NSString *pType;
/// 产品名字
@property(nonatomic, strong)NSString *pName;
/// 产品ID
@property(nonatomic, strong)NSString *pId;
@end
@interface SMLocalReportOilModel : JFBaseModel
/// 症状名字
@property(nonatomic, strong)NSString *ofen;
/// 症状名字
@property(nonatomic, strong)NSString *oName;
/// 症状描述
@property(nonatomic, strong)NSString *oDescribe;
/// 症状描述
@property(nonatomic, strong)NSString *oMethod;

@end

@interface SMLocalReportAIModel : JFBaseModel
/// 肌肤放大镜案例ID
@property(nonatomic, strong)NSString *aReportLinkAitagnameId;
/// 症状标志名（* 水份：magn_water； 敏感：magn_sensity；纹理：magn_wrinkle； 毛孔堵塞：magn_pore_clogging；毛孔粗大：magn_pore_large；色素沉淀：magn_pigmentation；皮脂：magn_sebum；）与服务端一一对应，不可修改
@property(nonatomic, strong)NSString *tagFlag;
///症状值
@property(nonatomic, strong)NSString *tagValue;
///AI图片路径
@property(nonatomic, strong)NSString *aiImageUrl;
///水肤案例组id
@property(nonatomic, strong)NSString *magnCgid;
///水肤水肤症状名
@property(nonatomic, strong)NSString *tagname;
///护理方法
@property(nonatomic, strong)NSString *dermalogicatext;
///症状值2
@property(nonatomic, strong)NSString *tagNum;
@end

@interface SMLocalReportModel : JFBaseModel

@property(nonatomic, assign)NSInteger ID;
/// 用户ID
@property(nonatomic, strong)NSString *mid;
/// 顾客ID
@property(nonatomic, strong)NSString *cid;
/// 案例组ID
@property(nonatomic, strong)NSString *cgid;
/// 部位
@property(nonatomic, strong)NSString *iposition;
/// 水份
@property(nonatomic, strong)SMLocalReportOilModel *moisture;
/// 图片数组
@property(nonatomic, strong)NSMutableArray *imageArray;
/// 症状数组
@property(nonatomic, strong)NSMutableArray *symptomArray;
/// AI症状数组
@property(nonatomic, strong)NSMutableArray *AISymptomArray;
/// 产品数组
@property(nonatomic, strong)NSMutableArray *productArray;
/// 水份
@property(nonatomic, strong)NSString *createTime;
///
@property(nonatomic, strong)NSString *uploadLock;
@end

NS_ASSUME_NONNULL_END
