//
//  SMSearchBar.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/6.
//

#import "SMSearchBar.h"


@interface SMSearchBar()
@property(nonatomic, strong)UIButton *btnPlaceholder;
@property(nonatomic, strong)UIButton *cancleBtn;
@end

@implementation SMSearchBar

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {

    self.inputTF = [[UITextField alloc] init];
    self.inputTF.backgroundColor = rgba(247, 247, 248, 1);;
    self.inputTF.leftViewMode = UITextFieldViewModeAlways;
    self.inputTF.leftView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 10, 0)];
    self.inputTF.rightViewMode = UITextFieldViewModeAlways;
    self.inputTF.rightView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 10, 0)];
    [self.inputTF addTarget:self action:@selector(inputTFtextBegin:) forControlEvents:UIControlEventEditingDidBegin];
    [self.inputTF addTarget:self action:@selector(inputTFtextChange:) forControlEvents:UIControlEventEditingChanged];
    [self.inputTF addTarget:self action:@selector(inputTFtextEnd:) forControlEvents:UIControlEventEditingDidEnd];
    self.inputTF.font = [UIFont systemFontOfSize:14];
    [self addSubview:self.inputTF];
    
    self.btnPlaceholder = [[UIButton alloc] init];
    self.btnPlaceholder.userInteractionEnabled = NO;
    [self.btnPlaceholder wb_setImageName:@"list_icon_search"];
    [self.btnPlaceholder setAttributedTitle:createAttString(@"搜索顾客", 14, rgba(153, 153, 153, 1)) forState:UIControlStateNormal];
    self.btnPlaceholder.imageEdgeInsets = UIEdgeInsetsMake(0, -4.5, 0, 4.5);
    [self addSubview:self.btnPlaceholder];
    [self.btnPlaceholder sizeToFit];
    
    self.cancleBtn = [[UIButton alloc] init];
    [self.cancleBtn addTarget:self action:@selector(cancleBtnClick:) forControlEvents:UIControlEventTouchUpInside];
    self.cancleBtn.alpha =0;
    [self.cancleBtn setAttributedTitle:createAttString(@"取消", 14,rgba(76, 74, 66, 1)) forState:UIControlStateNormal];
    [self addSubview:self.cancleBtn];

    
}

- (void)layoutSubviews {
    [super layoutSubviews];
    if (self.inputTF.frame.size.width<10) {
        self.btnPlaceholder.center = CGPointMake(self.bounds.size.width/2, self.bounds.size.height/2);
        self.inputTF.frame = self.bounds;
        self.inputTF.layer.cornerRadius = self.bounds.size.height / 2;
        self.inputTF.layer.masksToBounds = YES;
        self.cancleBtn.frame = CGRectMake(self.bounds.size.width-60, 0, 60, self.bounds.size.height);
    }

}
- (void)inputTFtextBegin:(UITextField *)tf {
    if (self.valueChangeBlock) {
        self.valueChangeBlock(@"", NO);
    }

    [UIView animateWithDuration:0.1 animations:^{
        self.btnPlaceholder.center = CGPointMake(self.btnPlaceholder.frame.size.width/2+20, self.bounds.size.height/2);
        self.inputTF.frame = CGRectMake(0, 0, self.bounds.size.width-60,  self.bounds.size.height);
        self.cancleBtn.alpha = 1;
    }];

}

- (void)inputTFtextChange:(UITextField *)tf {
    self.btnPlaceholder.hidden = tf.text.length;
    if (self.valueChangeBlock) {
        self.valueChangeBlock(tf.text, YES);
    }

}
- (void)inputTFtextEnd:(UITextField *)tf {
    if (self.valueChangeBlock) {
        self.valueChangeBlock(@"", YES);
    }
    
    [UIView animateWithDuration:0.1 animations:^{
        self.btnPlaceholder.center = CGPointMake(self.bounds.size.width/2, self.bounds.size.height/2);
        self.inputTF.frame = CGRectMake(0, 0, self.bounds.size.width,  self.bounds.size.height);
        self.cancleBtn.alpha =0;

    }];
 
}

- (void)cancleBtnClick:(UIButton *)btn {
    self.inputTF.text = @"";
    [self.inputTF sendActionsForControlEvents:UIControlEventEditingChanged];
    [self.inputTF endEditing:YES];
}

@end
